/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.jdbc;

import com.sigge.filerunner.completion.domain.EntityName;
import java.util.ArrayList;
import java.util.Collections;

public class JDBCName
implements EntityName {
    private final String server;
    private final String database;
    private final String schema;
    private final String name;
    private final String originalName;

    public JDBCName(String name) {
        this.originalName = name;
        int state = 0;
        ArrayList<StringBuilder> parts = new ArrayList<StringBuilder>();
        int curr = 0;
        int i = 0;
        while (i < name.length()) {
            String s = name.substring(i, i + 1);
            if (state == 0) {
                if (parts.size() == curr) {
                    parts.add(new StringBuilder());
                }
                if (s.equals("[")) {
                    state = 1;
                } else if (s.equals("\"")) {
                    state = 4;
                } else if (s.equals(".")) {
                    ++curr;
                    state = 0;
                } else {
                    ((StringBuilder)parts.get(curr)).append(s);
                    state = 0;
                }
            } else if (state == 1) {
                if (s.equals("]")) {
                    state = 3;
                } else {
                    ((StringBuilder)parts.get(curr)).append(s);
                }
            } else if (state == 3) {
                if (s.equals("]")) {
                    ((StringBuilder)parts.get(curr)).append(s);
                    state = 1;
                } else {
                    ++curr;
                    state = 0;
                }
            } else if (state == 4) {
                if (s.equals("\"")) {
                    state = 5;
                } else {
                    ((StringBuilder)parts.get(curr)).append(s);
                }
            } else if (state == 5) {
                if (s.equals("\"")) {
                    ((StringBuilder)parts.get(curr)).append(s);
                    state = 4;
                } else {
                    ++curr;
                    state = 0;
                }
            }
            ++i;
        }
        Collections.reverse(parts);
        this.server = parts.size() >= 4 ? ((StringBuilder)parts.get(3)).toString() : "";
        this.database = parts.size() >= 3 ? ((StringBuilder)parts.get(2)).toString() : "";
        this.schema = parts.size() >= 2 ? ((StringBuilder)parts.get(1)).toString() : "";
        this.name = parts.size() >= 1 ? ((StringBuilder)parts.get(0)).toString() : "";
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }
}

