/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.SQLIndex;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.DoubleIndexedList;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.ddl.DDLObject;
import com.sigge.filerunner.sql.ddl.DDLObjectSecondary;
import com.sigge.filerunner.sql.ddl.DDLOperation;
import com.sigge.filerunner.sql.ddl.IDDLClause;
import com.sigge.filerunner.sql.edit.ColumnListCheck;
import com.sigge.filerunner.sql.edit.ColumnPlace;
import com.sigge.filerunner.sql.edit.HolderState;
import com.sigge.filerunner.sql.edit.ISQLColumnTableListener;
import com.sigge.filerunner.sql.edit.InsertHolder;
import com.sigge.filerunner.sql.edit.ParsingContext;
import com.sigge.filerunner.sql.edit.SQLServerUtils;
import com.sigge.filerunner.sql.sqlserver.ColumnFrom;
import com.sigge.filerunner.sql.sqlserver.CreateColumn;
import com.sigge.filerunner.sql.sqlserver.SQLServerDatabaseContext;
import com.sigge.filerunner.sql.sqlserver.SQLServerSQLService;
import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.sqlserver.parser.If;
import com.sigge.filerunner.sql.sqlserver.parser.View;
import com.sigge.filerunner.sql.sqlserver.parser.ddl.ColumnOrder;
import com.sigge.filerunner.sql.sqlserver.parser.ddl.CreateIndex;
import com.sigge.filerunner.sql.sqlserver.parser.ddl.DDLCreateTable;
import com.sigge.filerunner.sql.sqlserver.parser.ddl.IExistingOnly;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.dml.AssignVariable;
import com.sigge.filerunner.sql.transform.dml.BaseTarget;
import com.sigge.filerunner.sql.transform.dml.Execute;
import com.sigge.filerunner.sql.transform.dml.FetchFromCursor;
import com.sigge.filerunner.sql.transform.dml.InsertQuery;
import com.sigge.filerunner.sql.transform.dml.InsertSource;
import com.sigge.filerunner.sql.transform.dml.MergeInsert;
import com.sigge.filerunner.sql.transform.dml.MergeQuery;
import com.sigge.filerunner.sql.transform.dml.MergeUpdate;
import com.sigge.filerunner.sql.transform.dml.SelectColumn;
import com.sigge.filerunner.sql.transform.dml.SelectQuery;
import com.sigge.filerunner.sql.transform.dml.UpdateQuery;
import com.sigge.filerunner.sql.transform.dml.UpdateTarget;
import com.sigge.filerunner.sql.transform.dml.WhenMatches;
import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.ColumnNameExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.FullExpression;
import com.sigge.filerunner.sql.transform.expression.Output;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.expression.SearchConditionNot;
import com.sigge.filerunner.sql.transform.expression.TerminalExpression;
import com.sigge.filerunner.sql.transform.expression.scalars.ArgumentExpression;
import com.sigge.filerunner.sql.transform.expression.scalars.FunctionCall;
import com.sigge.filerunner.sql.transform.expression.scalars.VariableExpression;
import com.sigge.filerunner.sql.transform.expression.scalars.aggregate.AggregateFunction;
import com.sigge.filerunner.sql.transform.parameter.ParameterValue;
import com.sigge.filerunner.sql.transform.select.source.DerivedTable;
import com.sigge.filerunner.sql.transform.select.source.SourceType;
import com.sigge.filerunner.sql.transform.select.source.Table;
import com.sigge.filerunner.sql.transform.select.source.TableValues;
import com.sigge.filerunner.sql.transform.select.source.TableVariable;
import com.sigge.filerunner.sql.transform.select.source.join.Apply;
import com.sigge.filerunner.sql.transform.select.source.join.BaseJoin;
import com.sigge.filerunner.sql.transform.select.source.join.CrossJoin;
import com.sigge.filerunner.sql.transform.select.source.join.JoinExpression;
import com.sigge.filerunner.sql.transform.select.source.join.MergeJoin;
import com.sigge.filerunner.sql.transform.select.source.join.OldStyleJoin;
import com.sigge.filerunner.sql.transform.set.Set;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLService {
    private static final SQLObjectType[] DEFAULT_TABLE_SOURCES = new SQLObjectType[]{SQLObjectType.TABLE, SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.TABLE_FUNCTION, SQLObjectType.VIEW};
    private final IServerContext serverContext;
    private final DatabaseContext context;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLService.class);

    public SQLService(IServerContext serverContext, DatabaseContext context) {
        this.serverContext = serverContext;
        this.context = context;
    }

    public String aliasOrName(SelectColumnsHolder holder) {
        if (holder.getAlias() != null) {
            return this.context.getNormalizedIdentifier(holder.getAlias());
        }
        if (holder.getName() != null) {
            return holder.getName();
        }
        return null;
    }

    public List<String> getColumns(SelectColumnsHolder x, ParsingContext parsingContext, Optional<ISQLColumnTableListener> listener) {
        return this.getColumns(x, parsingContext, listener, false).stream().map(Tuple::first).collect(Collectors.toList());
    }

    public List<Tuple<String, SelectColumn>> getColumns(SelectColumnsHolder x, ParsingContext parsingContext, Optional<ISQLColumnTableListener> listener, boolean includeAllColumns) {
        String fullname;
        Expression xx;
        ArrayList<Tuple<String, SelectColumn>> sc = new ArrayList<Tuple<String, SelectColumn>>();
        List<SelectColumn> colz = new ArrayList<SelectColumn>();
        ArrayList<ColumnFrom> cols = new ArrayList<ColumnFrom>();
        List<ColumnFrom> cols2 = SelectColumnsHolder.getColumns(x, cols);
        ArrayList<Tuple<String, SelectColumn>> sc2 = sc;
        for (ColumnFrom cf : cols) {
            colz.add(cf.getColumn());
        }
        int i = 0;
        if (cols2.size() > 0) {
            i = 1;
        }
        int j = 0;
        while (j <= i) {
            if (j == 1) {
                sc = new ArrayList();
                colz = cols2.stream().map(e -> e.getColumn()).collect(Collectors.toList());
            }
            for (SelectColumn selectColumn : colz) {
                if (selectColumn.getTableNameOrAlias() != null) {
                    Optional<SelectColumnsHolder> hh = this.findHolderFromTableOrAlias(x, selectColumn.getTableNameOrAlias(), ColumnPlace.NORMAL, parsingContext);
                    if (!hh.isPresent()) {
                        listener.ifPresent(f -> f.acceptUnresolvedTableAlias(selectColumn, selectColumn.getTableNameOrAlias().fullName()));
                    }
                    if (selectColumn.isAllStar()) {
                        if (!hh.isPresent()) continue;
                        sc.addAll(this.getColumns(hh.get(), parsingContext, listener, false));
                        continue;
                    }
                    if (!hh.isPresent()) continue;
                    String name = selectColumn.getTableNameOrAlias().getName();
                    boolean exists = this.containsColumn(name, Arrays.asList(hh.get()), parsingContext, listener, true, null, ColumnPlace.NORMAL);
                    if (exists) {
                        sc.add((Tuple<String, SelectColumn>)Tuple.of((Object)name, (Object)selectColumn));
                        continue;
                    }
                    sc.add((Tuple<String, SelectColumn>)Tuple.of((Object)name, (Object)selectColumn));
                    listener.ifPresent(f -> f.acceptUnresolvedColumn(selectColumn));
                    continue;
                }
                if (selectColumn.isAllStar()) {
                    for (SelectColumnsHolder xx2 : x.getFroms()) {
                        sc.addAll(this.getColumns(xx2, parsingContext, listener, false));
                    }
                    continue;
                }
                if (selectColumn.getColumn() == null) continue;
                Expression sn = selectColumn.getColumn();
                if (sn instanceof BaseExpression) {
                    sc.add((Tuple<String, SelectColumn>)Tuple.of((Object)((BaseExpression)sn).getValue(), (Object)selectColumn));
                    continue;
                }
                String alias = selectColumn.getAlias();
                if (alias != null) {
                    sc.add((Tuple<String, SelectColumn>)Tuple.of((Object)alias, (Object)selectColumn));
                } else if (sn instanceof FullExpression && ((FullExpression)sn).getFullExpression() instanceof ColumnNameExpression) {
                    ColumnNameExpression cxx = (ColumnNameExpression)((FullExpression)sn).getFullExpression();
                    if (cxx != null) {
                        String col = cxx.getColumnName() != null ? cxx.getColumnName().getName() : cxx.getValue();
                        sc.add((Tuple<String, SelectColumn>)Tuple.of((Object)col, (Object)selectColumn));
                    }
                } else if (includeAllColumns) {
                    sc.add((Tuple<String, SelectColumn>)Tuple.of((Object)((FullExpression)sn).getFullExpression().toString(), (Object)selectColumn));
                }
                if (!listener.isPresent()) continue;
                this.processExpression(x, parsingContext, listener.get(), selectColumn, sn, ColumnPlace.NORMAL);
            }
            ++j;
        }
        if (colz.size() == 0 && x.getSource() != null && (xx = x.getSource().getSource()) != null && (xx instanceof Table || xx instanceof TableVariable || xx instanceof FunctionCall) && (fullname = x.getFullName()) != null) {
            List<SQLObject> obj;
            if (xx instanceof Table && !x.isCTE()) {
                Optional<Object> XX = Optional.empty();
                SelectColumnsHolder xy = x;
                while ((xy = xy.getParent()) != null && !(XX = xy.getFroms().stream().filter(SelectColumnsHolder::isCTE).filter(a -> this.aliasOrName((SelectColumnsHolder)a) != null && this.context.isSameIdentifier(this.aliasOrName((SelectColumnsHolder)a), fullname)).findFirst()).isPresent()) {
                }
                if (XX.isPresent()) {
                    return this.getColumns((SelectColumnsHolder)XX.get(), parsingContext, listener, false);
                }
            }
            if ((obj = this.getObjectFromName(this.serverContext, this.context, fullname, parsingContext, listener, new SQLObjectType[0])).size() > 0) {
                sc.addAll(obj.get(0).getColumns().stream().map(so -> Tuple.of((Object)so.getName(), null)).collect(Collectors.toList()));
            }
            if (obj.size() == 0) {
                listener.ifPresent(f -> f.acceptUnresolvedTableSource(x.getSource()));
            } else if (listener.isPresent() && xx instanceof FunctionCall) {
                FunctionCall call = (FunctionCall)xx;
                obj = this.getObjectFromName(this.serverContext, this.context, fullname, parsingContext, listener, SQLObjectType.TABLE_FUNCTION, SQLObjectType.INLINE_TABLE_FUNCTION);
                if (call.getArguments().size() > 0) {
                    if (obj.size() > 0) {
                        this.innerExpression(call.getArguments(), x, parsingContext, listener.get(), null);
                    } else if (call.getArguments().size() > 1 || !(call.getArguments().get(0) instanceof FullExpression)) {
                        listener.get().acceptErrorMessage(call.getTree(), call.getTreeAsContext(), "Object looks like a table but has parameters, if you inteded a hint, use WITH", false);
                    }
                }
            }
        }
        if (listener.isPresent()) {
            DerivedTable dt;
            this.innerExpression(SQLService.getSafeExpression(x.getWhere()), x, parsingContext, listener.get(), null);
            this.innerExpression(SQLService.getSafeExpression(x.getHaving()), x, parsingContext, listener.get(), null);
            if (x.getGroupBy() != null) {
                this.innerExpression(x.getGroupBy(), x, parsingContext, listener.get(), null);
            }
            this.innerExpression(SQLService.getSafeExpression(x.getOrderBy()), x, parsingContext, listener.get(), null, ColumnPlace.ORDERBY);
            if (x.getSource() != null && x.getSource().getSource() instanceof DerivedTable && (dt = (DerivedTable)x.getSource().getSource()).getTableExpression() instanceof TableValues) {
                TableValues tv = (TableValues)dt.getTableExpression();
                HashSet<Integer> expSizes = new HashSet<Integer>();
                for (List<Expression> exps : tv.getValues()) {
                    this.innerExpression(exps, x, parsingContext, listener.get(), null);
                    expSizes.add(exps.size());
                }
                if (expSizes.size() > 1) {
                    listener.get().acceptErrorMessage(dt.getTreeAsContext(), "There are different number of values, all values must have same number of column/expressions");
                }
                if (expSizes.size() == 1 && x.getTableSourceColumnAliases().size() > 0 && x.getTableSourceColumnAliases().size() != ((Integer)expSizes.stream().findFirst().get()).intValue()) {
                    listener.get().acceptErrorMessage(dt.getTreeAsContext(), "There are different number of values: " + expSizes.stream().findFirst().get() + " vs aliases: " + x.getTableSourceColumnAliases().size());
                }
            }
            if (x.getJoin() != null) {
                JoinExpression join = x.getJoin();
                if (join instanceof BaseJoin) {
                    BaseJoin bj = (BaseJoin)join;
                    this.innerExpression(SQLService.getSafeExpression(bj.getJoinOn()), x, parsingContext, listener.get(), null, ColumnPlace.JOINED);
                } else if (join instanceof MergeJoin) {
                    this.innerExpression(SQLService.getSafeExpression(((MergeJoin)join).getCondition()), x, parsingContext, listener.get(), null, ColumnPlace.JOINED);
                }
            }
        }
        return sc2;
    }

    static List<? extends Expression> getSafeExpression(Expression ex) {
        if (ex == null) {
            return Collections.EMPTY_LIST;
        }
        return ex.getExpressions();
    }

    public void processClause(Clause cl, SelectColumnsHolder holder, ParsingContext parseContext, ISQLColumnTableListener listener) {
        if (cl instanceof IDDLClause) {
            IDDLClause ddl = (IDDLClause)cl;
            DDLObject ddlObject = ddl.getDdlObject();
            this.verifyDDLObject(parseContext, listener, ddl, ddlObject);
        }
        if (cl instanceof If) {
            If iff = (If)cl;
            this.innerExpression(SQLService.getSafeExpression(iff.getCondition()), holder, parseContext, listener, null);
        } else if (cl instanceof SelectQuery) {
            SelectQuery s = (SelectQuery)cl;
            for (AssignVariable ass : s.getAssignments()) {
                if (ass.getVariable() != null) {
                    this.resolveVariable(parseContext, ass.getVariable().getTerminal(), ass.getVariable().getToken(), listener);
                }
                if (ass.getAssignment() == null) continue;
                this.processExpression(holder, parseContext, listener, null, ass.getAssignment(), ColumnPlace.NORMAL);
            }
        }
        if (cl instanceof Execute) {
            Execute exec = (Execute)cl;
            if (exec.getProcName() != null && exec.getProcName() instanceof SQLName) {
                List<SQLObject> la;
                SQLName name;
                ParserRuleContext procContext = exec.getContext();
                if (exec.getReturnValue() != null) {
                    this.innerExpression(Arrays.asList(exec.getReturnValue()), null, parseContext, listener, null, ColumnPlace.NORMAL);
                }
                if (exec.getExecute() == null) {
                    listener.acceptMessage(exec.getStartToken().orElse(procContext.getStart()), "Executing without EXEC is not recommended", true);
                }
                if ((name = (SQLName)exec.getProcName()).getTokenSource() instanceof ParserRuleContext) {
                    procContext = (ParserRuleContext)name.getTokenSource();
                }
                if ((la = this.getObjectFromName(this.serverContext, this.context, name.fullName(), parseContext, Optional.ofNullable(listener), SQLObjectType.STORED_PROCEDURE)).size() == 0) {
                    listener.acceptUnresolvedObject(procContext, "Stored procedure " + name.fullName());
                } else {
                    SQLObject sqlObject = la.get(0);
                    if (!"X".equalsIgnoreCase(sqlObject.getNativeType())) {
                        DoubleIndexedList<ISQLColumn> procParams = new DoubleIndexedList<ISQLColumn>(sqlObject.getParameters(), ISQLColumn::getName, true);
                        List<ParameterValue> execParams = exec.getParameters();
                        if (procParams.size() < execParams.size()) {
                            listener.acceptErrorMessage(procContext, "Procedure only has " + procParams.size() + " params but " + execParams.size() + " was passed");
                            return;
                        }
                        HashMap<String, ParameterValue> hashMap = new HashMap<String, ParameterValue>();
                        boolean namedStarted = false;
                        int i = 0;
                        while (i < execParams.size()) {
                            ParameterValue pv = execParams.get(i);
                            String name2 = pv.getName();
                            if (name2 != null) {
                                namedStarted = true;
                            } else {
                                name2 = procParams.get(i).getName();
                                if (namedStarted) {
                                    listener.acceptErrorMessage(pv.getTree(), null, "Cannot used unnamed parameters after named ones", false);
                                }
                            }
                            if (name2 != null) {
                                if (!procParams.contains(name2)) {
                                    listener.acceptErrorMessage(pv.getParamNameOrValueContext(), null, "Parameter " + name2 + " doesn't exist in the procedure", false);
                                }
                                if (hashMap.containsKey(name2.toUpperCase())) {
                                    listener.acceptErrorMessage(pv.getParamNameOrValueContext(), null, "Parameter " + name2 + " is used more than once", false);
                                } else {
                                    hashMap.put(name2.toUpperCase(), pv);
                                }
                            } else {
                                listener.acceptErrorMessage(pv.getParamNameOrValueContext(), null, "Parameter #" + i + " couldn't get resolved by position", false);
                            }
                            if (pv.getParameterValue() != null) {
                                this.innerExpression(Arrays.asList(pv.getParameterValue()), null, parseContext, listener, null, ColumnPlace.NORMAL);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < procParams.size()) {
                            ISQLColumn obj = procParams.get(i);
                            if (!hashMap.containsKey(obj.getName().toUpperCase()) && obj.getDefault() == null && !this.isTableType(obj.getType())) {
                                listener.acceptErrorMessage(procContext, "Parameter " + obj.getName() + " wasn't passed and no default exist");
                            }
                            ++i;
                        }
                    }
                }
            } else if (exec.getProcName() != null) {
                Expression ex = exec.getProcName();
                this.innerExpression(Arrays.asList(ex), null, parseContext, listener, null);
            }
        } else if (cl instanceof Set) {
            Set set = (Set)cl;
            this.processSet(parseContext, holder, listener, set);
        } else if (cl instanceof CreateIndex) {
            new ColumnListCheck(((CreateIndex)cl).getColumnsInclude()).validate(listener);
            new ColumnListCheck(((CreateIndex)cl).getColumns().stream().map(ColumnOrder::getName)).validate(listener);
        } else if (cl instanceof DDLCreateTable) {
            new ColumnListCheck(((DDLCreateTable)cl).getColumns().stream().map(CreateColumn::getName)).validate(listener);
        } else if (cl instanceof View) {
            SelectQuery query = ((View)cl).getQuery();
            if (query != null) {
                Optional<SelectColumnsHolder> holdon = new SQLServerSQLService().createHolder(query);
                if (holdon.isPresent()) {
                    List<Tuple<String, SelectColumn>> cols = this.getColumns(holdon.get(), parseContext, Optional.empty(), true);
                    HashSet<String> strings = new HashSet<String>();
                    for (Tuple<String, SelectColumn> col : cols) {
                        Tuple<Boolean, Token> exp;
                        SelectColumn sc = (SelectColumn)col.second();
                        String string = (String)col.first();
                        if (string != null && strings.contains(string.toLowerCase())) {
                            Optional<Object> t;
                            Optional<Object> optional = t = sc != null ? sc.getStartToken() : Optional.empty();
                            if (t.isPresent()) {
                                listener.acceptMessage((Token)t.get(), "Duplicate column: " + string, false);
                            } else {
                                Optional<Token> startToken = query.getStartToken();
                                if (startToken.isPresent()) {
                                    listener.acceptMessage(startToken.get(), "Duplicate column: " + string, false);
                                } else {
                                    listener.acceptErrorMessage((ParseTree)holdon.get().getContext(), holdon.get().getContext(), "Duplicate column: " + string, false);
                                }
                            }
                        } else if (string != null) {
                            strings.add(string.toLowerCase());
                        }
                        if (sc == null || sc.isAllStar() || StringUtils.isNotEmpty(sc.getAlias()) || !((Boolean)(exp = SQLService.isExpression(sc)).first()).booleanValue()) continue;
                        listener.acceptMessage((Token)exp.second(), "Expression without alias not allowed in view", false);
                    }
                }
                if (query.getOrderBy() != null) {
                    listener.acceptMessage(query.getOrderBy().getStartToken().get(), "Order by in view should be avoided", true);
                }
            }
        } else if (cl instanceof UpdateQuery) {
            UpdateQuery update = (UpdateQuery)cl;
            HashSet<String> names = new HashSet<String>();
            for (Set s : update.getSetExpressions()) {
                SQLName columnName;
                ColumnNameExpression column;
                this.processSet(parseContext, holder, listener, s);
                if (s.getType() != Set.SetType.COLUMN && s.getType() != Set.SetType.COLUMN_MODIFY || (column = s.getColumn()) == null || (columnName = column.getColumnName()) == null || !StringUtils.isNotEmpty(columnName.getName())) continue;
                String name = columnName.getName().toLowerCase();
                if (names.contains(name)) {
                    if (s.getContext() == null || s.getContext().start == null) continue;
                    listener.acceptMessage(s.getContext().start, "Can only set " + (s.getType() == Set.SetType.COLUMN ? "column" : "variable") + " " + names + " once", false);
                    continue;
                }
                names.add(name);
            }
            UpdateTarget updateTarget = update.getUpdateTarget();
            if (updateTarget != null) {
                if (updateTarget.getTable() != null) {
                    Object la;
                    Optional<SelectColumnsHolder> zz = this.findHolderFromTableOrAlias(holder, updateTarget.getTable().fullName(), ColumnPlace.NORMAL, parseContext);
                    if (!zz.isPresent() && (la = this.getObjectFromName(this.serverContext, this.context, updateTarget.getTable().fullName(), parseContext, Optional.ofNullable(listener), DEFAULT_TABLE_SOURCES)).size() == 0) {
                        listener.acceptUnresolvedObject((ParserRuleContext)updateTarget.getTree(), "Update target " + updateTarget.getTable().fullName());
                    }
                } else if (updateTarget.getTableVariable() != null) {
                    this.resolveVariable(parseContext, updateTarget.getTableVariable().getValue(), updateTarget.getTableVariable().getToken(), listener);
                }
                for (Output out : update.getOutputClauses()) {
                    if (!out.getTarget().isPresent()) continue;
                    SQLServerUtils.validateInsert(this.serverContext, this.context, new InsertHolder(holder, out.getTarget().get(), new InsertHolder.SelectColumns(out.getSelectColumnList()), out.getInsertColumnList(), InsertHolder.InsertType.OUTPUT_INSERT), parseContext, listener, this);
                }
            }
        } else if (cl instanceof MergeQuery) {
            MergeQuery merge = (MergeQuery)cl;
            BaseTarget target = merge.getTarget();
            if (target != null) {
                if (target.getTable() != null) {
                    Object la;
                    Optional<SelectColumnsHolder> zz = this.findHolderFromTableOrAlias(holder, target.getTable().fullName(), ColumnPlace.NORMAL, parseContext);
                    if (!zz.isPresent() && (la = this.getObjectFromName(this.serverContext, this.context, target.getTable().fullName(), parseContext, Optional.ofNullable(listener), DEFAULT_TABLE_SOURCES)).size() == 0) {
                        listener.acceptUnresolvedObject((ParserRuleContext)target.getTree(), "Merge target " + target.getTable().fullName());
                    }
                } else if (target.getTableVariable() != null) {
                    this.resolveVariable(parseContext, target.getTableVariable().getValue(), target.getTableVariable().getToken(), listener);
                }
            }
            for (Output out : merge.getOutputClauses()) {
                if (!out.getTarget().isPresent()) continue;
                SQLServerUtils.validateInsert(this.serverContext, this.context, new InsertHolder(holder, out.getTarget().get(), new InsertHolder.SelectColumns(out.getSelectColumnList()), out.getInsertColumnList(), InsertHolder.InsertType.OUTPUT_INSERT), parseContext, listener, this);
            }
            int merged_not_matched_by_target = 0;
            int merged_not_matched_by_source = 0;
            int merged_matched = 0;
            int merged_matched_deleted = 0;
            int merged_matched_updated = 0;
            block17: for (WhenMatches whenMatches : merge.getMatches()) {
                switch (whenMatches.getMergeType()) {
                    case WHEN_MATCHES: {
                        ++merged_matched;
                        if (whenMatches.getAction() == WhenMatches.MergeAction.DELETE) {
                            ++merged_matched_deleted;
                        } else if (whenMatches.getAction() == WhenMatches.MergeAction.UPDATE) {
                            ++merged_matched_updated;
                        } else {
                            listener.acceptErrorMessage(whenMatches.getInnerContext(), "INSERT action isn't allowed for WHEN MATCHED");
                        }
                        if (merged_matched > 2) {
                            listener.acceptErrorMessage(whenMatches.getInnerContext(), "Max two WHEN MATCHED by target clause is allowed");
                            break;
                        }
                        if (merged_matched != 2 || merged_matched_deleted == merged_matched_updated) break;
                        listener.acceptErrorMessage(whenMatches.getInnerContext(), "For when matched, the action must be one DELETE and one UPDATE");
                        break;
                    }
                    case WHEN_NOT_MATCHES_SOURCE: {
                        ++merged_not_matched_by_source;
                        break;
                    }
                    case WHEN_NOT_MATCHES_TARGET: {
                        if (++merged_not_matched_by_target <= 1) break;
                        listener.acceptErrorMessage(whenMatches.getInnerContext(), "Only one WHEN NOT MATCHED BY TARGET clause is allowed");
                        break;
                    }
                }
                SearchConditionNot cond = whenMatches.getCondition();
                if (cond != null) {
                    this.innerExpression(cond.getExpressions(), holder, parseContext, listener, null);
                }
                if (whenMatches.getAction() == null) continue;
                switch (whenMatches.getAction()) {
                    case DELETE: {
                        break;
                    }
                    case INSERT: {
                        MergeInsert insert = whenMatches.getMergeInsert();
                        if (insert == null) continue block17;
                        InsertHolder insertHolder = new InsertHolder(holder, merge.getTarget(), InsertHolder.SelectColumns.fromMergeInsert(insert), insert.getColumnList(), whenMatches.getMergeType() == WhenMatches.MergeWhen.WHEN_NOT_MATCHES_SOURCE ? InsertHolder.InsertType.OUTPUT_INSERT_NOT_MATCHED : InsertHolder.InsertType.OUTPUT_INSERT_MERGE_MATCHED);
                        SQLServerUtils.validateInsert(this.serverContext, this.context, insertHolder, parseContext, listener, this);
                        break;
                    }
                    case UPDATE: {
                        MergeUpdate update = whenMatches.getMergeUpdate();
                        if (update == null) continue block17;
                        HashSet<String> names = new HashSet<String>();
                        for (Set s : update.getSetExpressions()) {
                            SQLName columnName;
                            ColumnNameExpression column;
                            this.processSet(parseContext, holder, listener, s);
                            if (s.getType() != Set.SetType.COLUMN && s.getType() != Set.SetType.COLUMN_MODIFY || (column = s.getColumn()) == null || (columnName = column.getColumnName()) == null || !StringUtils.isNotEmpty(columnName.getName())) continue;
                            String name = columnName.getName().toLowerCase();
                            if (names.contains(name)) {
                                if (s.getContext() == null || s.getContext().start == null) continue;
                                listener.acceptMessage(s.getContext().start, "Can only set variable once", false);
                                continue;
                            }
                            names.add(name);
                        }
                        continue block17;
                    }
                }
            }
        } else if (cl instanceof Expression && ((Expression)((Object)cl)).getExpressions().size() > 0) {
            this.innerExpression(((Expression)((Object)cl)).getExpressions(), holder, parseContext, listener, null);
        } else if (cl instanceof FetchFromCursor) {
            FetchFromCursor ffc = (FetchFromCursor)cl;
            for (VariableExpression var : ffc.getVariables()) {
                this.resolveVariable(parseContext, var.getTerminal(), var.getToken(), listener);
            }
        } else if (cl instanceof InsertQuery) {
            SelectQuery sq;
            InsertQuery insert = (InsertQuery)cl;
            InsertSource is = insert.getSource();
            if (is == null) {
                return;
            }
            InsertHolder.SelectColumns sh = is.isDefaultValues() ? InsertHolder.SelectColumns.DEFAULT_VALUES : (is.getExec() != null ? new InsertHolder.SelectColumns(is.getExec()) : (is.getDerivedTable() != null && is.getDerivedTable().getTableExpression() instanceof TableValues ? new InsertHolder.SelectColumns((TableValues)is.getDerivedTable().getTableExpression()) : new InsertHolder.SelectColumns(holder != null ? this.getColumns(holder, parseContext, Optional.empty(), true).stream().map(Tuple::first).map(mn -> new SelectColumn(new SQLName((String)mn))).collect(Collectors.toList()) : Collections.EMPTY_LIST)));
            SQLServerUtils.validateInsert(this.serverContext, this.context, new InsertHolder(holder, insert.getTarget(), sh, insert.getColumnList(), InsertHolder.InsertType.NORMAL), parseContext, listener, this);
            for (Output out : insert.getOutputClauses()) {
                if (!out.getTarget().isPresent()) continue;
                SQLServerUtils.validateInsert(this.serverContext, this.context, new InsertHolder(holder, out.getTarget().get(), new InsertHolder.SelectColumns(out.getSelectColumnList()), out.getInsertColumnList(), InsertHolder.InsertType.OUTPUT_INSERT), parseContext, listener, this);
            }
            if (insert.getSource() != null && insert.getSource().getQuery() != null && (sq = insert.getSource().getQuery()).getInto() != null) {
                listener.acceptMessage(sq.getIntoToken(), "INSERT and INTO cannot be combined", false);
            }
        }
    }

    private void verifyDDLObject(ParsingContext parseContext, ISQLColumnTableListener listener, IDDLClause ddl, DDLObject ddlObject) {
        SQLName name;
        SQLName sQLName = name = ddlObject != null ? ddlObject.getName() : null;
        if (!(ddlObject == null || ListUtils.in((Object)ddl.getDdlOperation(), (Object[])new DDLOperation[]{DDLOperation.CREATE, DDLOperation.CREATE_OR_ALTER}) || name == null || ddlObject.getObjectType().getSQLObjectType() == SQLObjectType.UNKNOWN || ddl instanceof IExistingOnly && ((IExistingOnly)((Object)ddl)).isIfExists())) {
            ArrayList<SQLObject> la = new ArrayList<SQLObject>();
            if (this.context != null && ddlObject.getObjectType().getSQLObjectType() == SQLObjectType.DATABASE) {
                la.addAll(this.context.getDatabases().stream().filter(f -> this.context.isSameIdentifier(name.fullName(), (SQLObject)f)).collect(Collectors.toList()));
            } else {
                la.addAll(this.getObjectFromName(this.serverContext, this.context, name.fullName(), parseContext, Optional.ofNullable(listener), null));
            }
            if (la.size() == 0) {
                listener.acceptErrorMessage(name.getTokenSource(), ddl.getContext(), "Unresolved " + ddlObject.getObjectType().getObjectType() + ": " + name.fullName(), false);
            } else {
                SQLObject o;
                Iterator iterator = la.iterator();
                if (iterator.hasNext() && (o = (SQLObject)iterator.next()).getSQLType() != ddl.getDdlObject().getObjectType().getSQLObjectType()) {
                    listener.acceptErrorMessage(name.getTokenSource(), ddl.getContext(), "Object found but of wrong type: " + (Object)((Object)o.getSQLType()), false);
                    return;
                }
                if (ddl instanceof DDLObjectSecondary) {
                    this.validateMainAndSecondary((SQLObject)la.get(0), ((DDLObjectSecondary)((Object)ddl)).getSecondaries(), listener);
                }
            }
        }
    }

    private void validateMainAndSecondary(SQLObject so, List<DDLObject> x, ISQLColumnTableListener listener) {
        switch (so.getSQLType()) {
            case TABLE: {
                for (DDLObject dd : x) {
                    switch (dd.getObjectType().getSQLObjectType()) {
                        case INDEX: {
                            boolean found = false;
                            for (SQLIndex ix : so.getIndexes()) {
                                if (this.context == null || !this.context.isSameIdentifier(dd.getName().fullName(), ix.getName())) continue;
                                found = true;
                                break;
                            }
                            if (found) break;
                            listener.acceptErrorMessage(dd.getName().getTokenSource(), null, "Unresolved " + dd.getObjectType().getObjectType() + ": " + dd.getName().fullName(), false);
                            break;
                        }
                    }
                }
                break;
            }
        }
    }

    public static Tuple<Boolean, Token> isExpression(SelectColumn sc) {
        Expression column = sc.getColumn();
        if (column != null && column instanceof FullExpression) {
            Optional<Token> ex;
            Expression exp;
            List<Expression> exps = ((FullExpression)column).unwrap();
            if (exps.size() > 1) {
                Optional<Token> ex2 = exps.get(0).getStartToken();
                if (ex2.isPresent()) {
                    return Tuple.of((Object)true, (Object)ex2.get());
                }
            } else if (exps.size() > 0 && !((exp = exps.get(0)) instanceof ColumnNameExpression) && (ex = exps.get(0).getStartToken()).isPresent()) {
                return Tuple.of((Object)true, (Object)ex.get());
            }
        }
        return Tuple.of((Object)false, null);
    }

    private boolean isTableType(String type) {
        if (StringUtils.isNotEmpty(type) && this.serverContext != null && !this.isDefaultType(type)) {
            List<SQLObject> q = this.serverContext.getByName(type, this.context, SQLObjectType.TABLE_TYPE);
            return q.size() > 0;
        }
        return false;
    }

    private boolean isDefaultType(String type) {
        String normalizedIdentifier;
        if (type.contains("(")) {
            return true;
        }
        String string = normalizedIdentifier = this.context != null ? this.context.getNormalizedIdentifier(type.toUpperCase()) : type.toUpperCase();
        if (this.context instanceof SQLServerDatabaseContext) {
            return ((SQLServerDatabaseContext)this.context).getBuiltInTypes().contains(normalizedIdentifier);
        }
        return SQLServerDatabaseContext.getDefaultTypeSet().contains(normalizedIdentifier);
    }

    private void processSet(ParsingContext parseContext, SelectColumnsHolder holder, ISQLColumnTableListener listener, Set set) {
        switch (set.getType()) {
            case GLOBAL_SETTING: {
                break;
            }
            case CURSOR: 
            case VARIABLE: 
            case VARIABLE_MEMBER: 
            case VARIABLE_MODIFY: 
            case VARIABLE_AND_COLUMN: {
                String variable = set.getVariable().getText();
                this.resolveVariable(parseContext, variable, set.getVariable().getSymbol(), listener);
                break;
            }
            case COLUMN: 
            case COLUMN_MODIFY: {
                ColumnNameExpression column = set.getColumn();
                if (column == null) break;
                SQLName columnName = column.getColumnName();
                this.processColumnExpression(holder, parseContext, listener, null, columnName != null ? columnName.getName() : column.getValue(), null, column, ColumnPlace.SET_VALUE);
                if (column.getTableName() == null) break;
                if (!this.findHolderFromTableOrAlias(holder, column.getTableName(), ColumnPlace.NORMAL, parseContext).isPresent()) {
                    listener.acceptUnresolvedTableAlias(column.getTreeAsContext(), column.getTableName().fullName());
                    break;
                }
                listener.acceptMessage(column.getTreeAsContext(), "Alias on \"left\" side of set not needed", true);
            }
        }
        if (set.getExpression() != null) {
            this.processExpression(holder, parseContext, listener, null, set.getExpression(), ColumnPlace.NORMAL);
        }
    }

    public void processExpression(SelectColumnsHolder x, ParsingContext parseContext, ISQLColumnTableListener listener, SelectColumn selectColumn, Expression xx, ColumnPlace matchCurrent) {
        this.innerExpression(xx.getExpressions(), x, parseContext, listener, selectColumn, matchCurrent);
    }

    void innerExpression(List<? extends Expression> exp, SelectColumnsHolder x, ParsingContext parseContext, ISQLColumnTableListener listener, SelectColumn selectColumn) {
        this.innerExpression(exp, x, parseContext, listener, selectColumn, ColumnPlace.NORMAL);
    }

    private void innerExpression(List<? extends Expression> exp, SelectColumnsHolder x, ParsingContext parseContext, ISQLColumnTableListener listener, SelectColumn selectColumn, ColumnPlace matchCurrent) {
        for (Expression expression : exp) {
            if (expression instanceof ColumnNameExpression) {
                ColumnNameExpression xx = (ColumnNameExpression)expression;
                String col = xx.getColumnName() != null ? xx.getColumnName().getName() : xx.getValue();
                SQLName tablename = xx.getTableName() != null && xx.getTableName().toString().length() > 0 ? xx.getTableName() : null;
                this.processColumnExpression(x, parseContext, listener, selectColumn, col, tablename, xx, matchCurrent);
                continue;
            }
            if (expression instanceof ArgumentExpression) {
                AggregateFunction agg;
                this.innerExpression(((ArgumentExpression)((Object)expression)).getArguments(), x, parseContext, listener, selectColumn, matchCurrent);
                if (!(expression instanceof AggregateFunction) || (agg = (AggregateFunction)expression).getOverClause() == null) continue;
                this.processExpression(x, parseContext, listener, selectColumn, agg.getOverClause(), matchCurrent);
                continue;
            }
            if (expression instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)expression;
                this.resolveVariable(parseContext, var.getTerminal(), var.getToken(), listener);
                continue;
            }
            if (expression instanceof TerminalExpression) continue;
            if (expression instanceof SelectQuery) {
                SQLServerSQLService service = new SQLServerSQLService();
                Optional<SelectColumnsHolder> hhh = service.createHolder((SelectQuery)expression);
                if (!hhh.isPresent()) continue;
                if (x != null) {
                    parseContext.addSelectColumnHolder(x);
                    hhh.get().setPrev(x);
                    hhh.get().setComesFromSubquery(true);
                }
                this.getColumns(hhh.get(), parseContext, Optional.of(listener));
                if (x == null) continue;
                parseContext.removeSelectColumnHolder(x);
                continue;
            }
            if (expression == null) {
                LOGGER.error("Null expression detected for holder: {} - {}", (Object)x, exp);
                continue;
            }
            this.processExpression(x, parseContext, listener, selectColumn, expression, matchCurrent);
        }
    }

    private void resolveVariable(ParsingContext parsingcontext, String name, Token token, ISQLColumnTableListener listener) {
        boolean resolved = false;
        for (DeclareBlock declarations : parsingcontext.getDeclaredVariables()) {
            if (declarations.getVariable() == null || !declarations.getVariable().equalsIgnoreCase(name)) continue;
            resolved = true;
            break;
        }
        if (!resolved && token != null && this.serverContext.getByName(name, this.context, new SQLObjectType[0]).size() == 0) {
            listener.acceptMessage(token, "Unresolved variable:" + name, false);
        }
    }

    private void processColumnExpression(SelectColumnsHolder x, ParsingContext parseContext, ISQLColumnTableListener listener, SelectColumn selectColumn, String col, SQLName tableName, BaseExpression xx, ColumnPlace matchCurrent) {
        block11: {
            block8: {
                Optional<SelectColumnsHolder> matchingHolderAlias;
                block9: {
                    block10: {
                        if (tableName == null) break block8;
                        matchingHolderAlias = this.findHolderFromTableOrAlias(x, tableName, matchCurrent, parseContext);
                        if (matchingHolderAlias.isPresent()) break block9;
                        if (xx == null || !(xx instanceof ColumnNameExpression) && selectColumn != null) break block10;
                        listener.acceptUnresolvedTableAlias(xx.getTreeAsContext(), tableName.fullName());
                        break block11;
                    }
                    if (selectColumn == null) break block11;
                    listener.acceptUnresolvedTableAlias(selectColumn, tableName.fullName());
                    break block11;
                }
                if (this.containsColumn(col, Arrays.asList(matchingHolderAlias.get()), parseContext, Optional.ofNullable(listener), true, xx.getTreeAsContext(), matchCurrent)) break block11;
                listener.acceptUnresolvedColumn(xx.getTreeAsContext());
                break block11;
            }
            if (matchCurrent == ColumnPlace.ORDERBY && this.containsColumn(col, Arrays.asList(x), parseContext, Optional.ofNullable(listener), false, xx.getTreeAsContext(), matchCurrent)) {
                return;
            }
            if (x == null) {
                listener.acceptUnresolvedColumn(xx.getTreeAsContext());
                return;
            }
            boolean breakLoop = false;
            List<SelectColumnsHolder> froms = x.getFroms();
            SelectColumnsHolder lastOnLevel = null;
            while (!breakLoop) {
                boolean isAThroughJoin;
                boolean bl = isAThroughJoin = x.getJoin() != null && x.getJoin() instanceof Apply || x.getJoin() == null && x.getSource() != null && x.getSource().getSourceType() == SourceType.DERIVED;
                while (true) {
                    if (this.containsColumn(col, froms, parseContext, Optional.ofNullable(listener), false, xx.getTreeAsContext(), matchCurrent)) {
                        return;
                    }
                    if (!isAThroughJoin || x.getPrev() == null) break;
                    froms = Arrays.asList(x.getPrev());
                    x = x.getPrev();
                }
                if (isAThroughJoin && x.getParent() != null) {
                    List<SelectColumnsHolder> hh = x.getParent().getFroms();
                    SelectColumnsHolder shP = null;
                    for (SelectColumnsHolder h2 : hh) {
                        if (h2 != x) continue;
                        shP = h2.getPrev();
                        lastOnLevel = x;
                        break;
                    }
                    x = shP != null ? shP : x.getParent();
                    ArrayList<SelectColumnsHolder> froms2 = new ArrayList<SelectColumnsHolder>();
                    for (SelectColumnsHolder holder : x.getFroms()) {
                        if (holder == lastOnLevel) break;
                        froms2.add(holder);
                    }
                    froms = froms2;
                    continue;
                }
                listener.acceptUnresolvedColumn(xx.getTreeAsContext());
                breakLoop = true;
            }
        }
    }

    private boolean containsColumn(String column, List<SelectColumnsHolder> cols, ParsingContext parseContext, Optional<ISQLColumnTableListener> listener, boolean hasTableSpecifier, ParserRuleContext pContext, ColumnPlace columnPlace) {
        HashSet<String> columnSet = new HashSet<String>();
        boolean wasFound = false;
        for (SelectColumnsHolder xx : cols) {
            if (xx == null || xx.isCTE()) continue;
            List<String> columns = this.getColumns(xx, parseContext, Optional.empty());
            for (String co : columns) {
                if (!this.context.isSameIdentifier(co, column)) continue;
                if (!hasTableSpecifier && listener.isPresent()) {
                    if (columnSet.contains(co.toLowerCase()) && ColumnPlace.SET_VALUE != columnPlace) {
                        listener.get().acceptErrorMessage(pContext, "Multiple columns matches " + column + ", alias should be specified");
                        return true;
                    }
                    columnSet.add(co.toLowerCase());
                    wasFound = true;
                    continue;
                }
                return true;
            }
        }
        return wasFound;
    }

    private void getColumnsX(SelectColumnsHolder h, List<SelectColumnsHolder> cols, HolderState triState) {
        if (h == null) {
            return;
        }
        if (h.getParent() == null && cols.size() == 0) {
            cols.addAll(h.getFroms());
            return;
        }
        if (triState == HolderState.WITHIN && h.getSource() != null && h.getSource().getSource() instanceof DerivedTable) {
            cols.addAll(h.getFroms());
        }
        if (h.getJoin() == null) {
            cols.add(h);
            if (h.getParent() != null && h.getParent().getJoin() instanceof Apply) {
                this.getColumnsX(h.getParent(), cols, HolderState.OUTOFAPPLY);
                return;
            }
        } else {
            if ((h.getJoin() instanceof BaseJoin || h.getJoin() instanceof CrossJoin || h.getJoin() instanceof OldStyleJoin || h.getJoin() instanceof MergeJoin) && h.getParent() != null) {
                if (h.getSource() != null && triState != HolderState.WITHIN) {
                    this.getColumnsX(h.getPrev(), cols, HolderState.BEFORE);
                    cols.add(h);
                }
            } else if (h.getJoin() instanceof Apply && h.getParent() != null) {
                this.getColumnsX(h.getPrev(), cols, HolderState.BEFORE);
                if (triState != HolderState.OUTOFAPPLY) {
                    cols.add(h);
                }
            }
            if (triState == HolderState.WITHIN && h.getSource() != null && h.getSource().getSource() instanceof DerivedTable) {
                if (h.getJoin() instanceof BaseJoin && h.getParent() != null) {
                    this.getColumnsX(h.getParent(), cols, HolderState.BEFORE);
                } else if (h.getJoin() instanceof Apply && h.getParent() != null) {
                    this.getColumnsX(h.getParent(), cols, HolderState.OUTOFAPPLY);
                }
                return;
            }
            if (h.getSource() != null && h.getSource().getSource() instanceof DerivedTable) {
                if (h.getParent() != null && h.getParent().getJoin() instanceof Apply) {
                    this.getColumnsX(h.getParent(), cols, HolderState.BEFORE);
                }
                return;
            }
        }
    }

    private HolderState isHolderBefore(SelectColumnsHolder h, int caret) {
        if (h.getContext() == null || h.getContext().start == null) {
            return HolderState.UNKNOWN;
        }
        if (h.getContext().start.getStartIndex() >= caret) {
            return HolderState.AFTER;
        }
        if (h.getContext().stop == null) {
            return HolderState.BEFORE_UNKNOWN;
        }
        if (h.getContext().stop.getStopIndex() >= caret) {
            return HolderState.WITHIN;
        }
        return HolderState.BEFORE;
    }

    public List<SelectColumnsHolder> getHolders(Clause file, int caretpos) {
        SQLServerSQLService sc = new SQLServerSQLService();
        SelectColumnsHolder cols = sc.getHolderAtPosition(file, caretpos);
        if (cols == null) {
            return null;
        }
        Tuple<SelectColumnsHolder, HolderState> tp = this.getHolderAtCaret(cols, caretpos);
        SelectColumnsHolder cols2 = (SelectColumnsHolder)tp.first();
        List<SelectColumnsHolder> froms = new ArrayList<SelectColumnsHolder>();
        this.getColumnsX(cols2, froms, (HolderState)((Object)tp.second()));
        if (froms.size() == 0) {
            froms = cols.getFroms();
        }
        return froms;
    }

    private Tuple<SelectColumnsHolder, HolderState> getHolderAtCaret(SelectColumnsHolder h, int caret) {
        return this.getHolderAtCaret(h, caret, HolderState.UNKNOWN);
    }

    private Tuple<SelectColumnsHolder, HolderState> getHolderAtCaret(SelectColumnsHolder h, int caret, HolderState lastState) {
        SelectColumnsHolder lastHolderThatWasntAhead = null;
        int holderCount = -1;
        int i = 0;
        while (i < h.getFroms().size()) {
            SelectColumnsHolder holder = h.getFroms().get(i);
            HolderState state = this.isHolderBefore(holder, caret);
            switch (state) {
                case UNKNOWN: {
                    ++holderCount;
                    break;
                }
                case WITHIN: {
                    lastHolderThatWasntAhead = holder;
                    lastState = HolderState.WITHIN;
                    ++holderCount;
                    break;
                }
                case BEFORE_UNKNOWN: {
                    lastState = HolderState.BEFORE_UNKNOWN;
                    ++holderCount;
                    break;
                }
                case BEFORE: {
                    if (holder.isCTE()) break;
                    lastHolderThatWasntAhead = holder;
                    lastState = HolderState.BEFORE;
                    ++holderCount;
                }
            }
            ++i;
        }
        if (lastHolderThatWasntAhead == null) {
            lastHolderThatWasntAhead = h;
        }
        if (lastState == HolderState.BEFORE && holderCount == h.getFroms().size() - 1 && lastHolderThatWasntAhead.getJoin() != null) {
            ParserRuleContext join = (ParserRuleContext)lastHolderThatWasntAhead.getJoin().getTree();
            if (join != null && join.getStop() != null && join.getStop().getStopIndex() < caret) {
                lastHolderThatWasntAhead = h;
            }
            lastState = HolderState.WITHIN;
        }
        if (lastState == HolderState.WITHIN && lastHolderThatWasntAhead.getSource() != null && lastHolderThatWasntAhead.getSource().getSource() instanceof DerivedTable && h != lastHolderThatWasntAhead) {
            return this.getHolderAtCaret(lastHolderThatWasntAhead, caret, lastState);
        }
        return Tuple.of((Object)lastHolderThatWasntAhead, (Object)((Object)lastState));
    }

    private Optional<SelectColumnsHolder> findHolderFromTableOrAlias(SelectColumnsHolder cols, SQLName alias, ColumnPlace matchCurrent, ParsingContext parseContext) {
        if (alias == null) {
            return Optional.empty();
        }
        return this.findHolderFromTableOrAlias(cols, alias.fullName(), matchCurrent, parseContext);
    }

    Optional<SelectColumnsHolder> findHolderFromTableOrAlias(SelectColumnsHolder cols, String ff, ColumnPlace matchCurrent, ParsingContext parseContext) {
        Optional<SelectColumnsHolder> holder;
        if (ff == null || cols == null) {
            return Optional.empty();
        }
        if (matchCurrent == ColumnPlace.JOINED && this.aliasOrName(cols) != null && this.context.isSameIdentifier(this.aliasOrName(cols), ff)) {
            return Optional.of(cols);
        }
        List<SelectColumnsHolder> holders = cols.getFroms();
        boolean wasApply = false;
        while (true) {
            holder = holders.stream().filter(a -> a != null && this.aliasOrName((SelectColumnsHolder)a) != null && this.context.isSameIdentifier(this.aliasOrName((SelectColumnsHolder)a), ff)).findFirst();
            if (cols == null || holder.isPresent() || !wasApply && matchCurrent != ColumnPlace.JOINED && !cols.isComesFromSubquery() && (!(cols.getJoin() instanceof Apply) || cols.getPrev() == null)) break;
            wasApply = true;
            holders = Arrays.asList(cols.getPrev());
            cols = cols.getPrev();
        }
        if (holder.isPresent()) {
            return holder;
        }
        for (SelectColumnsHolder hho : parseContext.getHolders()) {
            holder = hho.getFroms().stream().filter(a -> a != null && this.aliasOrName((SelectColumnsHolder)a) != null && this.context.isSameIdentifier(this.aliasOrName((SelectColumnsHolder)a), ff)).findFirst();
            if (holder.isPresent()) break;
        }
        return holder;
    }

    public String getMatchingNameByAliasOrName(List<SelectColumnsHolder> froms, String ff) {
        return froms.stream().filter(a -> this.aliasOrName((SelectColumnsHolder)a) != null && this.aliasOrName((SelectColumnsHolder)a).equalsIgnoreCase(ff)).map(e -> {
            if (e.getFullName() != null) {
                return e.getFullName();
            }
            return e.getName() != null ? e.getName() : e.getAlias();
        }).filter(Objects::nonNull).findFirst().orElse("");
    }

    public List<SQLObject> getDeclaredObjectsFromPosition(SQLFile parseTree, int caretpos, Optional<ISQLColumnTableListener> listener) {
        SQLServerSQLService sc = new SQLServerSQLService();
        ArrayList<SQLObject> obs = new ArrayList<SQLObject>();
        obs.addAll(parseTree != null ? SQLServerSQLService.getDeclaredTables(this.serverContext, this.context, parseTree, caretpos) : Collections.EMPTY_LIST);
        obs.addAll(parseTree != null ? SQLServerSQLService.getDeclaredObjects(this.context, parseTree, caretpos) : Collections.EMPTY_LIST);
        ParsingContext parsingContext = new ParsingContext(obs);
        ArrayList<Integer> objectsToRemove = new ArrayList<Integer>();
        int ob = 0;
        while (ob < obs.size()) {
            Optional<SelectColumnsHolder> holdon;
            SelectQuery sq;
            SQLObject so = (SQLObject)obs.get(ob);
            if (this.serverContext.getByName(so.getFullName(), this.context, so.getSQLType()).size() > 0) {
                objectsToRemove.add(ob);
            } else if (so.getColumns().size() == 0 && so.getCustomProperties() != null && (sq = (SelectQuery)so.getCustomProperties().remove("query")) != null && (holdon = sc.createHolder(sq)).isPresent()) {
                for (String sub : this.getColumns(holdon.get(), parsingContext, listener)) {
                    SQLSubObject subx = new SQLSubObject(this.context.getNormalizedIdentifier(sub), null);
                    so.addColumn(subx);
                }
            }
            ++ob;
        }
        int i = objectsToRemove.size() - 1;
        while (i >= 0) {
            obs.remove((Integer)objectsToRemove.get(i));
            --i;
        }
        return obs;
    }

    public List<SQLObject> getObjectFromName(IServerContext serverContext, DatabaseContext context, String name, ParsingContext parsingContext, Optional<ISQLColumnTableListener> listener, SQLObjectType ... types) {
        if (types != null && types.length == 0) {
            types = DEFAULT_TABLE_SOURCES;
        }
        if (types == null) {
            types = new SQLObjectType[]{};
        }
        List<SQLObject> ob = this.getTableSourceFromNameInternal(serverContext, context, name, parsingContext, listener, types);
        int i = 0;
        while (i < ob.size()) {
            List<SQLObject> lox;
            String alias;
            SQLObject sox = ob.get(i);
            if (sox.getCustomProperties() != null && (alias = (String)sox.getCustomProperties().get("SYNONYM_NAME")) != null && (lox = this.getTableSourceFromNameInternal(serverContext, context, alias, parsingContext, listener, types)) != null && lox.size() > 0) {
                SQLObject resolved = new SQLObject(lox.get(0));
                if (resolved.getCustomProperties() == null) {
                    resolved.setCustomProperties(new HashMap<String, Object>());
                }
                resolved.getCustomProperties().put("ALIAS_NAME", sox.getName());
                ob.set(i, resolved);
            }
            ++i;
        }
        return ob;
    }

    private List<SQLObject> getTableSourceFromNameInternal(IServerContext serverContext, DatabaseContext context, String name, ParsingContext parsingContext, Optional<ISQLColumnTableListener> listener, SQLObjectType ... objectTypes) {
        List<SQLObject> la = serverContext.getByName(name, context, listener.flatMap(ISQLColumnTableListener::getCallbackForContext), objectTypes);
        if (objectTypes.length == 0 || ListUtils.in((Object)((Object)SQLObjectType.TABLE), (Object[])objectTypes)) {
            for (SQLObject declares : parsingContext.getDeclareTables()) {
                if (!context.isSameIdentifier(name, declares)) continue;
                la.add(declares);
            }
        }
        for (SQLObject rest : parsingContext.getDeclareObjects()) {
            if (!context.isSameIdentifier(name, rest) || objectTypes.length != 0 && !rest.ofType(objectTypes)) continue;
            la.add(rest);
        }
        return la;
    }
}

