/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.filerunner.sql.edit.IEditor;
import com.sigge.filerunner.sql.edit.IParseResult;
import com.sigge.filerunner.sql.edit.ParseError;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ExtendedHyperlinkListener;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedValidator
implements Parser {
    private final RSyntaxTextArea textArea;
    private volatile ParseResult result;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedValidator.class);
    private final IEditor editor;

    public ThreadedValidator(RSyntaxTextArea textArea, IEditor editor) {
        this.textArea = textArea;
        this.editor = editor;
        textArea.addParser((Parser)this);
    }

    public ExtendedHyperlinkListener getHyperlinkListener() {
        return null;
    }

    public URL getImageBase() {
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public ParseResult parse(RSyntaxDocument doc, String style) {
        DefaultParseResult pr = new DefaultParseResult((Parser)this);
        if (doc.getLength() == 0) {
            return pr;
        }
        IParseResult res = this.editor.parse(this.textArea);
        if (res == null) {
            return this.result == null ? pr : this.result;
        }
        ThrowingConsumer futureResult = e -> {
            DefaultParseResult rex = this.createResults((List<ParseError>)e);
            this.setResults((ParseResult)rex);
        };
        Optional<List<ParseError>> a = res.getParseResult((ThrowingConsumer<List<ParseError>>)futureResult);
        if (a.isPresent()) {
            DefaultParseResult rex = this.createResults(a.get());
            this.result = rex;
        }
        return this.result == null ? pr : this.result;
    }

    private DefaultParseResult createResults(List<ParseError> e) {
        LinkedHashSet<ParseError> copy = new LinkedHashSet<ParseError>();
        int i = 0;
        while (i < e.size()) {
            copy.add(e.get(i));
            ++i;
        }
        DefaultParseResult pr = new DefaultParseResult((Parser)this);
        for (ParseError errors : copy) {
            if (errors == null) {
                LOGGER.error("Null for some reason:" + e);
                continue;
            }
            DefaultParserNotice notice = new DefaultParserNotice((Parser)this, errors.getMessage(), errors.getLine() - 1, errors.getStart(), errors.getEnd() - errors.getStart() + 1);
            if (errors.isWarning()) {
                notice.setLevel(ParserNotice.Level.WARNING);
            }
            pr.addNotice((ParserNotice)notice);
        }
        return pr;
    }

    private void setResults(ParseResult result) {
        this.result = result;
        SwingUtilities.invokeLater(() -> {
            boolean bl = this.textArea.forceReparsing((Parser)this);
        });
    }
}

