/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.AServerContext;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.jdbc.JDBCName;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DatabaseNeutralServerContext
extends AServerContext {
    public DatabaseNeutralServerContext(Database database, Function<ServerDatabase, DatabaseContext> contextCreator) {
        super(database, contextCreator);
    }

    @Override
    public Optional<DatabaseContext> getContextForName(String name, DatabaseContext context) {
        return Optional.of(context);
    }

    @Override
    public List<SQLObject> getByNamePattern(String name, DatabaseContext defaultContext, SQLObjectType ... objectTypes) {
        return this.getByNameOrPattern(name, defaultContext, true, objectTypes);
    }

    @Override
    public List<SQLObject> getByName(String name, DatabaseContext defaultContext, SQLObjectType ... objectTypes) {
        return this.getByNameOrPattern(name, defaultContext, false, objectTypes);
    }

    private List<SQLObject> getByNameOrPattern(String name, DatabaseContext defaultContext, boolean fuzzy, SQLObjectType ... objectTypes) {
        JDBCName sqlName = new JDBCName(name);
        DatabaseContext contextToUse = defaultContext;
        if (!sqlName.getDatabase().equals("")) {
            for (ServerDatabase sd : this.contexts.keySet()) {
                if (!sd.getDatabase().equals(sqlName.getDatabase())) continue;
                contextToUse = (DatabaseContext)this.contexts.get(sd);
                break;
            }
            for (ServerDatabase sd : this.contexts.keySet()) {
                if (!sd.getDatabase().equalsIgnoreCase(sqlName.getDatabase())) continue;
                contextToUse = (DatabaseContext)this.contexts.get(sd);
                break;
            }
        }
        String fuzzyPattern = FilterHelper.getRegexFromString2(sqlName.getName());
        DatabaseContext contextToUse2 = contextToUse;
        return contextToUse.getObjects().parallelStream().filter(o -> StringUtils.isEmpty(o.getSchemaName()) || o.getSchemaName().equalsIgnoreCase(sqlName.getSchema()) || contextToUse2 != null && !contextToUse2.needsSchema((SQLObject)o)).filter(o -> {
            if (!fuzzy) {
                return o.getName().equalsIgnoreCase(sqlName.getName());
            }
            if (name.matches("\\d+")) {
                return o.getName().toLowerCase().startsWith(sqlName.getName());
            }
            return o.getName().matches(fuzzyPattern);
        }).filter(o -> objectTypes.length == 0 || o.ofType(objectTypes)).collect(Collectors.toList());
    }

    @Override
    public Optional<EntityName> parseEntity(String entityName) {
        return Optional.of(new JDBCName(entityName));
    }
}

