/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.ADatabaseContext;
import com.sigge.filerunner.sql.SQLColumn;
import com.sigge.filerunner.sql.SQLOperation;
import com.sigge.filerunner.sql.SQLTable;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.ContextUtils;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.ListUtils;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableType;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.exceptions.SchemaCrawlerException;
import schemacrawler.tools.utility.SchemaCrawlerUtility;

public class DatabaseNeutralContext
extends ADatabaseContext {
    private volatile Provider provider;
    private volatile String schema;
    private final Set<String> availableSchemas = Collections.synchronizedSet(new HashSet());
    private volatile String definitionQuery = null;
    private SQLOptions options = this.createOptions();

    static {
        Logger.getLogger("schemacrawler").setLevel(Level.SEVERE);
    }

    private SQLOptions createOptions() {
        return new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).timeout(240).build();
    }

    public DatabaseNeutralContext(ServerDatabase sd) {
        super(sd);
        this.lastFuture = this.es.scheduleWithFixedDelay((Runnable)((Object)new SQLOperation(this::initContext)), 0L, 5L, TimeUnit.MINUTES);
    }

    @Override
    public String getSelectQuery(SQLObject so, int rowNumber) {
        switch (this.provider) {
            case Oracle: {
                return "SELECT  * FROM    " + so.getContext().getQuotedName(so) + " where rownum <=" + rowNumber;
            }
            case SqlServer: {
                return "SELECT  TOP " + rowNumber + " * FROM    " + so.getContext().getQuotedName(so);
            }
        }
        return "SELECT  * FROM    " + so.getContext().getQuotedName(so) + " limit " + rowNumber;
    }

    @Override
    public void initContext() throws Exception {
        new BackgroundRunner(() -> {
            try {
                try {
                    this.crawlSchema();
                }
                catch (Exception e) {
                    this.LOGGER.error("Error while crawling context", (Throwable)e);
                    this.setLoaded();
                }
            }
            finally {
                this.setLoaded();
            }
        }).execute();
    }

    @Override
    public void getObjectDefinition(SQLObject object, Consumer<String> definitionConsumer, Consumer<Exception> onError) {
        if (this.definitionQuery != null && this.definitionQuery.length() > 0) {
            try {
                this.options = this.createOptions();
                this.runSQL(this.definitionQuery.replace("%1%", object.getSchemaName()).replace("%2%", object.getName()), (r, i) -> {
                    if (r.next()) {
                        String def = r.getString(1);
                        if (StringUtils.isNotEmpty(def)) {
                            definitionConsumer.accept(def);
                        } else {
                            onError.accept(new RuntimeException("Couldn't fetch definition for " + object.getFullName()));
                        }
                    }
                }, this.options);
            }
            catch (Exception e) {
                onError.accept(e);
            }
        } else if (object.getSQLType() == SQLObjectType.TABLE) {
            definitionConsumer.accept(ContextUtils.getObject(object, this));
            return;
        }
    }

    @Override
    protected IScriptRunner createRunner() throws SQLException {
        return this.sb.getDb().createRunner(this.sb.getDatabase(), null);
    }

    /*
     * Unable to fully structure code
     */
    private void crawlSchema() throws SQLException, SchemaCrawlerException {
        runner = this.getOrCreate();
        connection = runner.getConnection();
        provider = connection.getMetaData().getDatabaseProductName();
        this.schema = connection.getSchema();
        if (provider == null) {
            this.provider = Provider.Unknown;
        } else {
            userName = connection.getMetaData().getUserName();
            if (provider.toLowerCase().contains("oracle")) {
                this.provider = Provider.Oracle;
                this.schema = userName;
            } else if (provider.toLowerCase().contains("postgresql")) {
                this.provider = Provider.PostgriS;
                this.availableSchemas.clear();
                this.availableSchemas.add("pg_catalog".toUpperCase());
                try {
                    var5_5 = null;
                    var6_8 = null;
                    try {
                        s = connection.createStatement();
                        try {
                            rs = s.executeQuery("SHOW search_path;");
                            try {
                                if (rs.next()) {
                                    availableSchemas = rs.getString(1);
                                    tokens = availableSchemas.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                                    var14_16 = tokens;
                                    var13_17 = tokens.length;
                                    var12_19 = 0;
                                    while (var12_19 < var13_17) {
                                        t = var14_16[var12_19];
                                        replace = t.replace("\"$user\"", userName).toUpperCase().replace("\"\"", "\u00a4%&").trim();
                                        if (replace.startsWith("\"")) {
                                            replace = replace.substring(1, replace.length() - 1);
                                        }
                                        replace = replace.replace("\u00a4%&", "\"");
                                        this.availableSchemas.add(replace);
                                        ++var12_19;
                                    }
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            ** if (s == null) goto lbl-1000
                        }
                        catch (Throwable var6_9) {
                            if (var5_5 == null) {
                                var5_5 = var6_9;
                            } else if (var5_5 != var6_9) {
                                var5_5.addSuppressed(var6_9);
                            }
                            if (s != null) {
                                s.close();
                            }
                            throw var5_5;
                        }
lbl-1000:
                        // 1 sources

                        {
                            s.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var6_10) {
                        if (var5_5 == null) {
                            var5_5 = var6_10;
                        } else if (var5_5 != var6_10) {
                            var5_5.addSuppressed(var6_10);
                        }
                        throw var5_5;
                    }
                }
                catch (Exception ex) {
                    this.LOGGER.error("Failed fetching availableSchemas", (Throwable)ex);
                }
            } else {
                this.provider = provider.toLowerCase().contains("mysql") != false ? Provider.Myskul : (provider.toLowerCase().contains("sql server") != false ? Provider.SqlServer : (provider.toLowerCase().contains("db2") != false ? Provider.Db2 : Provider.Unknown));
            }
        }
        if (this.provider != null && this.provider.getName() != null && this.definitionQuery == null) {
            this.definitionQuery = this.readQueryString(String.valueOf(this.provider.getName()) + "_definition.sql");
        }
        Logger.getLogger("schemacrawler").setLevel(Level.WARNING);
        lm = LimitOptionsBuilder.builder().includeAllSynonyms().includeSchemas((InclusionRule)(InclusionRule & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(java.lang.String ), (Ljava/lang/String;)Z)((DatabaseNeutralContext)this)).tableTypes("TABLE,VIEW,SYSTEM_TABLE,SYSTEM_VIEW,MATERIALIZED VIEW,PARTITIONED TABLE,SYSTEM TABLE,SYSTEM VIEW").toOptions();
        lo = LoadOptionsBuilder.builder().withSchemaInfoLevelBuilder(SchemaInfoLevelBuilder.builder().setRetrieveTableColumns(this.provider != Provider.Oracle && this.provider != Provider.Db2).setRetrieveTables(true).setRetrieveViewInformation(true).setRetrieveColumnDataTypes(this.provider != Provider.Oracle && this.provider != Provider.Db2)).toOptions();
        builder = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(lm).withLoadOptions(lo);
        dbs = runner.getDatabase().getDatabases();
        dbList = new ArrayList<SQLObject>();
        if (dbs.size() != 1 || !dbs.get(0).equals("(default)")) {
            i = 0;
            while (i < dbs.size()) {
                so = new SQLObject(this, i, dbs.get(i), "DATABASE", SQLObjectType.DATABASE, "", false);
                dbList.add(so);
                ++i;
            }
        }
        this.databases = dbList;
        schemaList = new ArrayList<SQLObject>();
        catalog = SchemaCrawlerUtility.getCatalog((Connection)connection, (SchemaCrawlerOptions)builder);
        i = 0;
        tableList = new ArrayList<SQLObject>();
        for (Schema schema : catalog.getSchemas()) {
            map = new HashMap<String, SQLTable>();
            schemaList.add(new SQLObject(this, i++, schema.getName(), "SCHEMA", SQLObjectType.SCHEMA, schema.getFullName(), false));
            j = 0;
            if (this.provider == Provider.Oracle || this.provider == Provider.Db2) {
                tables = catalog.getTables(schema).stream().map((Function<Table, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(schemacrawler.schema.Table ), (Lschemacrawler/schema/Table;)Ljava/lang/String;)()).collect(Collectors.toSet());
                try {
                    var18_26 = null;
                    var19_29 = null;
                    try {
                        rs = connection.getMetaData().getColumns(null, schema.getName(), null, null);
                        try {
                            prevTable = "";
                            table = null;
                            sl = null;
                            while (rs.next()) {
                                table = rs.getString("TABLE_NAME");
                                if (!tables.contains(table)) continue;
                                if (!prevTable.equals(table)) {
                                    sl = new SQLTable(null, (String)table);
                                    map.put((String)table, sl);
                                    prevTable = table;
                                }
                                sl.addColumn(new SQLColumn(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), rs.getInt("COLUMN_SIZE"), rs.getInt("DECIMAL_DIGITS"), rs.getInt("ORDINAL_POSITION")));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    catch (Throwable var19_30) {
                        if (var18_26 == null) {
                            var18_26 = var19_30;
                        } else if (var18_26 != var19_30) {
                            var18_26.addSuppressed(var19_30);
                        }
                        throw var18_26;
                    }
                }
                catch (Exception ex) {
                    this.LOGGER.error("Error while fetching: " + schema, (Throwable)ex);
                }
            }
            for (Table table : catalog.getTables(schema)) {
                ++j;
                systemObject = ListUtils.in((Object)((TableType)table.getType()).getTableType().toUpperCase(), (Object[])new String[]{"SYSTEM_TABLE", "SYSTEM VIEW", "SYSTEM TABLE", "SYSTEM_VIEW"});
                vt = table instanceof View != false ? new SQLObject(this, j++, table.getName(), "VIEW", SQLObjectType.VIEW, schema.getFullName(), systemObject) : new SQLObject(this, j++, table.getName(), "TABLE", SQLObjectType.TABLE, schema.getFullName(), systemObject);
                tableList.add(vt);
                if (this.provider != Provider.Oracle && this.provider != Provider.Db2) {
                    for (Column column : table.getColumns()) {
                        col = new SQLSubObject(column.getName(), column.getColumnDataType().getFullName());
                        vt.addColumn(col);
                    }
                    continue;
                }
                stable = (SQLTable)map.get(table.getName());
                if (stable == null) continue;
                for (SQLColumn col : stable.getColumns()) {
                    block70: {
                        dataType = col.getType();
                        if (dataType == null) break block70;
                        var25_37 = dataType;
                        tmp = -1;
                        switch (var25_37.hashCode()) {
                            case -2034720975: {
                                if (var25_37.equals("DECIMAL")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -1282431251: {
                                if (var25_37.equals("NUMERIC")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -545151281: {
                                if (var25_37.equals("NVARCHAR")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 2067286: {
                                if (var25_37.equals("CHAR")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 74101924: {
                                if (var25_37.equals("NCHAR")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 954596061: {
                                if (var25_37.equals("VARCHAR")) {
                                    tmp = 2;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 2: {
                                if (col.getSize() <= 0) break;
                                dataType = String.valueOf(dataType) + "(" + col.getSize() + ")";
                                break;
                            }
                            case 1: {
                                if (col.getSize() <= 0) break;
                                dataType = String.valueOf(dataType) + "(" + col.getSize() + "," + col.getScale() + ")";
                            }
                        }
                    }
                    sub = new SQLSubObject(col.getColumnName(), dataType);
                    vt.addColumn(sub);
                }
            }
        }
        this.objects = tableList;
    }

    @Override
    public boolean needsSchema(SQLObject object) {
        boolean needsSchema = super.needsSchema(object);
        if (needsSchema && (this.availableSchemas.size() > 0 || StringUtils.isNotEmpty(this.schema)) && (StringUtils.isEmpty(object.getSchemaName()) || StringUtils.isNotEmpty(this.schema) && this.schema.equalsIgnoreCase(object.getSchemaName()) || this.availableSchemas.size() > 0 && this.availableSchemas.contains(object.getSchemaName().toUpperCase()))) {
            return false;
        }
        return needsSchema;
    }

    private String readQueryString(String string) {
        try {
            return FileUtils.streamContents(this.getClass().getResourceAsStream(string), "UTF8");
        }
        catch (Exception e) {
            return "";
        }
    }

    private IScriptRunner getOrCreate() throws SQLException {
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = this.createRunner();
        }
        return this.runner;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    private static /* synthetic */ String lambda$4(Table l) {
        return l.getName();
    }

    private static enum Provider {
        Oracle("oracle"),
        Myskul("mysql"),
        SqlServer("mssql"),
        PostgriS("postgres"),
        Db2("db2"),
        Unknown(null);

        private final String name;

        private Provider(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

