/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.ServerDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public abstract class AServerContext
implements IServerContext {
    protected Map<ServerDatabase, DatabaseContext> contexts = new HashMap<ServerDatabase, DatabaseContext>();
    protected Function<ServerDatabase, DatabaseContext> contextCreator;
    protected final Database database;

    public AServerContext(Database database, Function<ServerDatabase, DatabaseContext> contextCreator) {
        this.database = database;
        this.contextCreator = contextCreator;
    }

    @Override
    public List<DatabaseContext> getDatabases() {
        return new ArrayList<DatabaseContext>(this.contexts.values());
    }

    @Override
    public DatabaseContext getContextForDatabase(ServerDatabase database) {
        return this.contexts.get(database);
    }

    @Override
    public List<SQLObject> getByName(String name, DatabaseContext defaultContext, Optional<CancellableCallback> contextReadyCallback, SQLObjectType ... objectTypes) {
        return this.getByName(name, defaultContext, objectTypes);
    }

    @Override
    public List<SQLObject> getByNamePattern(String name, DatabaseContext defaultContext, SQLObjectType ... objectTypes) {
        return this.getByName(name, defaultContext, objectTypes);
    }

    @Override
    public void changeDatabase(ServerDatabase newCurrentDatabase) {
        this.contexts.computeIfAbsent(newCurrentDatabase, this.contextCreator);
    }

    @Override
    public void close() throws IOException {
        this.contexts.values().forEach(s -> {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.contexts.clear();
    }
}

