/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.recent;

import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.recent.ItemStorer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;

public class RecentItemManager<E, F> {
    private final List<E> items = new ArrayList();
    private int maxItems = -1;
    private BiFunction<E, E, Boolean> equalsFunctor;
    private ItemStorer<E, F> storer;

    public RecentItemManager(int maxItems) {
        this(maxItems, (a, b) -> a.equals(b), null);
    }

    public RecentItemManager(int maxItems, ItemStorer<E, F> storer) {
        this(maxItems, (a, b) -> a.equals(b), storer);
    }

    public RecentItemManager(int maxItems, BiFunction<E, E, Boolean> equalsFunctor, ItemStorer<E, F> storer) {
        if (maxItems <= 0) {
            throw new IllegalArgumentException("maxItems must be > 0");
        }
        if (equalsFunctor == null) {
            throw new IllegalArgumentException("EqualsFunctor cannot be null");
        }
        this.maxItems = maxItems;
        this.equalsFunctor = equalsFunctor;
        this.storer = storer;
    }

    public void setItems(List<E> items) {
        this.items.clear();
        for (E item : items) {
            this.newItem(item, true);
        }
    }

    public boolean newItem(E item) {
        return this.newItem(item, false);
    }

    public boolean newItem(E item, boolean startup) {
        if (item == null) {
            throw new NullPointerException("Null items aren't allowed");
        }
        if (!startup && this.storer != null) {
            StoreItem<E> e = new StoreItem<E>(item);
            this.storer.storeItems(Arrays.asList(e));
        }
        if (this.items.size() == 0) {
            this.items.add(item);
            return true;
        }
        if (this.equalsFunctor.apply(item, this.items.get(0)).booleanValue()) {
            if (!item.equals(this.items.get(0))) {
                this.items.set(0, item);
                return true;
            }
            return false;
        }
        this.items.remove(item);
        if (this.items.size() == this.maxItems) {
            this.items.remove(this.items.size() - 1);
        }
        this.items.add(0, item);
        return true;
    }

    public List<E> items() {
        return Collections.unmodifiableList(this.items);
    }

    public List<StoreItem<E>> recents() {
        if (this.storer != null) {
            return this.storer.listItems();
        }
        return Collections.EMPTY_LIST;
    }
}

