/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.raw;

import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.IBinder;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.filerunner.core.Encoding;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.imports.core.AImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.SimpleProgressStatus;
import com.sigge.filerunner.imports.raw.RawImportSettings;
import com.sigge.filerunner.imports.raw.RawPanel;
import com.sigge.filerunner.imports.raw.RawSettingsModel;
import com.sigge.filerunner.imports.raw.RawStyle;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.DialogView;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.siggemannen.binding.APresenter;
import com.siggemannen.core.Tuple;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;

public class RawImporter
extends AImporter<RawImportSettings> {
    public RawImporter(RootPaneContainer container) {
        super(container);
    }

    @Override
    protected boolean isSupportsMultipleFiles() {
        return true;
    }

    @Override
    protected ImportResult doImport(ServerDatabase currentDatabase, List<File> files, RawImportSettings settings, SimpleProgressStatus status) {
        IDatabaseOperator op = currentDatabase.getDb().getDatabaseOperator();
        ArrayList<Column> col = new ArrayList<Column>();
        RawStyle exportStyle = settings.getStyle();
        if (StringUtils.isNotEmpty(settings.getDataType())) {
            col.add(new Column(settings.getColumnName(), settings.getDataType()));
        } else if (exportStyle == RawStyle.BINARY_FILE) {
            col.add(new Column(settings.getColumnName(), ColumnType.VARBINARY));
        } else {
            col.add(new Column(settings.getColumnName(), new ColumnType(DataType.TEXT)));
        }
        if (settings.isAddFileNameField()) {
            col.add(new Column(StringUtils.isBlank(settings.getFileNameField(), "filename"), new ColumnType(DataType.TEXT)));
        }
        AtomicInteger rows = new AtomicInteger(0);
        if (status.isCancelled()) {
            return ImportResult.CANCELLED;
        }
        try {
            ITableOperator tableOperator = op.getTableOperator();
            ITable table = tableOperator.openOrCreate(currentDatabase.getDatabase(), settings.getTableName(), "", col);
            ArrayList<ColumnMapping> mapping = new ArrayList<ColumnMapping>();
            mapping.add(new ColumnMapping((Column)col.get(0), 0));
            for (File f : files) {
                if (status.isCancelled()) {
                    return ImportResult.CANCELLED;
                }
                status.status("Importing: " + f.getName());
                if (!settings.isUnpackFile()) {
                    block32: {
                        FileInputStream fis;
                        Object var15_18;
                        Throwable throwable;
                        if (exportStyle == RawStyle.BINARY_FILE) {
                            throwable = null;
                            var15_18 = null;
                            try {
                                fis = new FileInputStream(f);
                                try {
                                    this.importBinaryDataFromSomething(fis, f.getAbsolutePath(), tableOperator, table, col, rows);
                                    break block32;
                                }
                                finally {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        if (settings.isSplitOnNewLines()) {
                            throwable = null;
                            var15_18 = null;
                            try {
                                fis = new FileInputStream(f);
                                try {
                                    this.importSplitStringFromSomething(fis, settings.getEncoding().getEncoding(), status, f.getAbsolutePath(), tableOperator, table, col, rows);
                                    break block32;
                                }
                                finally {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        String content = FileUtils.fileContent(f, settings.getEncoding() != Encoding.AUTO_DETECT ? settings.getEncoding().getEncoding() : null);
                        this.importStringFromSomething(content, f.getAbsolutePath(), tableOperator, table, col, rows);
                    }
                    rows.incrementAndGet();
                    continue;
                }
                this.importArchive(f, status, ze -> {
                    status.status("Importing: " + StringUtils.isBlank(ze.getName(), f.getAbsolutePath()));
                    String filePath = String.valueOf(f.getAbsolutePath()) + File.separator + StringUtils.isBlank(ze.getName(), "");
                    try {
                        if (exportStyle == RawStyle.BINARY_FILE) {
                            this.importBinaryDataFromSomething(ze.getData(), filePath, tableOperator, table, col, rows);
                        } else {
                            FilterInputStream is = new FilterInputStream(ze.getData()){

                                @Override
                                public void close() throws IOException {
                                }
                            };
                            if (settings.isSplitOnNewLines()) {
                                this.importSplitStringFromSomething(is, settings.getEncoding().getEncoding(), status, f.getAbsolutePath(), tableOperator, table, col, rows);
                            } else {
                                Tuple<Integer, Tuple<char[], String>> res = FileUtils.fileContents(is, settings.getEncoding() != Encoding.AUTO_DETECT ? settings.getEncoding().getEncoding() : null);
                                this.importStringFromSomething(new String((char[])((Tuple)res.second()).first(), 0, (int)((Integer)res.first())), filePath, tableOperator, table, col, rows);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while importing ze entry: " + ze.getName(), e);
                    }
                });
            }
        }
        catch (Exception ex) {
            return new ImportResult(ex.getMessage(), ex);
        }
        if (status.isCancelled()) {
            return ImportResult.CANCELLED;
        }
        return new ImportResult(files, rows.get());
    }

    private void importBinaryDataFromSomething(final InputStream fis, final String filePath, ITableOperator tableOperator, ITable table, List<Column> col, final AtomicInteger rows) throws Exception {
        tableOperator.insert(table, col, new IBinder(){
            private int cnt = 0;

            @Override
            public boolean next() {
                if (this.cnt < 1) {
                    ++this.cnt;
                    rows.incrementAndGet();
                    return true;
                }
                return false;
            }

            @Override
            public void bind(PreparedStatement ps, int row, int column, int parameterIndex) throws SQLException {
                switch (parameterIndex) {
                    case 1: {
                        ps.setBinaryStream(parameterIndex, fis);
                        break;
                    }
                    case 2: {
                        ps.setString(parameterIndex, filePath);
                        break;
                    }
                }
            }
        });
    }

    private void importSplitStringFromSomething(InputStream content, String charset, final SimpleProgressStatus status, final String filePath, ITableOperator tableOperator, ITable table, final List<Column> col, final AtomicInteger rows) throws Exception {
        AtomicInteger aix = new AtomicInteger(0);
        Throwable throwable = null;
        Object var11_12 = null;
        try (final BufferedReader reader = new BufferedReader(new InputStreamReader(content, charset));){
            tableOperator.insert(table, col.stream().map(c -> new ColumnMapping((Column)c, aix.getAndIncrement())).collect(Collectors.toList()), new IBulk(){
                private String line;

                @Override
                public boolean next() {
                    try {
                        boolean b;
                        boolean bl = b = !status.isCancelled() && (this.line = reader.readLine()) != null;
                        if (b && rows.incrementAndGet() % 100000 == 0) {
                            status.status("Importing: " + filePath + ", lines: " + rows.get());
                        }
                        return b;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error while splitting lines", e);
                    }
                }

                @Override
                public Object[] getData() {
                    Object[] data = new Object[col.size()];
                    data[0] = this.line;
                    if (col.size() > 1) {
                        data[1] = filePath;
                    }
                    return data;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void importStringFromSomething(final String content, final String filePath, ITableOperator tableOperator, ITable table, List<Column> col, final AtomicInteger rows) throws Exception {
        tableOperator.insert(table, col, new IBinder(){
            private int cnt = 0;

            @Override
            public boolean next() {
                if (this.cnt < 1) {
                    ++this.cnt;
                    rows.incrementAndGet();
                    return true;
                }
                return false;
            }

            @Override
            public void bind(PreparedStatement ps, int row, int column, int parameterIndex) throws SQLException {
                switch (parameterIndex) {
                    case 1: {
                        ps.setString(parameterIndex, content);
                        break;
                    }
                    case 2: {
                        ps.setString(parameterIndex, filePath);
                        break;
                    }
                }
            }
        });
    }

    @Override
    protected RawImportSettings getSettings(ServerDatabase currentDatabase, List<File> files) {
        final RawPanel rp = new RawPanel();
        RawImportSettings ris = new RawImportSettings();
        RawSettingsModel model = new RawSettingsModel();
        APresenter<RawImportSettings, RawSettingsModel, RawPanel> presenter = new APresenter<RawImportSettings, RawSettingsModel, RawPanel>(model, rp){

            protected void initBindings() {
                this.bind(rp.tableName).to(((RawSettingsModel)this.model).tableName);
                this.bind(rp.columnName).to(((RawSettingsModel)this.model).columnName);
                this.bind(new JRadioButton[]{rp.binaryRadio, rp.textRadio}).to(((RawSettingsModel)this.model).style, (Object[])new RawStyle[]{RawStyle.BINARY_FILE, RawStyle.STRING_FILE});
                this.bind(rp.encodingCombo).to(Arrays.asList(Encoding.values()), ((RawSettingsModel)this.model).encoding);
                rp.encodingCombo.setRenderer(new LabelledCellRenderer(true));
                this.bind(rp.fieldType).to(((RawSettingsModel)this.model).dataType);
                this.bind(rp.fileNameFieldCheck).to(((RawSettingsModel)this.model).addFileNameField);
                this.bind(rp.fileNameFieldText).to(((RawSettingsModel)this.model).fileNameField);
                this.bind(rp.unpackFileCheckbox).to(((RawSettingsModel)this.model).unpackFile);
                this.bind(rp.splitOnNewLinesCheckbox).to(((RawSettingsModel)this.model).splitOnNewLines);
                ((RawPanel)this.view).infoLabel.setVisible(false);
                ((RawSettingsModel)this.model).style.addListener(() -> {
                    boolean isText = ((RawSettingsModel)this.model).style.getValue() == RawStyle.STRING_FILE;
                    rawPanel.encodingCombo.setEnabled(isText);
                    rawPanel.splitOnNewLinesCheckbox.setEnabled(isText);
                });
                ((RawSettingsModel)this.model).addFileNameField.addListener(() -> rawPanel.fileNameFieldText.setEnabled((Boolean)((RawSettingsModel)this.model).addFileNameField.getValue()));
                ((RawSettingsModel)this.model).addModelChangeListener(() -> {
                    boolean hasTableAndColumn = StringUtils.isNoneEmpty((String)((RawSettingsModel)this.model).tableName.getValue(), (String)((RawSettingsModel)this.model).columnName.getValue());
                    boolean encodingSplitLine = ((RawSettingsModel)this.model).style.getValue() == RawStyle.STRING_FILE && (Boolean)((RawSettingsModel)this.model).splitOnNewLines.getValue() != false && ((RawSettingsModel)this.model).encoding.getValue() == Encoding.AUTO_DETECT;
                    rawPanel.importButton.setEnabled(hasTableAndColumn && !encodingSplitLine);
                    if (!hasTableAndColumn) {
                        ((RawPanel)this.view).infoLabel.setText("Provide table and column name");
                        ((RawPanel)this.view).infoLabel.setVisible(true);
                    } else if (encodingSplitLine) {
                        ((RawPanel)this.view).infoLabel.setText("Specify encoding to use split by lines");
                        ((RawPanel)this.view).infoLabel.setVisible(true);
                    } else {
                        ((RawPanel)this.view).infoLabel.setText("");
                        ((RawPanel)this.view).infoLabel.setVisible(false);
                    }
                });
            }
        };
        ris.setEncoding(Encoding.AUTO_DETECT);
        ris.setStyle(RawStyle.STRING_FILE);
        rp.dataTypeChk.addActionListener(new ActionListener(){
            String prev = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (rp.dataTypeChk.isSelected()) {
                    rp.fieldType.setText(this.prev);
                    rp.fieldType.setEnabled(true);
                } else {
                    this.prev = rp.fieldType.getText();
                    rp.fieldType.setText("");
                    rp.fieldType.setEnabled(false);
                }
            }
        });
        rp.browseButton.addActionListener(e -> {
            List<File> selected = this.getFilesImport(this.isSupportsMultipleFiles(), this.getFilters());
            if (selected != null && selected.size() > 0) {
                files.clear();
                files.addAll(selected);
                this.setFileInformation(files, rp);
            }
        });
        rp.fieldType.setEnabled(false);
        this.setFileInformation(files, rp);
        presenter.setObject((Object)ris);
        DialogView dv = new DialogView(this.container instanceof JFrame ? (JFrame)this.container : null, "Import settings", true);
        dv.setContent(rp, false);
        dv.addCancelAction(rp.cancelButton);
        dv.addOKAction(rp.importButton);
        rp.importButton.setEnabled(false);
        dv.centerOnCorrectScreen(this.container instanceof JFrame ? (JFrame)this.container : null);
        dv.setIconImage(IconUtils.getSmallIcon("file.png").getImage());
        dv.setVisible(true);
        if (dv.getReturnStatus() == 1) {
            return ris;
        }
        return null;
    }

    private void setFileInformation(List<File> files, RawPanel rp) {
        String fileString = files.stream().map(File::getAbsolutePath).reduce("", (a, b) -> String.valueOf(a) + (a.length() > 0 ? ";" : "") + b);
        rp.fileLabel.setText(files.size() == 1 ? "Import file as:" : "Import " + files.size() + " files as:");
        rp.filesPreview.setText(fileString);
        rp.filesPreview.setToolTipText(fileString);
    }

    @Override
    public String getIcon() {
        return "file.png";
    }

    @Override
    public String getLabel() {
        return "Raw files";
    }
}

