/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.grib;

import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ITable;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.imports.core.AImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.ImportTablePreview;
import com.sigge.filerunner.imports.core.SimpleProgressStatus;
import com.sigge.filerunner.imports.grib.BulkStorer;
import com.sigge.filerunner.imports.grib.GeoImportPanel;
import com.sigge.filerunner.imports.grib.GribFileState;
import com.sigge.filerunner.imports.grib.GribSettings;
import com.sigge.filerunner.imports.grib.VariableWrapper;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.core.DialogView;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.core.CancellationToken;
import com.siggemannen.core.storage.IResult;
import com.siggemannen.core.storage.IStorer;
import com.siggemannen.core.storage.Result;
import com.siggemannen.gribbs.GeoType;
import com.siggemannen.gribbs.GeoVariableData;
import com.siggemannen.gribbs.IVariableData;
import com.siggemannen.gribbs.ParseStatistics;
import com.siggemannen.gribbs.TimeGridFile;
import com.siggemannen.view.IStatusProgress;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderRunnable;
import com.siggemannen.view.UIOptionRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.error.ErrorInfo;
import org.oxbow.swingbits.list.CheckList;
import ucar.nc2.Variable;

public class GribImporter
extends AImporter<GribSettings> {
    private final ExecutorService ES = Executors.newWorkStealingPool();

    public GribImporter(RootPaneContainer container) {
        super(container);
    }

    @Override
    public String getIcon() {
        return "map.png";
    }

    @Override
    protected ImportResult doImport(ServerDatabase currentDatabase, List<File> f, GribSettings settings, SimpleProgressStatus status) {
        status.status("Reading file");
        AtomicInteger aix = new AtomicInteger(0);
        Closeable tableOperator = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (GribFileState geo = new GribFileState(f.get(0));){
                    geo.parse();
                    ArrayList<ColumnMapping> cm = new ArrayList<ColumnMapping>();
                    ITable t = this.prepareForImport(currentDatabase, settings.getTable(), settings, cm, Optional.empty());
                    tableOperator = t.getOperator();
                    status.status("Ready for import of data");
                    ParseStatistics ps = geo.getGribFile().parse((IVariableData)new GeoVariableData(GeoType.LATITUDE, Optional.of(settings.getLat().getV().getShortName())), (IVariableData)new GeoVariableData(GeoType.LONGITUDE, Optional.of(settings.getLon().getV().getShortName())), (IVariableData)new GeoVariableData(GeoType.DIMENSION, Optional.of(settings.getGeos().get(0).getV().getShortName())), Optional.ofNullable(settings.getTime() == null ? null : new GeoVariableData(GeoType.TIME, Optional.of(settings.getTime().getV().getShortName()))), Collections.EMPTY_LIST);
                    CancellationToken token = this.createTokenFromStatus(status);
                    BulkStorer bs = new BulkStorer(status);
                    Future<IResult> future = this.ES.submit(() -> geo.getGribFile().store((IStorer)bs, token));
                    status.status("Read in the file");
                    tableOperator.insert(t, cm, bs);
                    future.get();
                    if (status.isCancelled()) {
                        status.status("Import cancelled, rows read: " + aix.get());
                    } else {
                        status.status("Finished, row inserted:" + aix.get());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                status.status("Error after reading: " + aix.get() + " rows: " + e.getMessage(), e);
                ImportResult importResult = new ImportResult("Error after reading: " + aix.get() + " rows: " + e.getMessage(), e);
                if (tableOperator != null) {
                    try {
                        tableOperator.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return importResult;
            }
        }
        finally {
            if (tableOperator != null) {
                try {
                    tableOperator.close();
                }
                catch (Exception exception) {}
            }
        }
        return new ImportResult(f, aix.get());
    }

    @Override
    protected AImporter.ProgressType getProgressType() {
        return AImporter.ProgressType.UNDETERMINED;
    }

    @Override
    protected FileNameExtensionFilter[] getFilters() {
        return new FileNameExtensionFilter[]{new FileNameExtensionFilter("Grib files (*.grib; *.grib2, *.nc)", "grib", "grib2", "nc")};
    }

    @Override
    protected GribSettings getSettings(ServerDatabase currentDatabase, final List<File> files) {
        final GeoImportPanel gimp = new GeoImportPanel();
        DialogView ad = new DialogView(this.container instanceof JFrame ? (JFrame)this.container : null, "Import geo data", true);
        ad.addOKAction(gimp.importButton);
        ad.addCancelAction(gimp.cancelButton);
        ad.setContent(gimp, false);
        ad.centerOnCorrectScreen(this.container instanceof JFrame ? (JFrame)this.container : null);
        final GribSettingModel gm = new GribSettingModel();
        final GribSettings gs = new GribSettings();
        gs.setFixUpCoordinates(true);
        final GribFileState state = new GribFileState();
        APresenter<GribSettings, GribSettingModel, GeoImportPanel> presenter = new APresenter<GribSettings, GribSettingModel, GeoImportPanel>(gm, gimp){

            protected void initBindings() {
                this.bind(gimp.tableName).to(gm.tableName);
                DefaultListCellRenderer geoCellRenderer = new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        JLabel jal = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        Variable v = null;
                        if (value instanceof VariableWrapper) {
                            v = ((VariableWrapper)value).getV();
                        } else if (value instanceof Variable) {
                            v = (Variable)value;
                        }
                        if (v != null) {
                            jal.setText(String.valueOf(v.getShortName()) + (!v.getFullName().equals(v.getShortName()) ? "(" + v.getFullName() + ")" : "") + " - " + this.getDimString(v));
                        }
                        return jal;
                    }

                    private String getDimString(Variable v) {
                        int[] shape = v.getShape();
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < shape.length) {
                            if (i > 0) {
                                sb.append("x");
                            }
                            sb.append(shape[i]);
                            ++i;
                        }
                        return sb.toString();
                    }
                };
                ((GeoImportPanel)this.view).latCombo.setRenderer(geoCellRenderer);
                ((GeoImportPanel)this.view).lonCombo.setRenderer(geoCellRenderer);
                ((GeoImportPanel)this.view).timeCombo.setRenderer(geoCellRenderer);
                this.bind(((GeoImportPanel)this.view).geoTextField).to(((GribSettingModel)this.model).geos);
                this.bind(((GeoImportPanel)this.view).rowsToPreview).to(((GribSettingModel)this.model).previewRows, null, Integer.valueOf(0), Integer.valueOf(1000));
                this.bind(((GeoImportPanel)this.view).fixUpCoordinatesCheckbox).to(gm.fixUpCoordinates);
                ((GeoImportPanel)this.view).browseButton.addActionListener(e -> {
                    List<File> selected = GribImporter.this.getFilesImport(GribImporter.this.isSupportsMultipleFiles(), GribImporter.this.getFilters());
                    if (selected != null && selected.size() > 0) {
                        files.clear();
                        files.addAll(selected);
                        GribImporter.this.setFileInformation(files, ((GeoImportPanel)this.view).filesPreview);
                        GribImporter.this.recalculateGeoPackageThing(files, (APresenter<GribSettings, GribSettingModel, GeoImportPanel>)this, state);
                    }
                });
                ((GribSettingModel)this.model).addModelChangeListener(() -> geoImportPanel.importButton.setEnabled(StringUtils.isNoneEmpty((String)((GribSettingModel)this.model).tableName.getValue())));
                ((GeoImportPanel)this.view).editGeoButton.addActionListener(al -> {
                    DialogView dv = new DialogView((Frame)((Object)GribImporter.this.container), true);
                    dv.setTitle("Add geo variables");
                    JPanel jepee = new JPanel(new BorderLayout(100, 100));
                    JXList list = new JXList();
                    CheckList checkList = new CheckList.Builder((JList)list).build();
                    checkList.setData(gribFileState.getGeoVariables().geos);
                    checkList.setCheckedItems((Collection)gribFileState.getGeoVariables().geos.stream().filter(w -> gs.getGeos().contains(w)).collect(Collectors.toList()));
                    jepee.add((Component)list);
                    dv.setContent(jepee, true);
                    dv.pack();
                    dv.setVisible(true);
                    if (dv.getReturnStatus() == 1) {
                        List collect = checkList.getCheckedItems().stream().collect(Collectors.toList());
                        ((GribSettingModel)this.model).geos.clearAndSetNew(collect);
                    }
                });
                ((GeoImportPanel)this.view).previewButton.addActionListener(al -> {
                    GeoVariableData time;
                    ImportTablePreview imp = new ImportTablePreview();
                    final Vector data = imp.getData();
                    Vector headers = imp.getHeaders();
                    TimeGridFile file = state.getGribFile();
                    ArrayList<GeoVariableData> geoExtra = new ArrayList<GeoVariableData>();
                    int i = 0;
                    while (i < gs.getGeos().size()) {
                        if (i > 0) {
                            GeoVariableData e = new GeoVariableData(GeoType.DIMENSION, gs.getGeos().get(i).getV().getShortName());
                            e.setImported(true);
                            geoExtra.add(e);
                        }
                        ++i;
                    }
                    GeoVariableData lat = new GeoVariableData(GeoType.LATITUDE, gs.getLat().getV().getShortName());
                    GeoVariableData lon = new GeoVariableData(GeoType.LONGITUDE, gs.getLon().getV().getShortName());
                    GeoVariableData geo2 = new GeoVariableData(GeoType.DIMENSION, gs.getGeos().get(0).getV().getShortName());
                    GeoVariableData geoVariableData = time = gs.getTime() != null ? new GeoVariableData(GeoType.TIME, gs.getTime().getV().getShortName()) : null;
                    if (time != null) {
                        time.setImported(true);
                    }
                    lat.setImported(true);
                    lon.setImported(true);
                    geo2.setImported(true);
                    UIOptionRunnable previewRunnable = (UIOptionRunnable)((UIOptionBuilderRunnable)new UIOptionBuilderRunnable(() -> {
                        ParseStatistics stats = file.parse((IVariableData)lat, (IVariableData)lon, (IVariableData)geo2, Optional.ofNullable(time), Collections.EMPTY_LIST);
                        headers.add(gs.getLat().getV().getShortName());
                        headers.add(gs.getLon().getV().getShortName());
                        headers.add(gs.getGeos().get(0).getV().getShortName());
                        if (gs.getTime() != null) {
                            headers.add(gs.getTime());
                        }
                        final CancellationToken ct = new CancellationToken();
                        file.store(new IStorer(){
                            AtomicInteger aix = new AtomicInteger(0);

                            public IResult flush() throws Exception {
                                return new Result();
                            }

                            public void add(Object[] d) throws Exception {
                                if (this.aix.getAndIncrement() >= gs.getPreviewRows() && !ct.getCancelled()) {
                                    ct.setCancelled();
                                    return;
                                }
                                data.add(new Vector<Object>(Arrays.asList(d)));
                            }
                        }, ct);
                        SwingUtilities.invokeLater(() -> imp.setModelData((JTable)((Object)((GeoImportPanel)this.view).previewTable), gs, 5));
                    }).exceptionCallback(ex -> JXErrorPane.showDialog((Component)((Component)this.view), (ErrorInfo)new ErrorInfo("Error while previewing", "Error occured while previewing: " + ex.getMessage(), null, null, (Throwable)ex, Level.WARNING, null)))).build();
                    UIBackgroundRunner.execute((UIOptionRunnable)previewRunnable);
                });
            }
        };
        presenter.setObject((Object)gs);
        this.setFileInformation(files, gimp.filesPreview);
        this.recalculateGeoPackageThing(files, presenter, state);
        ad.setVisible(true);
        try {
            state.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ad.getReturnStatus() == 1 ? gs : null;
    }

    private void recalculateGeoPackageThing(List<File> files, APresenter<GribSettings, GribSettingModel, GeoImportPanel> presenter, GribFileState state) {
        if (files.size() == 0) {
            return;
        }
        File f = files.get(0);
        state.setFile(f);
        ValueHolder vh = new ValueHolder();
        UIOptionRunnable ui = (UIOptionRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)((UIOptionBuilderRunnable)new UIOptionBuilderRunnable(() -> {
            IStatusProgress status = (IStatusProgress)vh.getValue();
            if (status.isCancelled()) {
                return;
            }
            status.status("Opening file...");
            GribFileState.GeoVariables geo = state.parse();
            status.status("File opened");
            GeoImportPanel view = (GeoImportPanel)presenter.getView();
            presenter.bind((JComboBox)view.latCombo).to(geo.latLonTime, ((GribSettingModel)aPresenter.getModel()).lat);
            presenter.bind((JComboBox)view.lonCombo).to(geo.latLonTime, ((GribSettingModel)aPresenter.getModel()).lon);
            presenter.bind((JComboBox)view.timeCombo).to(geo.latLonTime, ((GribSettingModel)aPresenter.getModel()).time);
            ((GribSettingModel)aPresenter.getModel()).geos.setValue(new ArrayList<VariableWrapper>(geo.geos));
            if (geo.latLonTime.size() > 0) {
                view.latCombo.setSelectedIndex(0);
                view.lonCombo.setSelectedIndex(0);
                view.lonCombo.setSelectedIndex(0);
            }
        }).mainPanel(this.container)).title("Processing geopackage", "Processing file:" + f, "Cancel import")).exceptionCallback(ex -> JXErrorPane.showDialog((Throwable)ex))).dialogIcon(DialogView.DEFAULT_ICON)).progress((Consumer)vh)).build();
        UIBackgroundRunner.execute((UIOptionRunnable)ui);
    }

    protected void setFileInformation(List<File> files, JTextField fileLabel) {
        String fileString = files.stream().map(File::getAbsolutePath).reduce("", (a, b) -> String.valueOf(a) + (a.length() > 0 ? ";" : "") + b);
        fileLabel.setText(fileString);
        fileLabel.setToolTipText(fileString);
    }

    private CancellationToken createTokenFromStatus(final SimpleProgressStatus progress) {
        return new CancellationToken(){

            public boolean getCancelled() {
                return super.getCancelled() || progress.isCancelled();
            }
        };
    }

    private static class GribSettingModel
    extends AModel<GribSettings> {
        IProperty<String> tableName = this.getProperty("table");
        IProperty<VariableWrapper> lat = this.getProperty("lat");
        IProperty<VariableWrapper> lon = this.getProperty("lon");
        IProperty<VariableWrapper> time = this.getProperty("time");
        IListProperty<VariableWrapper> geos = this.getListProperty("geos");
        IProperty<Boolean> fixUpCoordinates = this.getProperty("fixUpCoordinates");
        IProperty<Integer> previewRows = this.getProperty("previewRows");

        private GribSettingModel() {
        }
    }
}

