/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.grib;

import com.sigge.dbrunner.table.IBulk;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.imports.core.SimpleProgressStatus;
import com.siggemannen.core.storage.IResult;
import com.siggemannen.core.storage.IStorer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BulkStorer
implements IBulk,
IStorer {
    private final ArrayBlockingQueue<Object> bq = new ArrayBlockingQueue(10);
    private List<Object[]> currentObject = null;
    private List<Object[]> todo = new ArrayList<Object[]>();
    private final AtomicInteger currentIndex = new AtomicInteger(-1);
    private final AtomicInteger countProcessed = new AtomicInteger(0);
    private final SimpleProgressStatus progress;
    private LocalDateTime ld = DateUtils.getTimeAtUTC();

    public BulkStorer(SimpleProgressStatus progress) {
        this.progress = progress;
    }

    public void add(Object[] data) throws Exception {
        this.todo.add(data);
        if (this.todo.size() == 100000) {
            this.bq.put(this.todo);
            this.todo = new ArrayList<Object[]>();
        }
    }

    public IResult flush() throws Exception {
        System.out.println("flushin'");
        if (this.todo.size() > 0) {
            this.bq.put(this.todo);
        }
        this.bq.put(new ArrayList());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() {
        if (this.currentObject != null) {
            if (this.currentIndex.addAndGet(1) < this.currentObject.size()) {
                return true;
            }
            this.currentObject = null;
        }
        try {
            Object task = this.bq.take();
            if (task instanceof List && ((List)task).size() == 0) {
                System.out.println("No more elements");
                return false;
            }
            BulkStorer bulkStorer = this;
            synchronized (bulkStorer) {
                this.currentObject = (List)task;
                this.currentIndex.set(0);
                return true;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public Object[] getData() {
        int cnt = this.countProcessed.getAndIncrement();
        if (cnt % 1000 == 0 && cnt > 0 || DateUtils.isOlderThan(this.ld, 30000L)) {
            this.progress.status("Imported " + cnt + " rows");
            this.ld = DateUtils.getTimeAtUTC();
        }
        return this.currentObject.get(this.currentIndex.get());
    }
}

