/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.excel;

import com.sigge.filerunner.imports.excel.SimpleCellType;
import com.siggemannen.core.Tuple;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelCellUtil {
    static DecimalFormat formatter = ExcelCellUtil.getFormatter();
    public static final DateFormat VISKAN_DB_DATE = new SimpleDateFormat("yyyy-MM-dd");

    public static DecimalFormat getFormatter() {
        DecimalFormat floatFormatter = new DecimalFormat("#");
        floatFormatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        floatFormatter.setMaximumFractionDigits(8);
        return floatFormatter;
    }

    public static Tuple<SimpleCellType, String> getCellTypeAndValue(Cell c) {
        String val = null;
        CellType cellType = ExcelCellUtil.getCellType(c);
        SimpleCellType simpleType = SimpleCellType.EMPTY;
        switch (cellType) {
            case STRING: {
                val = c.getStringCellValue();
                simpleType = SimpleCellType.STRING;
                break;
            }
            case BOOLEAN: {
                val = c.getBooleanCellValue() ? "1" : "0";
                simpleType = SimpleCellType.BOOL;
                break;
            }
            case BLANK: {
                break;
            }
            case NUMERIC: {
                String q;
                if (DateUtil.isCellDateFormatted((Cell)c)) {
                    val = VISKAN_DB_DATE.format(c.getDateCellValue());
                    simpleType = SimpleCellType.DATE;
                    break;
                }
                double numericCellValue = c.getNumericCellValue();
                val = q = formatter.format(numericCellValue);
                if (q.contains(".")) {
                    simpleType = SimpleCellType.FLOAT;
                    break;
                }
                simpleType = SimpleCellType.INT;
                break;
            }
        }
        return Tuple.of((Object)((Object)simpleType), (Object)val);
    }

    public static String getCellValue(Cell c) {
        String val = null;
        switch (ExcelCellUtil.getCellType(c)) {
            case STRING: {
                val = c.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                val = c.getBooleanCellValue() ? "1" : "0";
                break;
            }
            case BLANK: {
                break;
            }
            case NUMERIC: {
                String q;
                if (DateUtil.isCellDateFormatted((Cell)c)) {
                    val = VISKAN_DB_DATE.format(c.getDateCellValue());
                    break;
                }
                val = q = formatter.format(c.getNumericCellValue());
                break;
            }
        }
        return val;
    }

    private static CellType getCellType(Cell cell) {
        return cell == null ? CellType._NONE : (cell.getCellType() == CellType.FORMULA ? cell.getCachedFormulaResultType() : cell.getCellType());
    }
}

