/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.csv;

import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.ImportTablePreview;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.PreviewTableModel;
import com.sigge.filerunner.imports.csv.CSVImportSettings;
import com.sigge.filerunner.imports.csv.CSVPanel;
import com.sigge.filerunner.imports.csv.CSVPreferenceDialog;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.fileutils.EncodingDetector;
import com.sigge.fileutils.SkipBOMReader;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.SoftCopy;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CSVPreferenceHandler {
    private static final String IMPORT_CSV_QUOTE = "imports.csv.quote";
    private static final String IMPORT_CSV_SEPARATOR = "imports.csv.separator";
    private static final String IMPORT_CSV_FIRST_LINE_HEADER = "imports.csv.first_line_header";
    private static final String IMPORT_CSV_INCLUDE_ROW_NUMBER = "imports.csv.include_row_id";
    private static final String QUOTED_CHAR_NO_QUOTE = "";
    private static final String QUOTED_CHAR_SINGLE_QUOTE = "'";
    private static final String QUOTED_CHAR_DOUBLE_QUOTE = "\"";
    private static final String CHAR_SEPARATOR_SEMI_COMMA = ";";
    private static final String CHAR_SEPARATOR_COMMA = ",";
    private static final String CHAR_SEPARATOR_TAB = "\t";
    private static final String CHAR_SEPARATOR_PIPE = "|";
    private static final int MAX_ROWS = 200;
    private final FileImporterModel model;
    private final MainFrame view;
    private boolean result;
    private CSVImportSettings settings;
    private final EncodingDetector encodingDetector;
    private boolean ready;

    public CSVPreferenceHandler(FileImporterModel model, MainFrame view) {
        this.model = model;
        this.view = view;
        this.encodingDetector = new EncodingDetector();
    }

    public void preview(CSVImportSettings settings) {
        this.settings = settings;
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        CSVPanel cvsp = new CSVPanel();
        cvsp.autoDetectBusyLabel.setVisible(false);
        cvsp.autoDetectBusyLabel.setBusy(false);
        this.initBindings(settings, cvsp);
        JScrollPane tablePane = new JScrollPane();
        VTable prePreviewTable = new VTable();
        prePreviewTable.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        tablePane.add((Component)((Object)prePreviewTable));
        tablePane.setViewportView((Component)((Object)prePreviewTable));
        prePreviewTable.setFillsViewportHeight(true);
        jp.add(cvsp);
        jp.add(tablePane);
        this.view.addPreviewPane(jp);
        this.view.getSplitPane().setDividerLocation(-1);
        this.settings.addListener((a, b, c) -> {
            if (!this.settings.IGNORE_VISUAL_PROPERTIES.contains(a)) {
                this.enableControls2((JTable)((Object)prePreviewTable));
            }
        });
        this.enableControls2((JTable)((Object)prePreviewTable));
        this.view.setSize(Math.max(700, this.view.getWidth()), 550);
        this.view.setPreferredSize(new Dimension(Math.max(700, this.view.getWidth()), 550));
        this.view.revalidate();
        this.view.pack();
        this.view.getFrame().setLocationRelativeTo(null);
        this.bindActions(cvsp, (JTable)((Object)prePreviewTable));
    }

    private void enableControls2(final JTable prePreviewTable) {
        boolean enabled;
        boolean bl = enabled = this.settings != null && this.settings.getCharSeparator().length() > 0;
        if (enabled && this.ready) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setVisible(true);
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setCursor(new Cursor(3));
                        CSVPreferenceHandler.this.previewInternal(prePreviewTable);
                    }
                    finally {
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setVisible(false);
                        CSVPreferenceHandler.this.view.getFrame().getGlassPane().setCursor(null);
                    }
                    return null;
                }
            }.execute();
        }
    }

    public CSVImportSettings getPreferences() {
        this.result = false;
        CSVPreferenceDialog cpg = new CSVPreferenceDialog((Frame)this.view.getFrame(), true);
        this.settings = new CSVImportSettings();
        cpg.tablePane.setViewportView((Component)((Object)cpg.prePreviewTable));
        cpg.cancelButton.addActionListener(l -> cpg.setVisible(false));
        cpg.okButton.addActionListener(l -> {
            this.result = true;
            cpg.setVisible(false);
        });
        this.initBindings(this.settings, cpg.getCSVPanel());
        this.enableControls(cpg);
        this.settings.addListener((a, b, c) -> {
            if (!this.settings.IGNORE_VISUAL_PROPERTIES.contains(a)) {
                this.enableControls(cpg);
            }
        });
        cpg.setTitle(this.model.getFileName());
        cpg.getCSVPanel().setVisible(true);
        cpg.setLocationRelativeTo(new JFrame(this.view.getGraphicsConfiguration()));
        this.bindActions(cpg.getCSVPanel(), (JTable)((Object)cpg.prePreviewTable));
        cpg.setVisible(true);
        if (this.result) {
            return this.settings;
        }
        return null;
    }

    private void bindActions(CSVPanel panel, JTable previewTable) {
        panel.autoDetectDatatypesButton.addActionListener(al -> {
            TableModel m = previewTable.getModel();
            if (m instanceof PreviewTableModel) {
                new BackgroundRunner(() -> {
                    SwingUtilities.invokeLater(() -> {
                        cSVPanel.autoDetectDatatypesButton.setEnabled(false);
                        cSVPanel.autoDetectBusyLabel.setBusy(true);
                        cSVPanel.autoDetectBusyLabel.setVisible(true);
                    });
                    try {
                        new ImportTablePreview().detectTypes(previewTable);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(() -> {
                            cSVPanel.autoDetectBusyLabel.setBusy(false);
                            cSVPanel.autoDetectBusyLabel.setVisible(false);
                            cSVPanel.autoDetectDatatypesButton.setEnabled(true);
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(() -> {
                        cSVPanel.autoDetectBusyLabel.setBusy(false);
                        cSVPanel.autoDetectBusyLabel.setVisible(false);
                        cSVPanel.autoDetectDatatypesButton.setEnabled(true);
                    });
                }).execute();
            }
        });
        panel.resetDataTypes.addActionListener(al -> new ImportTablePreview().resetDataTypes(previewTable));
        panel.editColumnsButton.addActionListener(al -> new ImportTablePreview().editColumns(this.settings, previewTable));
    }

    static void saveSettingsToConfig(CSVImportSettings settings) {
        Config config = ConfigHandler.getConfig();
        config.setConfigValue(IMPORT_CSV_SEPARATOR, settings.getCharSeparator());
        config.setConfigValue(IMPORT_CSV_QUOTE, settings.getQuotedChar());
        config.setConfigValue(IMPORT_CSV_FIRST_LINE_HEADER, settings.isFirstRowHeaders());
        config.setConfigValue(IMPORT_CSV_INCLUDE_ROW_NUMBER, settings.isIncludeRowNumberColumn());
    }

    private void initBindings(CSVImportSettings settings, CSVPanel panel) {
        APresenter<CSVImportSettings, CsvImportSettingModel, CSVPanel> presenter = new APresenter<CSVImportSettings, CsvImportSettingModel, CSVPanel>(new CsvImportSettingModel(), panel){

            protected void initBindings() {
                this.bind(((CSVPanel)this.view).firstLineHeaders).to(((CsvImportSettingModel)this.model).firstRowHeaders);
                this.bind(((CSVPanel)this.view).includeRowColumn).to(((CsvImportSettingModel)this.model).includeRowNumberColumn);
                this.bind(((CSVPanel)this.view).maxRowsSpinner).to(((CsvImportSettingModel)this.model).maxRows, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(0), Integer.valueOf(1));
                this.bind(((CSVPanel)this.view).skipRowsBeforeHeaderSpinner).to(((CsvImportSettingModel)this.model).skipRowsBeforeHeader, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(0), Integer.valueOf(1));
                this.bind(((CSVPanel)this.view).skipRowsAfterHeaderSpinner).to(((CsvImportSettingModel)this.model).skipRowsAfterHeader, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(0), Integer.valueOf(1));
                this.bind(((CSVPanel)this.view).quoteOther, ((CSVPanel)this.view).quoteOtherText, new JRadioButton[]{((CSVPanel)this.view).quoteDoubleQuote, ((CSVPanel)this.view).quoteSingleQuote, ((CSVPanel)this.view).noQuoteRadio}).to(((CsvImportSettingModel)this.model).quotedChar, (Object[])new String[]{CSVPreferenceHandler.QUOTED_CHAR_DOUBLE_QUOTE, CSVPreferenceHandler.QUOTED_CHAR_SINGLE_QUOTE, CSVPreferenceHandler.QUOTED_CHAR_NO_QUOTE}).withMaxLength(1);
                this.bind(((CSVPanel)this.view).separatorOther, ((CSVPanel)this.view).separatorOtherText, new JRadioButton[]{((CSVPanel)this.view).separatorComma, ((CSVPanel)this.view).separatorPipe, ((CSVPanel)this.view).separatorSemiComma, ((CSVPanel)this.view).separatorTab}).to(((CsvImportSettingModel)this.model).charSeparator, (Object[])new String[]{CSVPreferenceHandler.CHAR_SEPARATOR_COMMA, CSVPreferenceHandler.CHAR_SEPARATOR_PIPE, CSVPreferenceHandler.CHAR_SEPARATOR_SEMI_COMMA, CSVPreferenceHandler.CHAR_SEPARATOR_TAB}).withMaxLength(1);
            }
        };
        Config config = ConfigHandler.getConfig();
        settings.setCharSeparator(config.getStringConfigValue(IMPORT_CSV_SEPARATOR, CHAR_SEPARATOR_TAB));
        settings.setQuotedChar(config.getStringConfigValue(IMPORT_CSV_QUOTE, QUOTED_CHAR_DOUBLE_QUOTE));
        settings.setFirstRowHeaders(config.getBooleanConfigValue(IMPORT_CSV_FIRST_LINE_HEADER, true));
        settings.setIncludeRowNumberColumn(config.getBooleanConfigValue(IMPORT_CSV_INCLUDE_ROW_NUMBER, true));
        presenter.setObject((Object)settings);
        this.ready = true;
    }

    private void enableControls(final CSVPreferenceDialog cpg) {
        boolean enabled = this.settings != null && this.settings.getCharSeparator().length() > 0;
        cpg.okButton.setEnabled(enabled);
        if (enabled && this.ready) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        cpg.getGlassPane().setVisible(true);
                        cpg.getGlassPane().setCursor(new Cursor(3));
                        CSVPreferenceHandler.this.previewInternal((JTable)((Object)cpg.prePreviewTable));
                    }
                    finally {
                        cpg.prePreviewTable.packAll();
                        cpg.getGlassPane().setVisible(false);
                        cpg.getGlassPane().setCursor(null);
                    }
                    return null;
                }
            }.execute();
        }
    }

    private void previewInternal(JTable previewTable) {
        this.ready = false;
        File file = new File(this.model.getFileName());
        String encodingReal = this.encodingDetector.detectFileEncodingFast(file);
        ImportTablePreview imp = new ImportTablePreview();
        Vector data = imp.getData();
        Vector headers = imp.getHeaders();
        String[] header = new String[]{};
        int rows = 0;
        int maxCols = 0;
        try {
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (SkipBOMReader r = new SkipBOMReader((InputStream)new FileInputStream(file), encodingReal);){
                    Throwable throwable2 = null;
                    Object var14_19 = null;
                    try (CsvListReader csv = new CsvListReader((Reader)r, this.getPrefs()){

                        public List<String> read() throws IOException {
                            if (this.readRow()) {
                                return this.getColumns();
                            }
                            return null;
                        }
                    };){
                        int i = 0;
                        while (i < this.settings.getSkipRowsBeforeHeader()) {
                            csv.read();
                            ++i;
                        }
                        if (this.settings.isFirstRowHeaders()) {
                            header = csv.getHeader(false);
                        }
                        i = 0;
                        while (i < this.settings.getSkipRowsAfterHeader()) {
                            csv.read();
                            ++i;
                        }
                        while (rows++ < (this.settings.getMaxRows() > 0 ? Math.min(200, this.settings.getMaxRows()) : 200)) {
                            List strings = csv.read();
                            if (strings == null) continue;
                            maxCols = Math.max(maxCols, strings.size());
                            data.add(new Vector(strings));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    int i = 0;
                    while (i < maxCols) {
                        if (i <= header.length - 1) {
                            headers.add(header[i]);
                        } else {
                            headers.add(i);
                        }
                        ++i;
                    }
                    imp.setModelData(previewTable, this.settings, 8);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ready = true;
            }
        }
        finally {
            this.ready = true;
        }
    }

    private CsvPreference getPrefs() {
        return new CsvPreference.Builder(this.getQuoteChar(), this.settings.getCharSeparator().codePointAt(0), QUOTED_CHAR_NO_QUOTE).build();
    }

    private char getQuoteChar() {
        if (this.settings.getQuotedChar().length() == 0) {
            return '\u0000';
        }
        return this.settings.getQuotedChar().charAt(0);
    }

    @SoftCopy
    private class CsvImportSettingModel
    extends AModel<CSVImportSettings> {
        IProperty<String> quotedChar = this.getProperty("quotedChar");
        IProperty<String> charSeparator = this.getProperty("charSeparator");
        IProperty<Boolean> firstRowHeaders = this.getProperty("firstRowHeaders");
        IProperty<Boolean> includeRowNumberColumn = this.getProperty("includeRowNumberColumn");
        IProperty<Integer> maxRows = this.getProperty("maxRows");
        IProperty<Integer> skipRowsBeforeHeader = this.getProperty("skipRowsBeforeHeader");
        IProperty<Integer> skipRowsAfterHeader = this.getProperty("skipRowsAfterHeader");

        private CsvImportSettingModel() {
        }

        protected void copyObject(CSVImportSettings object) {
            this.copy = object;
        }
    }
}

