/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.table.ColumnType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringDataTypeDetector {
    private final int guessMax;
    private int guessed = 0;
    private boolean datePossible = true;
    private boolean intPossible = true;
    private boolean longPossible = true;
    private boolean floatPossible = true;
    private final Pattern regex_date_time = Pattern.compile("(\\d{2,4})(-?)(\\d{2})(-?)(\\d{2})(T?)([0-9 :.]*)");
    private final Pattern int_float_pattern = Pattern.compile("(-?)(\\d*)(\\.\\d*)?");
    public static final DateFormat FORMAT_YYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_SECOND;
    private static final DateTimeFormatter ISO_LOCAL_DATE_TIME;

    static {
        FORMAT_YYYYMMDD.setLenient(false);
        TIME_SECOND = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 3, true).toFormatter();
        ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(TIME_SECOND).toFormatter();
    }

    public StringDataTypeDetector() {
        this.guessMax = Integer.MAX_VALUE;
    }

    public StringDataTypeDetector(int maxGuesses) {
        this.guessMax = maxGuesses;
    }

    public boolean addValue(String value) {
        Matcher m;
        if (value == null || value.length() == 0) {
            return true;
        }
        if (this.guessed >= this.guessMax) {
            return false;
        }
        ++this.guessed;
        value = value.trim();
        if (this.datePossible) {
            m = this.regex_date_time.matcher(value);
            if (m.matches()) {
                if (!Objects.equals(m.group(2), m.group(4))) {
                    this.datePossible = false;
                } else {
                    String date = String.valueOf(m.group(1)) + "-" + m.group(3) + "-" + m.group(5);
                    try {
                        FORMAT_YYYYMMDD.parse(date);
                    }
                    catch (Exception ex) {
                        try {
                            ISO_LOCAL_DATE_TIME.parse(m.group());
                        }
                        catch (Exception ex2) {
                            this.datePossible = false;
                        }
                    }
                }
            } else {
                this.datePossible = false;
            }
        }
        if (this.floatPossible) {
            m = this.int_float_pattern.matcher(value);
            if (!m.matches()) {
                this.longPossible = false;
                this.intPossible = false;
                this.floatPossible = false;
            } else if (m.group(3) != null) {
                this.longPossible = false;
                this.intPossible = false;
            } else if (this.intPossible) {
                try {
                    long l = Long.valueOf(value);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        this.intPossible = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.floatPossible || this.datePossible;
    }

    public List<ColumnType> getTypesDetected() {
        ArrayList<ColumnType> types = new ArrayList<ColumnType>();
        if (this.longPossible) {
            types.add(ColumnType.LONG);
        }
        if (this.floatPossible) {
            types.add(ColumnType.FLOAT);
        }
        if (this.intPossible) {
            types.add(ColumnType.INT);
        }
        if (this.datePossible) {
            types.add(ColumnType.DATETIME);
        }
        types.add(ColumnType.TEXT);
        return types;
    }

    public ColumnType getPreferredType() {
        boolean intSize;
        boolean bl = intSize = this.longPossible || this.floatPossible || this.intPossible;
        if (intSize) {
            if (this.datePossible) {
                return ColumnType.TEXT;
            }
            return this.intPossible ? ColumnType.INT : (this.longPossible ? ColumnType.LONG : ColumnType.FLOAT);
        }
        if (this.datePossible) {
            return ColumnType.DATETIME;
        }
        return ColumnType.TEXT;
    }
}

