/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import java.io.File;
import java.util.Collections;
import java.util.List;

public class ImportResult {
    private final boolean successful;
    private final List<File> files;
    private final String failureReason;
    private final boolean cancelled;
    private int rowsImported;
    public static ImportResult CANCELLED = new ImportResult(true);
    private final Exception exception;
    private long durationMs;

    public ImportResult(String failureReason) {
        this(failureReason, null);
    }

    public ImportResult(String failureReason, Exception ex) {
        this.exception = ex;
        this.successful = false;
        this.failureReason = failureReason;
        this.files = Collections.EMPTY_LIST;
        this.cancelled = false;
    }

    private ImportResult(boolean cancelled) {
        this.successful = false;
        this.failureReason = "";
        this.files = Collections.EMPTY_LIST;
        this.cancelled = cancelled;
        this.exception = null;
    }

    public ImportResult(List<File> files, int rowsImported) {
        this.successful = true;
        this.failureReason = "";
        this.files = files;
        this.cancelled = false;
        this.exception = null;
        this.rowsImported = rowsImported;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public List<File> getFilesProcessed() {
        return this.files;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Exception getException() {
        return this.exception;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    public int getRowsImported() {
        return this.rowsImported;
    }
}

