/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ColumnSelected {
    private final Set<Integer> columnsSelected;

    public ColumnSelected(int numberOfColumns) {
        this.columnsSelected = IntStream.range(1, numberOfColumns + 1).boxed().collect(Collectors.toSet());
    }

    public void toggle(int colValue) {
        this.assertColumnId(colValue);
        if (this.columnsSelected.contains(colValue)) {
            this.columnsSelected.remove(colValue);
        } else {
            this.columnsSelected.add(colValue);
        }
    }

    public void setSelected(int colValue, boolean select) {
        this.assertColumnId(colValue);
        if (select) {
            this.columnsSelected.add(colValue);
        } else {
            this.columnsSelected.remove(colValue);
        }
    }

    public int getSelectedSize() {
        return this.columnsSelected.size();
    }

    public boolean isSelected(int colValue) {
        this.assertColumnId(colValue);
        return this.columnsSelected.contains(colValue);
    }

    private void assertColumnId(int colValue) {
        if (colValue == 0) {
            throw new RuntimeException("This column is 1-based");
        }
    }

    public Set<Integer> getSelectedColumns() {
        return this.columnsSelected;
    }
}

