/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.filerunner.core.DocumentListenerAdapter;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.renderer.DefaultListRenderer;

public class ColumnEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JComboBox jc = new JComboBox();

    public ColumnEditor() {
        this.jc.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.jc.setRenderer(new DefaultListRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel jl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof String) {
                    jl.setText((String)value);
                } else if (value instanceof ColumnType) {
                    jl.setText(((ColumnType)value).getType().toString());
                    jl.setForeground(Color.BLUE);
                }
                return jl;
            }
        });
        this.jc.setEditor(new BasicComboBoxEditorExtension());
    }

    @Override
    public Object getCellEditorValue() {
        return this.jc.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.jc.setEditable(true);
        Vector<ColumnType> v = new Vector<ColumnType>();
        v.add(ColumnType.TEXT);
        v.add(ColumnType.INT);
        v.add(ColumnType.FLOAT);
        v.add(ColumnType.LONG);
        v.add(ColumnType.DATETIME);
        v.add(ColumnType.VARBINARY);
        this.jc.setModel(new DefaultComboBoxModel(v));
        if (value instanceof Column) {
            Column c = (Column)value;
            if (c.getStandardType().isPresent()) {
                this.jc.setSelectedItem(c.getStandardType().get());
            } else if (c.getNativeType().isPresent()) {
                this.jc.setSelectedItem(c.getNativeType().get());
            }
        }
        return this.jc;
    }

    private final class BasicComboBoxEditorExtension
    extends BasicComboBoxEditor {
        private Object lastItem = null;
        private boolean settingFromCombo = false;

        BasicComboBoxEditorExtension() {
            this.editor.getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> {
                this.lastItem = this.editor.getText();
                if (!this.settingFromCombo) {
                    ColumnEditor.this.jc.setSelectedItem(this.lastItem);
                }
            })));
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject instanceof ColumnType) {
                this.settingFromCombo = true;
                this.editor.setText(((ColumnType)anObject).getType().toString());
                this.settingFromCombo = false;
            } else if (anObject != null) {
                this.editor.setText(anObject.toString());
            }
            this.lastItem = anObject;
        }

        @Override
        public Object getItem() {
            return this.lastItem;
        }
    }
}

