/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.dbrunner.table.TableException;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.imports.core.AColumnSettings;
import com.sigge.filerunner.imports.core.BasicArchiveEntry;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.IImporterV3;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.core.SimpleProgressStatus;
import com.sigge.filerunner.imports.core.TableUtils;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.core.DialogView;
import com.sigge.filerunner.view.core.IIcon;
import com.sigge.filerunner.view.core.ILabel;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.view.ICompletionProgress;
import com.siggemannen.view.IStatusProgress;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import java.io.File;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.RootPaneContainer;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class AImporter<E>
implements IImporterV3,
ILabel,
IIcon {
    protected final RootPaneContainer container;

    public AImporter(RootPaneContainer container) {
        this.container = container;
    }

    @Override
    public void importFile(ServerDatabase currentDatabase, ThrowingConsumer<ImportResult> result) {
        List<File> files = this.getFilesImport(this.isSupportsMultipleFiles(), this.getFilters());
        if (files == null || files.size() == 0) {
            result.accept((Object)ImportResult.CANCELLED);
            return;
        }
        E settings = this.getSettings(currentDatabase, files);
        if (settings == null) {
            result.accept((Object)ImportResult.CANCELLED);
            return;
        }
        ValueHolder vh = new ValueHolder();
        ValueHolder ph = new ValueHolder();
        UIOptionBuilderSupplier builder = (UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(() -> {
            LocalDateTime start = DateUtils.getTimeAtUTC();
            ImportResult ir = this.doImport(currentDatabase, files, settings, new SimpleProgressStatus((Tuple<ICompletionProgress, IStatusProgress>)Tuple.of((Object)((ICompletionProgress)vh.getValue()), (Object)((IStatusProgress)ph.getValue()))));
            if (ir != null && ir.isSuccessful()) {
                LocalDateTime finish = DateUtils.getTimeAtUTC();
                ir.setDurationMs(DateUtils.getDuration(start, finish));
            }
            return ir;
        }, result).mainPanel(this.container)).title("Importing files", "Importing files...", "Cancel import")).dialogIcon(DialogView.DEFAULT_ICON)).exceptionCallback(ex -> result.accept((Object)new ImportResult(ex.toString(), (Exception)ex)));
        switch (this.getProgressType()) {
            case DETERMINED: {
                builder.completionProgress((Consumer)vh);
                break;
            }
            default: {
                builder.progress((Consumer)ph);
            }
        }
        UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionSupplier)builder.build()));
    }

    protected ProgressType getProgressType() {
        return ProgressType.UNDETERMINED;
    }

    protected abstract ImportResult doImport(ServerDatabase var1, List<File> var2, E var3, SimpleProgressStatus var4);

    protected abstract E getSettings(ServerDatabase var1, List<File> var2);

    protected boolean isSupportsMultipleFiles() {
        return false;
    }

    public ITable prepareForImport(ServerDatabase currentDatabase, String tableName, AColumnSettings settings, List<ColumnMapping> cm, Optional<Consumer<Integer>> callback) throws TableException, SQLException {
        ColumnSelected selectedColumns = settings.getColumnSelected();
        List<Integer> ordinals = selectedColumns.getSelectedColumns().stream().sorted().collect(Collectors.toList());
        ArrayList<String> columns = new ArrayList<String>(ordinals.size());
        ordinals.forEach(s -> {
            boolean bl = columns.add(null);
        });
        int counter = 0;
        int header = 0;
        while (header < settings.getDbColumns().size()) {
            Column ch = settings.getDbColumns().get(header);
            String h = ch.getName();
            if (h != null) {
                h = h.trim();
            }
            if (ordinals.contains(header + 1)) {
                columns.set(counter, h);
                ++counter;
                if (callback.isPresent()) {
                    callback.get().accept(header);
                }
            }
            ++header;
        }
        int i = columns.size() - 1;
        while (i >= 0) {
            TableUtils.generateUniqueNames(columns, i);
            --i;
        }
        IDatabaseOperator operator = currentDatabase.getDb().getDatabaseOperator();
        ITableOperator tableOperator = operator.getTableOperator();
        int index = 0;
        ArrayList<Column> tableColumns = new ArrayList<Column>();
        int i2 = 0;
        while (i2 < ordinals.size()) {
            Column c = new Column((String)columns.get(index), new ColumnType(DataType.TEXT));
            if (settings.getDbColumns() != null && settings.getDbColumns().size() >= (Integer)ordinals.get(i2)) {
                c = new Column(c.getName(), settings.getDbColumns().get((Integer)ordinals.get(i2) - 1));
            }
            tableColumns.add(c);
            cm.add(new ColumnMapping(c, index++));
            ++i2;
        }
        return tableOperator.openOrCreate(currentDatabase.getDatabase(), tableName, "", tableColumns);
    }

    /*
     * Exception decompiling
     */
    public void importArchive(File f, SimpleProgressStatus progressStatus, Consumer<BasicArchiveEntry> entryConsumer) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected FileNameExtensionFilter[] getFilters() {
        return new FileNameExtensionFilter[0];
    }

    public List<File> getFilesImport(boolean multiple, FileNameExtensionFilter ... ff) {
        if (multiple) {
            List<File> openFiles = FileUtils.openFiles(this.container != null ? this.container.getRootPane() : null, null, ff);
            if (openFiles == null) {
                return null;
            }
            return new ArrayList<File>(openFiles);
        }
        File f = FileUtils.openFile(this.container != null ? this.container.getRootPane() : null, ff);
        if (f == null) {
            return null;
        }
        return new ArrayList<File>(Arrays.asList(f));
    }

    public static enum ProgressType {
        DETERMINED,
        UNDETERMINED;

    }
}

