/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.csv;

import com.sigge.filerunner.export.IExporter;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.view.ICompletionProgress;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvExporter
implements IExporter<CsvPreference> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean export(List<IResultSetTable> rstd, boolean selectionOnly, OutputStream outStream, CsvPreference fc, ICompletionProgress progress) throws Exception {
        if (fc == null) {
            return false;
        }
        progress.status(0, "Preparing file");
        Throwable throwable = null;
        Object var7_8 = null;
        try (CsvListWriter cv = new CsvListWriter((Writer)new OutputStreamWriter(outStream, StandardCharsets.UTF_8), fc);){
            IResultSetTable rs = selectionOnly ? rstd.get(0).getSelectedSnapshot() : rstd.get(0);
            cv.writeHeader(IntStream.range(0, rs.getColumnCount()).mapToObj(rs::getColumnName).collect(Collectors.toList()).toArray(new String[0]));
            progress.status(0, "Wrote column names");
            String[] obs = new String[rs.getColumnCount()];
            int i = 0;
            block6: while (true) {
                if (i >= rs.getRowCount()) {
                    progress.status(100, "Done");
                    return true;
                }
                if (progress.isCancelled()) {
                    progress.status(100, "Cancelled");
                    return false;
                }
                if (i % 500 == 0) {
                    progress.status((int)((double)i * 1.0 / ((double)rs.getRowCount() * 1.0) * 100.0), "Processed: " + i + " / " + rs.getRowCount());
                }
                int ii = 0;
                while (true) {
                    if (ii >= rs.getColumnCount()) {
                        cv.write(obs);
                        ++i;
                        continue block6;
                    }
                    obs[ii] = rs.getValueForDisplay(i, ii);
                    ++ii;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

