/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.csv;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.PreferenceHelper;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.export.csv.CSVPanel;
import com.sigge.filerunner.export.csv.CsvExporter;
import com.sigge.filerunner.view.core.DialogView;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ValueHolder;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.AlwaysQuoteMode;
import org.supercsv.quote.NormalQuoteMode;
import org.supercsv.quote.QuoteMode;

@Singleton
public class CsvExportAction
extends ExportAction<CsvPreference> {
    private static final String EXPORTS_CSV_QUOTE_MODE = "exports.csv.quoteMode";
    private static final String EXPORTS_CSV_NL = "exports.csv.nl";
    private static final String EXPORTS_CSV_QUOTE = "exports.csv.quote";
    private static final String EXPORTS_CSV_SEPARATOR = "exports.csv.separator";
    private static final String SINGLE_QUOTE = "'";
    private static final String SEMI_COMMA = ";";
    private static final String COMMA = ",";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String TAB = "\t";

    @Inject
    public CsvExportAction(@Named(value="mainFrame") JFrame mainFrame) {
        super("CSV", new CsvExporter(), mainFrame);
    }

    @Override
    public String getFile(CsvPreference preferences) {
        if (preferences == null) {
            return null;
        }
        return this.getFileToExportTo(new FileNameExtensionFilter("Text (*.txt)", "txt"), new FileNameExtensionFilter("CSV (*.csv)", "csv"));
    }

    @Override
    public CsvPreference getPreferences(List<IResultSetTable> model, boolean selectionOnly) {
        DialogView dv = new DialogView(this.container, true);
        CSVPanel csv = new CSVPanel();
        dv.setContent(csv, true);
        dv.pack();
        dv.setTitle("Get csv preferences");
        dv.centerOnCorrectScreen(this.container);
        Config config = ConfigHandler.getConfig();
        String defaultSeparator = config.getStringConfigValue(EXPORTS_CSV_SEPARATOR, TAB);
        String defaultQuote = config.getStringConfigValue(EXPORTS_CSV_QUOTE, DOUBLE_QUOTE);
        String nl = config.getStringConfigValue(EXPORTS_CSV_NL, System.getProperty("line.separator"));
        int quoteStyle = config.getNumberConfigValue(EXPORTS_CSV_QUOTE_MODE, 0).intValue();
        PreferenceHelper.PreferenceValue sep = PreferenceHelper.bind(Arrays.asList(csv.separatorTab, csv.separatorComma, csv.separatorSemiComma, csv.separatorOther), Arrays.asList(TAB, COMMA, SEMI_COMMA), csv.separatorOtherText, 1);
        PreferenceHelper.PreferenceValue quote = PreferenceHelper.bind(Arrays.asList(csv.quoteDoubleQuote, csv.quoteSingleQuote, csv.quoteOther), Arrays.asList(DOUBLE_QUOTE, SINGLE_QUOTE), csv.quoteOtherText, 1);
        PreferenceHelper.PreferenceValue eol = PreferenceHelper.bind(Arrays.asList(csv.eolN, csv.eolR, csv.eolRN, csv.eolOther), Arrays.asList("\n", "\r", "\r\n"), csv.eolOtherText, -1);
        switch (nl) {
            case "\r\n": {
                csv.eolRN.setSelected(true);
                break;
            }
            case "\n": {
                csv.eolN.setSelected(true);
                break;
            }
            case "\r": {
                csv.eolRN.setSelected(true);
                break;
            }
            default: {
                csv.eolOther.setSelected(true);
                csv.eolOtherText.setEnabled(true);
                csv.eolOtherText.setText(nl);
            }
            case "": 
        }
        final AlwaysQuoteMode alwaysQuoteMode = new AlwaysQuoteMode();
        NormalQuoteMode normalQuoteMode = new NormalQuoteMode();
        Binder.Presenter qm = Binder.bindToCombo(csv.quoteStyleCombo, Arrays.asList(alwaysQuoteMode, normalQuoteMode));
        csv.quoteStyleCombo.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                QuoteMode qm = (QuoteMode)value;
                if (qm.equals(alwaysQuoteMode)) {
                    this.setText("Always quote");
                } else {
                    this.setText("Quote when needed");
                }
                return this;
            }
        });
        switch (defaultSeparator) {
            case "\t": {
                csv.separatorTab.setSelected(true);
                break;
            }
            case ",": {
                csv.separatorComma.setSelected(true);
                break;
            }
            case ";": {
                csv.separatorSemiComma.setSelected(true);
                break;
            }
            default: {
                csv.separatorOther.setSelected(true);
                csv.separatorOtherText.setEnabled(true);
                csv.separatorOtherText.setText(defaultSeparator);
            }
            case "": 
        }
        switch (defaultQuote) {
            case "\"": {
                csv.quoteDoubleQuote.setSelected(true);
                break;
            }
            case "'": {
                csv.quoteSingleQuote.setSelected(true);
                break;
            }
            default: {
                csv.quoteOther.setSelected(true);
                csv.quoteOtherText.setEnabled(true);
                csv.quoteOtherText.setText(defaultQuote);
            }
            case "": 
        }
        switch (quoteStyle) {
            case 0: {
                csv.quoteStyleCombo.setSelectedItem(alwaysQuoteMode);
                break;
            }
            case 1: {
                csv.quoteStyleCombo.setSelectedItem(normalQuoteMode);
            }
        }
        dv.setVisible(true);
        if (dv.getReturnStatus() == 1) {
            char quoteChar = quote.getValue().charAt(0);
            char delimiterChar = sep.getValue().charAt(0);
            String endOfLineSymbols = eol.getValue();
            QuoteMode quoteMode = (QuoteMode)((ValueHolder)qm.getModel().getObject()).getValue();
            config.setConfigValue(EXPORTS_CSV_QUOTE, String.valueOf(quoteChar));
            config.setConfigValue(EXPORTS_CSV_SEPARATOR, String.valueOf(delimiterChar));
            config.setConfigValue(EXPORTS_CSV_NL, endOfLineSymbols);
            config.setConfigValue(EXPORTS_CSV_QUOTE_MODE, quoteMode.equals(normalQuoteMode) ? 1 : 0);
            return new CsvPreference.Builder(quoteChar, (int)delimiterChar, endOfLineSymbols).useQuoteMode(quoteMode).build();
        }
        return null;
    }

    @Override
    protected boolean isFilePerModel(List<IResultSetTable> model, boolean selectionOnly) {
        return model.size() > 1;
    }

    @Override
    public String getIcon() {
        return "csv.png";
    }
}

