/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.util.stream.Stream;

public class StringUtils {
    private static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static boolean isNotEmpty(String e) {
        return e != null && !e.isEmpty();
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String concatWsStart(String ws, String ... values) {
        StringBuilder sb = new StringBuilder();
        for (String val : values) {
            if (StringUtils.isEmpty(val)) continue;
            sb.append(ws).append(val);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String e) {
        return e == null || e.isEmpty();
    }

    public static boolean isNoneEmpty(String ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!StringUtils.isEmpty(strings[i])) continue;
            return false;
        }
        return true;
    }

    public static String isBlank(String e, String defaultValue) {
        return StringUtils.isEmpty(e) ? defaultValue : e;
    }

    public static String normalizeNewLines(StringBuilder sbuff, String newLine) {
        return StringUtils.normalizeNewLines(sbuff.toString(), newLine);
    }

    public static String normalizeNewLines(String edit, String newLine) {
        if ("\r\n".equals(newLine)) {
            edit = edit.replaceAll("((?<!\r)\n)|(\r(?!\n))", "\r\n");
        }
        if ("\r".equals(newLine)) {
            edit = edit.replaceAll("(\r\n)|((?<!\r)\n)", "\r");
        }
        if ("\n".equals(newLine)) {
            edit = edit.replaceAll("(\r\n)|(\r(?!\n))", "\n");
        }
        return edit;
    }

    public static int maxLength(Stream<String> sess) {
        return sess.map(String::length).max(Integer::compare).orElse(0);
    }

    public static String tabify(String s, int x, int tabSize) {
        int t;
        String c = s.trim();
        String cp = EMPTY + c;
        int tabs = 0;
        while ((t = cp.indexOf("\t")) != -1) {
            tabs = (int)((double)tabs + Math.ceil(((double)t + 0.0) / (double)tabSize));
            if (t + 1 == cp.length()) {
                cp = EMPTY;
                break;
            }
            cp = cp.substring(t + 1);
        }
        return c + StringUtils.repeat("\t", x - (tabs += cp.length() / tabSize));
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str.length()) {
            return "..." + StringUtils.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String overlay(String str, String overlay, int start, int end) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return str.substring(0, start) + overlay + str.substring(end);
    }

    public static String left(String str, int length) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.substring(0, Math.min(length, str.length()));
    }
}

