/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LeastIslandMatcher {
    static final int INF = 1000000;

    public static List<int[]> match(String text, String pattern) {
        int textLength = text.length();
        int patternLength = pattern.length();
        text = text.toLowerCase();
        pattern = pattern.toLowerCase();
        int[] prev = new int[textLength];
        int[] curr = new int[textLength];
        int[][] parent = new int[patternLength][textLength];
        boolean[][] cont = new boolean[patternLength][textLength];
        Arrays.fill(prev, 1000000);
        int i = 0;
        while (i < textLength) {
            if (text.charAt(i) == pattern.charAt(0)) {
                prev[i] = 1;
                parent[0][i] = -1;
            }
            ++i;
        }
        int j = 1;
        while (j < patternLength) {
            Arrays.fill(curr, 1000000);
            int bestSoFar = 1000000;
            int bestIndex = -1;
            int i2 = 0;
            while (i2 < textLength) {
                if (i2 - 2 >= 0 && prev[i2 - 2] < bestSoFar) {
                    bestSoFar = prev[i2 - 2];
                    bestIndex = i2 - 2;
                }
                if (text.charAt(i2) == pattern.charAt(j)) {
                    if (i2 > 0 && prev[i2 - 1] < curr[i2]) {
                        curr[i2] = prev[i2 - 1];
                        parent[j][i2] = i2 - 1;
                        cont[j][i2] = true;
                    }
                    if (bestSoFar < 1000000 && bestSoFar + 1 < curr[i2]) {
                        curr[i2] = bestSoFar + 1;
                        parent[j][i2] = bestIndex;
                        cont[j][i2] = false;
                    }
                }
                ++i2;
            }
            int[] tmp = prev;
            prev = curr;
            curr = tmp;
            ++j;
        }
        int end = -1;
        int best = 1000000;
        int i3 = 0;
        while (i3 < textLength) {
            if (prev[i3] < best) {
                best = prev[i3];
                end = i3;
            }
            ++i3;
        }
        if (end == -1) {
            return new ArrayList<int[]>();
        }
        boolean[] mark = new boolean[textLength];
        int i4 = end;
        int j2 = patternLength - 1;
        while (j2 >= 0) {
            mark[i4] = true;
            if (parent[j2][i4] == -1) break;
            i4 = cont[j2][i4] ? i4 - 1 : parent[j2][i4];
            --j2;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        i4 = 0;
        while (i4 < textLength) {
            if (!mark[i4]) {
                ++i4;
                continue;
            }
            int start = i4;
            while (i4 < textLength && mark[i4]) {
                ++i4;
            }
            ranges.add(new int[]{start, i4});
        }
        return ranges;
    }

    public static void main(String[] args) {
        System.out.println(LeastIslandMatcher.match("RamosSportshopenProd", "sopp").stream().map(r -> Arrays.toString(r)).collect(Collectors.toList()));
    }
}

