/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.google.gson.Gson;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.recent.ItemStorer;
import com.sigge.filerunner.sql.SQLBuilder;
import com.siggemannen.core.ThreadUtils;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStorer<E>
implements ItemStorer<E, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonStorer.class);
    private final String type;
    private static final Gson GSON_WRITER = GsonFactory.forWriting();
    private Boolean inited = null;
    protected final int version;
    private JsonUpgrader<E> upgrader;
    private static final String SQL_INSERT = new SQLBuilder("insert into storage ").append("(").append("storage_value, file_year, file_month, file_day, file_hour, file_minute, file_second, file_nano, version").append(")").append("values(?,?,?,?,?,?,?,?,?);").build();
    private static final String SQL_UPDATE = new SQLBuilder("update storage ").append("set storage_value = ?").append(", version = ?").append("WHERE row_id = ?").build();

    public JsonStorer(String namespace, Type token) throws SQLException {
        this(namespace, token, 0);
    }

    public JsonStorer(String namespace, Type token, int version) throws SQLException {
        this(namespace, version, (jsonValue, jsonVersion) -> GsonFactory.forReading().fromJson(jsonValue, token));
    }

    public JsonStorer(String namespace, int version, JsonUpgrader<E> upgrader) throws SQLException {
        this.type = namespace;
        this.version = version;
        this.upgrader = upgrader;
        this.createTables();
    }

    private void createTables() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection c = this.newConnection();){
                if (c == null) {
                    return;
                }
                this.createTablesIfNeeded(c);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error while connecting", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean storeItems(List<StoreItem<E>> items) {
        if (this.inited == null) {
            try {
                this.createTables();
                this.inited = true;
            }
            catch (Exception e) {
                this.inited = false;
            }
        }
        if (!this.inited.booleanValue()) {
            return false;
        }
        Gson gson = GSON_WRITER;
        synchronized (gson) {
            PreparedStatement s;
            Connection conn;
            Throwable throwable;
            block42: {
                block41: {
                    throwable = null;
                    Object var4_7 = null;
                    conn = this.newConnection();
                    s = conn.prepareStatement(SQL_INSERT);
                    conn.setAutoCommit(false);
                    int ix = 0;
                    int i = 0;
                    while (i < items.size()) {
                        StoreItem<E> item = items.get(i);
                        LocalDateTime ld = item.getTime();
                        s.setString(1, GSON_WRITER.toJson(item.getItem()));
                        s.setInt(2, ld.getYear());
                        s.setInt(3, ld.getMonth().getValue());
                        s.setInt(4, ld.getDayOfMonth());
                        s.setInt(5, ld.getHour());
                        s.setInt(6, ld.getMinute());
                        s.setInt(7, ld.getSecond());
                        s.setInt(8, ld.getNano());
                        s.setInt(9, this.version);
                        s.addBatch();
                        if (i + 1 == items.size()) {
                            s.executeBatch();
                            Throwable throwable2 = null;
                            Object var12_18 = null;
                            try (ResultSet rs = s.getGeneratedKeys();){
                                if (rs.next()) {
                                    ix = rs.getInt(1);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        ++i;
                    }
                    conn.commit();
                    if (ix > 0) {
                        int j = items.size() - 1;
                        while (j >= 0) {
                            items.get(j).setId(ix--);
                            --j;
                        }
                    }
                    if (s == null) break block41;
                    s.close();
                }
                if (conn == null) break block42;
                conn.close();
            }
            return true;
            {
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                if (s != null) {
                                    s.close();
                                }
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                if (conn != null) {
                                    conn.close();
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while performing insert", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public List<StoreItem<E>> listItems() {
        return this.listItems("");
    }

    @Override
    public List<StoreItem<E>> listItems(String filter) {
        SQLBuilder sb = new SQLBuilder("SELECT row_id, storage_value, file_year, file_month, file_day, file_hour, file_minute, file_second, file_nano, version FROM storage where 1 = 1 ");
        ArrayList<StoreItem<StoreItem<E>>> rc = new ArrayList<StoreItem<StoreItem<E>>>();
        ArrayList r = new ArrayList();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection conn = this.newConnection();){
                if (filter.length() > 0) {
                    sb.append(" AND ");
                    sb.append(filter);
                }
                sb.append(" ORDER BY row_id DESC LIMIT 100");
                String build = sb.build();
                PreparedStatement s = conn.prepareStatement(build);
                r.stream().forEachOrdered(l -> l.accept((Object)s));
                ResultSet rs = s.executeQuery();
                while (rs.next()) {
                    E upgrade;
                    LocalDateTime ldt = LocalDateTime.of(rs.getInt("file_year"), rs.getInt("file_month"), rs.getInt("file_day"), rs.getInt("file_hour"), rs.getInt("file_minute"), rs.getInt("file_second"), rs.getInt("file_nano"));
                    Integer jsonVersion = rs.getInt("version");
                    if (rs.wasNull()) {
                        jsonVersion = null;
                    }
                    try {
                        upgrade = this.upgrader.upgrade(rs.getString("storage_value"), jsonVersion);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error occured while upgrading item", (Throwable)ex);
                        continue;
                    }
                    if (upgrade == null) continue;
                    rc.add(new StoreItem<E>(upgrade, ldt, rs.getInt("row_id")));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured while fetching history", (Throwable)e);
        }
        return rc;
    }

    @Override
    public void resetItems() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateItem(StoreItem item) {
        Gson gson = GSON_WRITER;
        synchronized (gson) {
            if (item.getId() != 0) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        Connection conn = this.newConnection();
                        try {
                            try (PreparedStatement s = conn.prepareStatement(SQL_UPDATE);){
                                s.setString(1, GSON_WRITER.toJson(item.getItem()));
                                s.setInt(2, this.version);
                                s.setInt(3, item.getId());
                                s.execute();
                            }
                            if (conn == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (conn == null) throw throwable;
                            conn.close();
                            throw throwable;
                        }
                        conn.close();
                        {
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error updating item " + item, (Throwable)e);
                }
            } else {
                this.storeItem(item);
            }
            return;
        }
    }

    protected Connection newConnection() {
        String url = "jdbc:sqlite:db/" + this.type + ".db";
        int i = 0;
        while (i++ < 3) {
            try {
                return DriverManager.getConnection(url);
            }
            catch (Exception e) {
                LOGGER.error("Error getting connection", (Throwable)e);
                ThreadUtils.sleep((int)100);
            }
        }
        return null;
    }

    protected void createTablesIfNeeded(Connection conn) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement s = conn.createStatement();){
                s.execute(new SQLBuilder("CREATE TABLE IF NOT EXISTS storage").append("(").append(" row_id INTEGER PRIMARY KEY, storage_value TEXT, file_year integer, file_month integer, file_day integer").append(", file_hour integer, file_minute integer, file_second integer,").append("file_nano integer, version integer").append(")").build());
                try {
                    s.execute(new SQLBuilder("ALTER TABLE storage  ADD COLUMN version integer default null").build());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error while creating table", (Throwable)e);
        }
    }

    public static interface JsonUpgrader<E> {
        public E upgrade(String var1, Integer var2);
    }
}

