/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.sigge.filerunner.config.ColorTypeAdapter;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonFactory {
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(GsonFactory.class);

    public static Gson forReading() {
        return new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    }

    public static Gson forWriting() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();
    }

    public static <T> T read(String file, Type typeToken) throws Exception {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_FILE_ENCODING);){
            Object object = GsonFactory.forReading().fromJson((Reader)reader, typeToken);
            return (T)object;
        }
    }

    private static Type getType(final Class<?> rawClass, final Class<?> ... parameters) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                Type[] type = new Type[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    type[i] = parameters[i];
                }
                return type;
            }

            @Override
            public Type getRawType() {
                return rawClass;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static <T> T read(String file, Class<?> rawClass, Class<?> ... parameters) throws Exception {
        return GsonFactory.read(file, GsonFactory.getType(rawClass, parameters));
    }

    public static <T> void write(String file, T object) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_FILE_ENCODING);){
            GsonFactory.forWriting().toJson(object, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save the file for some reason", (Throwable)e);
        }
    }
}

