/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.core.IFeedback;
import java.awt.Component;
import javax.swing.JOptionPane;

public class Feedbacker {
    private final String message;
    private String title;
    private Component component;
    private ButtonType buttonType;
    private MessageType messageType;
    private String[] buttons;
    private String defaultButton;

    public Feedbacker(String message, Component parent) {
        this.message = message;
        this.component = parent;
    }

    public Feedbacker(String message) {
        this.message = message;
    }

    public Feedbacker title(String title) {
        this.title = title;
        return this;
    }

    public Feedbacker parent(Component component) {
        this.component = component;
        return this;
    }

    public Feedbacker messageType(ButtonType type) {
        this.buttonType = type;
        return this;
    }

    public Feedbacker buttons(String ... buttons) {
        this.buttons = buttons;
        return this;
    }

    public Feedbacker buttons(int defaultChoice, String ... buttons) {
        this.buttons = buttons;
        this.defaultButton = buttons[defaultChoice];
        return this;
    }

    public Feedbacker defaultButton(String button) {
        this.defaultButton = button;
        return this;
    }

    public Feedbacker messageType(MessageType type) {
        this.messageType = type;
        return this;
    }

    public IFeedback.IFeedbackResult display() {
        int optiontype = 0;
        int messagetype = 3;
        if (this.defaultButton != null && this.buttons == null) {
            this.defaultButton = null;
        }
        if (this.buttons != null) {
            if (this.buttons.length == 0) {
                this.buttons = null;
            } else {
                switch (this.buttons.length) {
                    case 1: {
                        optiontype = -1;
                        messagetype = 1;
                        this.buttonType = ButtonType.INFO;
                        break;
                    }
                    case 2: {
                        optiontype = 0;
                        this.buttonType = ButtonType.YES_NO;
                        break;
                    }
                    case 3: {
                        optiontype = 1;
                        this.buttonType = ButtonType.YES_NO_CANCEL;
                        break;
                    }
                }
            }
        }
        if (this.messageType != null) {
            switch (this.messageType) {
                case ERROR: {
                    messagetype = 0;
                    break;
                }
                case INFO: {
                    messagetype = 1;
                    break;
                }
                case PLAIN: {
                    messagetype = -1;
                    break;
                }
                case QUESTION: {
                    messagetype = 3;
                    break;
                }
                case WARNING: {
                    messagetype = 2;
                    break;
                }
            }
        }
        if (this.buttonType != null) {
            switch (this.buttonType) {
                case INFO: {
                    optiontype = -1;
                    break;
                }
                case OK_CANCEL: {
                    optiontype = 2;
                    break;
                }
                case YES_NO: {
                    optiontype = 0;
                    break;
                }
                case YES_NO_CANCEL: {
                    optiontype = 1;
                    break;
                }
            }
        } else {
            optiontype = 0;
        }
        int retval = JOptionPane.showOptionDialog(this.component, this.message, this.title, optiontype, messagetype, null, this.buttons, this.defaultButton);
        switch (retval) {
            case -1: {
                return IFeedback.IFeedbackResult.CLOSED;
            }
            case 0: {
                return IFeedback.IFeedbackResult.FIRST;
            }
            case 1: {
                return IFeedback.IFeedbackResult.SECOND;
            }
            case 2: {
                return optiontype == 1 ? IFeedback.IFeedbackResult.THIRD : IFeedback.IFeedbackResult.SECOND;
            }
        }
        return IFeedback.IFeedbackResult.SECOND;
    }

    public static enum MessageType {
        ERROR,
        INFO,
        WARNING,
        QUESTION,
        PLAIN;

    }

    public static enum ButtonType {
        INFO,
        YES_NO,
        YES_NO_CANCEL,
        OK_CANCEL;

    }
}

