/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.view.core.ILabel;

public enum Encoding implements ILabel
{
    AUTO_DETECT("Auto-detect", "Auto-detect", null),
    UTF8("UTF8", "UTF-8"),
    UTF16("UTF-16", "UTF-16", BOM.LE),
    UTF16BE("UTF-16BE", "UTF-16 BE", BOM.BE),
    UTF16LE("UTF-16LE", "UTF-16 LE", BOM.LE),
    UTF32("UTF-32", "UTF-32", BOM.LE),
    WIN1252("Cp1252", "Western (Windows 1252"),
    ISO_8859_1("ISO8859_1", "Western (ISO 8859_1)"),
    ISO_8859_3("ISO8859_3", "Western (ISO 8859_3)"),
    ISO_8859_15("ISO8859_15", "Western (ISO 8859_15)"),
    MACROMAN("MacRoman", "Western (MacRoman)"),
    CP1250("Cp1250", "Windows Eastern European"),
    CP1251("Cp1251", "Windows Cyrillic"),
    CP1252("Cp1252", "Windows Latin");

    private String encoding;
    private String encodingLabel;
    private BOM bom;

    private Encoding(String encoding, String encodingLabel, BOM bom) {
        this.encoding = encoding;
        this.encodingLabel = encodingLabel;
        this.bom = bom;
    }

    private Encoding(String encoding, String encodingLabel) {
        this(encoding, encodingLabel, BOM.NONE);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getLabel() {
        return this.encodingLabel;
    }

    public void setEncodingLabel(String encodingLabel) {
        this.encodingLabel = encodingLabel;
    }

    public static Encoding get(String encoding) {
        Encoding[] values = Encoding.values();
        int i = 0;
        while (i < values.length) {
            if (values[i].encoding.equals(encoding)) {
                return values[i];
            }
            ++i;
        }
        return null;
    }

    public BOM getBom() {
        return this.bom;
    }

    public void setBom(BOM bom) {
        this.bom = bom;
    }

    public static enum BOM {
        NONE,
        BE,
        LE;

    }
}

