/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.siggemannen.core.Tuple;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DoubleIndexedList<T>
implements Iterable<T> {
    private final List<T> list;
    private final Map<String, Tuple<Integer, T>> map;
    private final boolean caseInsensitive;

    public DoubleIndexedList(List<T> list, Function<T, String> mapper, boolean caseInsensitive) {
        this.list = list;
        this.caseInsensitive = caseInsensitive;
        this.map = new HashMap<String, Tuple<Integer, T>>();
        int i = 0;
        while (i < list.size()) {
            T t = list.get(i);
            String key = !caseInsensitive || t == null ? mapper.apply(t) : mapper.apply(t).toUpperCase();
            this.map.put(key, Tuple.of((Object)i, t));
            ++i;
        }
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public T get(String value) {
        return (T)this.map.get(value == null || !this.caseInsensitive ? value : value.toUpperCase()).second();
    }

    public int getIndexOf(String value) {
        return (Integer)this.map.get(value == null || !this.caseInsensitive ? value : value.toUpperCase()).first();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public boolean contains(String s) {
        return this.map.get(s == null || !this.caseInsensitive ? s : s.toUpperCase()) != null;
    }
}

