/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.core.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;

public class DateUtils {
    public static final DateFormat FORMAT_YYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat FORMAT_WITH_TIME_AND_MS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateFormat FORMAT_WITH_TIME_COMPACT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final DateTimeFormatter TIME_SECOND = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 3, true).toFormatter();
    private static final DateTimeFormatter ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(TIME_SECOND).toFormatter();
    private static final DateTimeFormatter ISO_DATE_SECOND = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    public static String dateDiff(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        LocalDateTime tempDateTime = LocalDateTime.from(fromDateTime);
        long years = tempDateTime.until(toDateTime, ChronoUnit.YEARS);
        tempDateTime = tempDateTime.plusYears(years);
        long months = tempDateTime.until(toDateTime, ChronoUnit.MONTHS);
        tempDateTime = tempDateTime.plusMonths(months);
        long days = tempDateTime.until(toDateTime, ChronoUnit.DAYS);
        tempDateTime = tempDateTime.plusDays(days);
        long hours = tempDateTime.until(toDateTime, ChronoUnit.HOURS);
        tempDateTime = tempDateTime.plusHours(hours);
        long minutes = tempDateTime.until(toDateTime, ChronoUnit.MINUTES);
        tempDateTime = tempDateTime.plusMinutes(minutes);
        long seconds = tempDateTime.until(toDateTime, ChronoUnit.SECONDS);
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(years).append(" year");
            if (years > 1L) {
                sb.append("s");
            }
            sb.append(" ");
        }
        if (months > 0L) {
            sb.append(months).append(" month");
            if (months > 1L) {
                sb.append("s");
            }
            sb.append(" ");
        }
        if (days > 0L) {
            sb.append(days).append(" day");
            if (days > 1L) {
                sb.append("s");
            }
            sb.append(" ");
        }
        if (hours > 0L) {
            sb.append(String.valueOf(DateUtils.lpad("" + hours, 2)) + ":");
        }
        sb.append(String.valueOf(DateUtils.lpad("" + minutes, 2)) + ":");
        sb.append(DateUtils.lpad("" + seconds, 2));
        return sb.toString();
    }

    public static String getDuration(long ms) {
        LocalDateTime ld = DateUtils.getTimeAtUTC();
        LocalDateTime ld2 = ld.plusSeconds(ms / 1000L);
        return DateUtils.dateDiff(ld, ld2);
    }

    public static String lpad(String number, int padLength) {
        int diff = padLength - number.length();
        if (diff <= 0) {
            return String.valueOf(number);
        }
        return String.valueOf(StringUtils.repeat("0", diff)) + number;
    }

    public static String formatLocalDate(LocalDateTime ld) {
        return DateUtils.formatLocalDate(ld, false);
    }

    public static String formatLocalDate(LocalDateTime ld, boolean formatToSeconds) {
        if (formatToSeconds) {
            return ld.format(ISO_DATE_SECOND);
        }
        return ld.format(ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime getTimeAtUTC() {
        return LocalDateTime.now(Clock.systemUTC());
    }

    public static boolean isOlderThan(LocalDateTime tc, long ms) {
        return ChronoUnit.MILLIS.between(tc, DateUtils.getTimeAtUTC()) > ms;
    }

    public static Long getDuration(LocalDateTime tStart, LocalDateTime tFinish) {
        if (tStart == null || tFinish == null) {
            return null;
        }
        return ChronoUnit.MILLIS.between(tStart, tFinish);
    }
}

