/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigge.filerunner.core.CommandBinding;
import com.sigge.filerunner.sql.OutputFormat;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tools.ExternalTool;
import com.sigge.filerunner.view.tools.SQLTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Config {
    public static final String QUERY_PLAN = "query.queryplan";
    public static final String NEWBIE_SETTING = "query.newbiemode";
    public static final String CLEAR_RESULTS_BEFORE_QUERY_SETTING = "query.clear_result_before_exec";
    public static final String STICKY_DATABASE_SETTING = "query.sticky_database";
    public static final String CANCEL_BATCH_EXEC_ON_ERROR_SETTING = "query.cancel_batch_execution_on_error";
    public static final String ENCRYPTION_SETTINGS = "encryption.settings";
    public static final String EDITING_CP_LINE_SETTINGS = "editing.copy_paste_work_on_whole_line_if_empty";
    private List<RunnerServerConfig> databases = new ArrayList<RunnerServerConfig>();
    private String lastDirectory = "";
    private JsonObject subConfig;
    private List<String> lastSelectedDatabases;
    private List<List<String>> lastDatabases;
    private List<TabContent> contents = new ArrayList<TabContent>();
    private List<TabContent> frozenContents = new ArrayList<TabContent>();
    private int lastContentIndex;
    private List<SQLTool> sqlTools;
    private List<ExternalTool> externalTools;
    private boolean encryptedData;
    private transient char[] keypass;
    private List<CommandBinding> bindings;
    private OutputFormat outputFormat;

    public Config() {
        this.setSubConfig(new JsonObject());
        this.lastSelectedDatabases = new ArrayList<String>();
        this.lastDatabases = new ArrayList<List<String>>();
        this.sqlTools = new ArrayList<SQLTool>();
        this.externalTools = new ArrayList<ExternalTool>();
        this.bindings = new ArrayList<CommandBinding>();
        this.outputFormat = OutputFormat.TABLE;
    }

    public void setDatabases(List<RunnerServerConfig> databases) {
        this.databases = databases;
    }

    public List<RunnerServerConfig> getDatabases() {
        return this.databases;
    }

    public String getLastDirectory() {
        return this.lastDirectory;
    }

    public void setLastDirectory(String lastDirectory) {
        this.lastDirectory = lastDirectory;
    }

    public JsonObject getSubConfig() {
        return this.subConfig;
    }

    public void setSubConfig(JsonObject subConfig) {
        this.subConfig = subConfig;
    }

    public List<TabContent> getContents() {
        return this.contents;
    }

    public void setContents(List<TabContent> contents) {
        this.contents = contents;
    }

    public Boolean getBooleanConfigValue(String path) {
        return this.getBooleanConfigValue(path, false);
    }

    public Boolean getBooleanConfigValue(String path, Boolean defaultValue) {
        this.validatePath(path);
        JsonElement setting = this.traversePath(path);
        if (setting != null) {
            return setting.getAsBoolean();
        }
        return defaultValue;
    }

    public String getStringConfigValue(String path, String defaultValue) {
        this.validatePath(path);
        JsonElement setting = this.traversePath(path);
        if (setting != null) {
            return setting.getAsString();
        }
        return defaultValue;
    }

    public Number getNumberConfigValue(String path, Number defaultValue) {
        this.validatePath(path);
        JsonElement setting = this.traversePath(path);
        if (setting != null) {
            return setting.getAsNumber();
        }
        return defaultValue;
    }

    public List<String> getListValues(String path) {
        JsonElement setting = this.traversePath(path);
        if (setting != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (JsonElement val : setting.getAsJsonArray()) {
                list.add(val.getAsString());
            }
            return list;
        }
        return new ArrayList<String>();
    }

    private void validatePath(String path) {
        if (path == null || path.length() == 0) {
            throw new RuntimeException("Path cannot be null or empty");
        }
    }

    public void removeConfigValue(String path) {
        this.validatePath(path);
        if (this.subConfig == null) {
            this.subConfig = new JsonObject();
        }
        String[] paths = path.split("\\.");
        JsonObject currentTree = this.subConfig;
        int i = 0;
        while (i < paths.length - 1) {
            JsonObject subTree = currentTree.getAsJsonObject(paths[i]);
            if (subTree == null) {
                return;
            }
            currentTree = subTree;
            ++i;
        }
        currentTree.remove(paths[paths.length - 1]);
    }

    public void setConfigStringValues(String path, List<String> stringValues) {
        JsonArray arr = new JsonArray();
        for (String s : stringValues) {
            arr.add(s);
        }
        this.setConfigValue(path, arr);
    }

    public void setConfigValue(String path, Object value) {
        this.validatePath(path);
        if (this.subConfig == null) {
            this.subConfig = new JsonObject();
        }
        JsonObject currentTree = this.subConfig;
        String[] paths = path.split("\\.");
        int i = 0;
        while (i < paths.length - 1) {
            JsonObject subTree = currentTree.getAsJsonObject(paths[i]);
            if (subTree == null) {
                subTree = new JsonObject();
                currentTree.add(paths[i], (JsonElement)subTree);
            }
            currentTree = subTree;
            ++i;
        }
        if (value instanceof Boolean) {
            currentTree.addProperty(paths[paths.length - 1], (Boolean)value);
        } else if (value instanceof String) {
            currentTree.addProperty(paths[paths.length - 1], (String)value);
        } else if (value instanceof Number) {
            currentTree.addProperty(paths[paths.length - 1], (Number)value);
        } else if (value instanceof Character) {
            currentTree.addProperty(paths[paths.length - 1], (Character)value);
        } else if (value instanceof JsonElement) {
            currentTree.add(paths[paths.length - 1], (JsonElement)value);
        } else {
            throw new RuntimeException("Incompatible value for JSON:" + value);
        }
    }

    private JsonElement traversePath(String path) {
        JsonObject mainSetting = this.getSubConfig();
        if (mainSetting == null) {
            return null;
        }
        JsonObject subSetting = null;
        String[] paths = path.split("\\.");
        int i = 0;
        while (i < paths.length - 1) {
            subSetting = mainSetting.getAsJsonObject(paths[i]);
            if (subSetting == null) {
                return null;
            }
            mainSetting = subSetting;
            ++i;
        }
        return mainSetting.get(paths[paths.length - 1]);
    }

    public List<SQLTool> getSqlTools() {
        return this.sqlTools;
    }

    public void setSqlTools(List<SQLTool> sqlTools) {
        this.sqlTools = sqlTools;
    }

    public List<ExternalTool> getExternalTools() {
        return this.externalTools;
    }

    public void setExternalTools(List<ExternalTool> externalTools) {
        this.externalTools = externalTools;
    }

    public List<String> getLastSelectedDatabases() {
        return this.lastSelectedDatabases;
    }

    public void setLastSelectedDatabases(List<String> lastSelectedDatabases) {
        this.lastSelectedDatabases = lastSelectedDatabases;
    }

    public boolean isEncryptedData() {
        return this.encryptedData;
    }

    public void setEncryptedData(boolean encryptedData) {
        this.encryptedData = encryptedData;
    }

    public char[] getKeypass() {
        return this.keypass;
    }

    public void setKeypass(char[] keypass) {
        this.keypass = keypass;
    }

    public List<CommandBinding> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<CommandBinding> bindings) {
        this.bindings = bindings;
    }

    public int getLastContentIndex() {
        return this.lastContentIndex;
    }

    public void setLastContentIndex(int lastContentIndex) {
        this.lastContentIndex = lastContentIndex;
    }

    public List<TabContent> getFrozenContents() {
        return this.frozenContents;
    }

    public void setFrozenContents(List<TabContent> frozenContents) {
        this.frozenContents = frozenContents;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public List<List<String>> getLastDatabases() {
        return this.lastDatabases;
    }

    public void setLastDatabases(List<List<String>> lastDatabases) {
        this.lastDatabases = lastDatabases;
    }

    public void assignDatabaseIds() {
        int maxId = 0;
        HashMap<Integer, List> dups = new HashMap<Integer, List>();
        for (RunnerServerConfig config : this.databases) {
            if (config.getId() > maxId) {
                maxId = config.getId();
            }
            dups.computeIfAbsent(config.getId(), f -> new ArrayList()).add(config);
        }
        int i = this.databases.size() - 1;
        while (i >= 0) {
            RunnerServerConfig config = this.databases.get(i);
            List dupes = (List)dups.get(config.getId());
            if (config.getId() == 0 || dupes.size() > 1) {
                ++maxId;
                if (config.getId() > 0) {
                    System.out.println("Removing dupe: " + config + "with id: " + config.getId());
                }
                config.setId(maxId);
                int j = 0;
                while (j < dupes.size()) {
                    RunnerServerConfig theDupe = (RunnerServerConfig)dupes.get(j);
                    if (theDupe == config) {
                        dupes.remove(j);
                        break;
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    public boolean isStickyServer() {
        return this.getBooleanConfigValue(STICKY_DATABASE_SETTING, true);
    }
}

