/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.IUsageObject;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SQLSubObject
implements Comparable<SQLSubObject>,
IUsageObject,
ISQLColumn {
    private static final String USAGE = "usage";
    private final String name;
    private final String type;
    private Map<String, Object> customProperties = null;

    public SQLSubObject(String name, String datatype) {
        this.name = name;
        this.type = datatype;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Optional<Map<String, Object>> getCustomProperties() {
        return Optional.ofNullable(this.customProperties);
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    @Override
    public int compareTo(SQLSubObject o) {
        if (o == null) {
            return 1;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        return "\nSubject=[" + this.name + ", type=" + this.type + " props=" + this.customProperties;
    }

    @Override
    public <T> T getCustomProperty(String property) {
        if (this.customProperties == null) {
            return null;
        }
        return (T)this.customProperties.get(property);
    }

    @Override
    public <T> T getCustomProperty(String name, T defaultValue) {
        T t = this.getCustomProperty(name);
        return t == null ? defaultValue : t;
    }

    public <T> SQLSubObject putCustomProperty(String property, T value) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        this.customProperties.put(property, value);
        return this;
    }

    @Override
    public Optional<SQLObjectUsage> getUsage() {
        return Optional.ofNullable(this.getCustomProperty(USAGE));
    }

    @Override
    public void setUsage(SQLObjectUsage usage) {
        this.putCustomProperty(USAGE, usage);
    }

    @Override
    public boolean isOutput() {
        return this.getCustomProperty("PARAMETER_OUTPUT", false);
    }

    @Override
    public String getComputedDefinition() {
        return (String)this.getCustomProperty("COLUMN_COMPUTED");
    }

    @Override
    public boolean isPersisted() {
        return this.getCustomProperty("COLUMN_PERSISTED", false);
    }

    @Override
    public boolean isNullable() {
        return this.getCustomProperty("COLUMN_NULLABLE", true);
    }

    @Override
    public boolean isAutoIncrement() {
        return this.getCustomProperty("COLUMN_IDENTITY", false);
    }

    @Override
    public String getDefault() {
        return (String)this.getCustomProperty("DEFAULT");
    }

    public static class SQLSubObjectBuilder {
        private final SQLSubObject sub;

        public SQLSubObjectBuilder(String name, String dataType) {
            this.sub = new SQLSubObject(name, dataType);
        }

        public SQLSubObject build() {
            return this.sub;
        }
    }
}

