/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.siggemannen.core.ListUtils;
import java.util.function.Predicate;

public class SQLObjectFilter
implements Predicate<SQLObject> {
    private boolean tables;
    private boolean tFunctions;
    private boolean procedures;
    private boolean views;
    private boolean functions;
    private boolean databases;

    private SQLObjectFilter() {
    }

    @Override
    public boolean test(SQLObject t) {
        SQLObjectType type = t.getSQLType();
        if (this.tables) {
            return SQLObjectType.TABLE.equals((Object)type);
        }
        if (this.tFunctions) {
            return ListUtils.in((Object)((Object)type), (Object[])new SQLObjectType[]{SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.TABLE_FUNCTION});
        }
        if (this.procedures) {
            return SQLObjectType.STORED_PROCEDURE.equals((Object)type);
        }
        if (this.views) {
            return SQLObjectType.VIEW.equals((Object)type);
        }
        if (this.functions) {
            return SQLObjectType.SCALAR_FUNCTION.equals((Object)type);
        }
        if (this.databases) {
            return SQLObjectType.DATABASE.equals((Object)type);
        }
        return false;
    }

    public static SQLObjectFilter ofTables() {
        SQLObjectFilter f = new SQLObjectFilter();
        f.tables = true;
        return f;
    }

    public static SQLObjectFilter ofProcedures() {
        SQLObjectFilter f = new SQLObjectFilter();
        f.procedures = true;
        return f;
    }

    public static SQLObjectFilter ofTableFunctions() {
        SQLObjectFilter f = new SQLObjectFilter();
        f.tFunctions = true;
        return f;
    }

    public static SQLObjectFilter ofScalarFunctions() {
        SQLObjectFilter f = new SQLObjectFilter();
        f.functions = true;
        return f;
    }

    public static SQLObjectFilter ofViews() {
        SQLObjectFilter f = new SQLObjectFilter();
        f.views = true;
        return f;
    }

    public static SQLObjectFilter ofDatabases() {
        SQLObjectFilter f = new SQLObjectFilter();
        f.databases = true;
        return f;
    }

    public static SQLObjectFilter create(Predicate<SQLObject> f) {
        return new Filter2(f);
    }

    /* synthetic */ SQLObjectFilter(SQLObjectFilter sQLObjectFilter) {
        this();
    }

    private static class Filter2
    extends SQLObjectFilter {
        private final Predicate predicate;

        Filter2(Predicate<SQLObject> f) {
            super(null);
            this.predicate = f;
        }

        @Override
        public boolean test(SQLObject t) {
            return this.predicate.test(t);
        }
    }
}

