/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.BasicSQLCompletion;
import com.sigge.filerunner.completion.domain.FunctionDocX;
import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.ISQLCompletion;
import com.sigge.filerunner.completion.domain.SQLObject;
import javax.swing.Icon;
import org.fife.ui.autocomplete.CompletionProvider;

public class SQLCompletion
extends BasicSQLCompletion
implements ISQLCompletion {
    protected final SQLObject object;
    protected final boolean appendSchema;
    protected final ISQLColumn subobject;
    private String longDesc;

    public SQLCompletion(CompletionProvider provider, SQLObject object, Icon icon, int relevance, boolean appendSchema) {
        this(provider, object, null, icon, relevance, appendSchema);
    }

    public SQLCompletion(CompletionProvider provider, SQLObject object, ISQLColumn subobject, Icon icon, int relevance, boolean appendSchema) {
        this(provider, object, subobject, icon, relevance, appendSchema, null);
    }

    public SQLCompletion(CompletionProvider provider, SQLObject object, ISQLColumn subobject, Icon icon, int relevance, boolean appendSchema, String shortDesc) {
        super(provider, subobject != null ? object.getContext().getQuotedIdentifier(subobject.getName()) : object.getName());
        FunctionDocX doc;
        this.object = new SQLObject(object);
        this.subobject = subobject;
        this.appendSchema = appendSchema;
        this.setIcon(icon);
        this.setRelevance(relevance);
        this.setShortDescription(shortDesc);
        if (object.getCustomProperties() != null && (doc = (FunctionDocX)object.getCustomProperties().get("doc")) != null) {
            this.longDesc = doc.getDescription();
        }
    }

    @Override
    public SQLObject getObject() {
        return this.object;
    }

    @Override
    public boolean appendSchema() {
        return this.appendSchema;
    }

    public String getSummary() {
        String summary = super.getSummary();
        return (this.longDesc != null ? this.longDesc.replace("\n", "<br>") + "<br><br>" : "") + (summary != null ? summary : "");
    }

    public String getReplacementText() {
        String s = super.getReplacementText();
        if (this.appendSchema) {
            return this.object.getSchemaName() + "." + s;
        }
        return s;
    }

    @Override
    public ISQLColumn getSubObject() {
        return this.subobject;
    }
}

