/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.completion.FinishedWalkingException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

public class TokenFinder
implements ParseTreeListener {
    private final int position;
    private final int end;
    private TerminalNode node;
    private ParserRuleContext rule;
    private ParserRuleContext lastRule;
    private TerminalNode lastNode;

    public TokenFinder(int position) {
        this(position, position);
    }

    public TokenFinder(int start, int end) {
        this.position = start;
        this.end = end;
    }

    public void visitTerminal(TerminalNode node) {
        Token symbol = node.getSymbol();
        if (this.within(symbol)) {
            this.node = node;
            throw new FinishedWalkingException();
        }
        if (this.position > symbol.getStartIndex()) {
            this.lastRule = this.rule;
            this.lastNode = node;
        } else if (this.position < symbol.getStartIndex()) {
            this.rule = null;
            throw new FinishedWalkingException();
        }
    }

    private boolean within(Token t) {
        return this.position >= t.getStartIndex() && this.position <= t.getStopIndex() || this.end >= t.getStartIndex() && this.end <= t.getStopIndex();
    }

    public void visitErrorNode(ErrorNode node) {
        Token symbol = node.getSymbol();
        if (this.within(symbol)) {
            this.node = node;
            throw new FinishedWalkingException();
        }
        if (this.position > symbol.getStartIndex()) {
            this.lastRule = this.rule;
            this.lastNode = node;
        } else if (this.position < symbol.getStartIndex()) {
            this.rule = null;
            throw new FinishedWalkingException();
        }
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        this.rule = ctx;
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        this.rule = null;
    }

    public ParserRuleContext getRule() {
        return this.rule;
    }

    public ParserRuleContext getLastRule() {
        return this.lastRule;
    }

    public TerminalNode getNode() {
        return this.node;
    }

    public TerminalNode getLastNode() {
        return this.lastNode;
    }

    public int getPosition() {
        return this.position;
    }
}

