/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.ICompletionListener;
import com.sigge.filerunner.completion.domain.BasicSQLCompletion;
import com.sigge.filerunner.completion.domain.ISQLCompletion;
import com.sigge.filerunner.completion.domain.SQLObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public class SQLAutoCompletion
extends AutoCompletion {
    List<ICompletionListener> listeners = new ArrayList<ICompletionListener>();

    public SQLAutoCompletion(DBCompletion provider) {
        super((CompletionProvider)provider);
    }

    protected void insertCompletion(Completion c, boolean typedParamListStartChar) {
        super.insertCompletion(c, typedParamListStartChar);
        if (c instanceof BasicSQLCompletion || c instanceof ISQLCompletion) {
            int i = this.listeners.size() - 1;
            while (i >= 0) {
                if (c instanceof ISQLCompletion) {
                    ISQLCompletion cc = (ISQLCompletion)c;
                    SQLObject obj = cc.getObject();
                    this.listeners.get(i).completionPerformed(obj, Optional.ofNullable(cc.getSubObject()), ((DBCompletion)this.getCompletionProvider()).getSqlManager().getCurrentContext());
                } else {
                    this.listeners.get(i).completionPerformed((BasicSQLCompletion)c, ((DBCompletion)this.getCompletionProvider()).getSqlManager().getCurrentContext());
                }
                --i;
            }
        }
    }

    public void addCompletionListener(ICompletionListener listener) {
        this.listeners.add(listener);
    }

    public void removeCompletionListener(ICompletionListener listener) {
        this.listeners.remove(listener);
    }

    public void uninstall() {
        super.uninstall();
        this.listeners.clear();
    }
}

