/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.commands.AdvanceEditorCommands;
import com.sigge.filerunner.commands.NextOccurancesAction;
import com.sigge.filerunner.commands.PreviousOccurancesAction;
import com.sigge.filerunner.completion.ADBCompletionProvider;
import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.FinishedWalkingException;
import com.sigge.filerunner.completion.ICompletionListener;
import com.sigge.filerunner.completion.ITokenProvider;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.completion.domain.BasicSQLCompletion;
import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.FunctionArgs;
import com.sigge.filerunner.completion.domain.FunctionDocX;
import com.sigge.filerunner.completion.domain.ISQLColumn;
import com.sigge.filerunner.completion.domain.ISQLCompletion;
import com.sigge.filerunner.completion.domain.IUsageObject;
import com.sigge.filerunner.completion.domain.IWeightedCompletion;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectFilter;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.completion.domain.TextToken;
import com.sigge.filerunner.completion.domain.Usage;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.edit.HolderState;
import com.sigge.filerunner.sql.edit.IEditor;
import com.sigge.filerunner.sql.edit.IParseResult;
import com.sigge.filerunner.sql.sqlserver.CaretPosition;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.ColumnFrom;
import com.sigge.filerunner.sql.sqlserver.SQLServerSQLService;
import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.ClauseHolder;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.declare.DeclareType;
import com.sigge.filerunner.sql.transform.dml.Execute;
import com.sigge.filerunner.sql.transform.dml.InsertQuery;
import com.sigge.filerunner.sql.transform.dml.InsertTarget;
import com.sigge.filerunner.sql.transform.dml.SelectColumn;
import com.sigge.filerunner.sql.transform.dml.SelectQuery;
import com.sigge.filerunner.sql.transform.dml.SelectStatementVisitor;
import com.sigge.filerunner.sql.transform.dml.UpdateQuery;
import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.ColumnNameExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.FullExpression;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.expression.scalars.FunctionCall;
import com.sigge.filerunner.sql.transform.parameter.ParameterBlock;
import com.sigge.filerunner.sql.transform.select.source.DerivedTable;
import com.sigge.filerunner.sql.transform.select.source.Table;
import com.sigge.filerunner.sql.transform.select.source.TableVariable;
import com.sigge.filerunner.sql.transform.select.source.join.Apply;
import com.sigge.filerunner.sql.transform.select.source.join.BaseJoin;
import com.sigge.filerunner.sql.transform.select.source.join.CrossJoin;
import com.sigge.filerunner.sql.transform.select.source.join.MergeJoin;
import com.sigge.filerunner.sql.transform.select.source.join.OldStyleJoin;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupAction;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.PopupAction;
import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TSQLLexer;
import com.sigge.parsql.sql.transform.TokenType;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.ThreadUtils;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.sql.antler.TSqlParser;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionCellRenderer;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCompletion
extends ADBCompletionProvider
implements ITokenProvider,
ToolTipSupplier,
IPopupHandler,
Closeable,
ICompletionListener {
    private static final long SECOND = 60000L;
    private static final ImageIcon CTE_ICON = IconUtils.getSmallIcon("cte.png");
    private static final SQLObjectType[] DEFAULT_TABLE_SOURCES = new SQLObjectType[]{SQLObjectType.TABLE, SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.TABLE_FUNCTION, SQLObjectType.VIEW};
    private JTextComponent textArea;
    private final SQLManager sqlManager;
    private volatile boolean needReScan;
    private final Map<Integer, Tuple<Integer, Integer>> tokenMap = new HashMap<Integer, Tuple<Integer, Integer>>();
    private SQLFile parseTree;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBCompletion.class);
    private final IPopupHandler popupHandler;
    private final Set<ADBCompletionProvider.Wrapee> wrappies = new HashSet<ADBCompletionProvider.Wrapee>();
    private final IEditor parser;
    boolean isProd = this.getClass().getPackage().getImplementationVersion() != null;

    public DBCompletion(RSyntaxTextArea jtc, CompletionProvider templateProvider, SQLManager sqlManager, IPopupHandler popupHandler, IEditor parser) {
        this.popupHandler = popupHandler;
        this.parser = parser;
        this.setParameterizedCompletionParams('(', ", ", ')');
        this.sqlManager = sqlManager;
        this.setAutoActivationRules(true, "@#. _1234567890");
        this.textArea = jtc;
        jtc.setToolTipSupplier((ToolTipSupplier)this);
        this.setParent(templateProvider);
        this.setListCellRenderer((ListCellRenderer)new CompletionCellRenderer());
        TokenReScanner tokenReScanner = new TokenReScanner();
        jtc.getDocument().addDocumentListener((DocumentListener)((Object)tokenReScanner));
        tokenReScanner.setValueFromDocument(null);
    }

    private Map<Integer, Tuple<Integer, Integer>> generateTokenMap(List<ISQLToken> tokens, int line) {
        Element x = this.textArea.getDocument().getDefaultRootElement();
        int end = 0;
        int startToken = 0;
        int currToken = 0;
        int loopcount = 0;
        int loopcount2 = 0;
        block0: for (int i = 0; i < Math.min(line + 1, x.getElementCount()); ++i) {
            ++loopcount2;
            Element e = x.getElement(i);
            end = e.getEndOffset() - 1;
            startToken = currToken;
            for (int j = currToken; j < tokens.size(); ++j) {
                ++loopcount;
                ISQLToken t = tokens.get(j);
                if (t.getEnd() <= end) {
                    if (j != tokens.size() - 1) continue;
                    this.tokenMap.put(i, (Tuple<Integer, Integer>)new Tuple((Object)startToken, (Object)j));
                    continue;
                }
                if (t.getStart() > end) {
                    this.tokenMap.put(i, (Tuple<Integer, Integer>)new Tuple((Object)startToken, (Object)(j - 1)));
                    currToken = j;
                    continue block0;
                }
                this.tokenMap.put(i, (Tuple<Integer, Integer>)new Tuple((Object)startToken, (Object)j));
                currToken = j;
                continue block0;
            }
        }
        return this.tokenMap;
    }

    protected void logDebug(String message, Object ... args) {
        if (this.isProd) {
            return;
        }
        LOGGER.debug(message, args);
    }

    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        TextPaneUtil.fixDotAndMarks((RTextArea)comp);
        String text = this.getAlreadyEnteredText(comp);
        ArrayList<Completion> retVal = new ArrayList<Completion>();
        try {
            retVal.addAll(this.getMatchingCompletions((RSyntaxTextArea)comp, text, this.completions));
        }
        catch (Exception e) {
            LOGGER.error("Error while building completion tree", (Throwable)e);
        }
        return retVal;
    }

    List<Completion> getMatchingCompletions(RSyntaxTextArea rsta, String alreadyEnteredText, List<Completion> compl) {
        String[] parts;
        Tuple<SelectColumnsHolder, HolderState> ss;
        SelectColumnsHolder cols;
        InsertTarget it;
        InsertQuery insert;
        Clause ix;
        boolean inCommaList;
        ArrayList<Completion> retVal = new ArrayList<Completion>();
        retVal.addAll(compl);
        if (alreadyEnteredText == null || this.isOnCommentedLine(rsta) || this.isOnString(rsta)) {
            return retVal;
        }
        String pattY = FilterHelper.getRegexFromString2(alreadyEnteredText);
        SQLServerSQLService sc = new SQLServerSQLService();
        int caretpos = rsta.getCaretPosition();
        Tuple<TextToken, TextToken> tt = this.getPreviousToken(rsta);
        TextToken t = (TextToken)tt.first();
        TextToken curr = (TextToken)tt.second();
        String schema = this.sqlManager.getMaybeSchema(curr != null ? curr.getText() : null);
        Tuple<ParserRuleContext, String> tokenIzer = this.getTokenAtCursor(rsta);
        List<SQLObject> declareObjects = this.getDeclaredObjects(caretpos);
        List<SQLObject> declareTables = declareObjects.stream().filter(CompletionUtils.SELECTABLE_PREDICATE).collect(Collectors.toList());
        boolean inFromContext = false;
        boolean bl = inCommaList = tokenIzer != null && !this.needReScan && ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 535) && (",".equals(tokenIzer.second()) || ".".equals(tokenIzer.second()));
        if (tokenIzer != null && CompletionUtils.isInExpression((ParserRuleContext)tokenIzer.first(), 632, 631) || t != null && CompletionUtils.tokenMatches(t, "FROM", "DELETE", "JOIN", "APPLY", "INTO")) {
            String dbFromToken = null;
            if (tokenIzer != null) {
                SQLObjectType[] sQLObjectTypeArray;
                boolean fromRule = CompletionUtils.isInExpression((ParserRuleContext)tokenIzer.first(), 540);
                dbFromToken = this.sqlManager.parseEntity((String)tokenIzer.second()).map(EntityName::getDatabase).orElse(null);
                if (alreadyEnteredText.length() == 0) {
                    retVal.add(this.createCompletionFromString("("));
                }
                String string = (String)tokenIzer.second();
                if (fromRule) {
                    sQLObjectTypeArray = DEFAULT_TABLE_SOURCES;
                } else {
                    SQLObjectType[] sQLObjectTypeArray2 = new SQLObjectType[1];
                    sQLObjectTypeArray = sQLObjectTypeArray2;
                    sQLObjectTypeArray2[0] = SQLObjectType.TABLE;
                }
                retVal.addAll(this.sqlManager.getByNamePattern(string, sQLObjectTypeArray).stream().filter(f -> fromRule || !f.isSystemObject()).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, this.sqlManager.getCurrentContext().needsSchema((SQLObject)l) && !StringUtils.isEmpty(l.getSchemaName()) && !((String)tokenIzer.second()).toUpperCase().contains(l.getSchemaName().toUpperCase())), l.getName(), (String)tokenIzer.second())).collect(Collectors.toList()));
            } else {
                String s = schema;
                Predicate<SQLObject> ff = CompletionUtils.SELECTABLE_PREDICATE;
                if (s.length() > 0) {
                    ff = CompletionUtils.SELECTABLE_PREDICATE.and(o -> o.getSchemaName().equalsIgnoreCase(s));
                }
                retVal.addAll(this.sqlManager.getByFilter(ff, s.length() == 0 ? alreadyEnteredText : alreadyEnteredText.replace(s + ".", "")).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, s.length() == 0 && this.sqlManager.needsSchema((SQLObject)l) && !StringUtils.isEmpty(l.getSchemaName())), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
            }
            if (schema.length() == 0 && (dbFromToken == null || dbFromToken.length() == 0)) {
                SQLObjectFilter f2 = SQLObjectFilter.ofDatabases();
                retVal.addAll(this.sqlManager.getByFilter(f2, alreadyEnteredText).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, false), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
            }
            retVal.addAll(declareTables.stream().filter(vv -> alreadyEnteredText.length() == 0 || alreadyEnteredText.length() <= vv.getName().length() && vv.getName().substring(0, alreadyEnteredText.length()).equalsIgnoreCase(alreadyEnteredText) || alreadyEnteredText.length() > 0 && vv.getName().matches(pattY)).filter(vv -> this.sqlManager.getByName(vv.getFullName(), vv.getSQLType()).size() == 0).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, false), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
            inFromContext = true;
        } else if (t != null && t.getText().equalsIgnoreCase("EXEC") | t.getText().equalsIgnoreCase("EXECUTE") | (tokenIzer != null && ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 427) && ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 636))) {
            ArrayList<SQLObject> procs = new ArrayList<SQLObject>();
            if (tokenIzer != null) {
                procs.addAll(this.sqlManager.getByNamePattern((String)tokenIzer.second(), SQLObjectType.STORED_PROCEDURE));
                retVal.addAll(procs.stream().map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, this.sqlManager.getCurrentContext().needsSchema((SQLObject)l) && !StringUtils.isEmpty(l.getSchemaName()) && !((String)tokenIzer.second()).toUpperCase().contains(l.getSchemaName().toUpperCase())), l.getName(), (String)tokenIzer.second())).collect(Collectors.toList()));
            } else {
                Predicate<SQLObject> f3 = SQLObjectFilter.ofProcedures();
                String s = schema;
                if (s.length() > 0) {
                    f3 = f3.and(o -> o.getSchemaName().equalsIgnoreCase(s));
                }
                procs.addAll(this.sqlManager.getByFilter(f3, alreadyEnteredText).collect(Collectors.toList()));
                retVal.addAll(procs.stream().map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, false), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
            }
            if (this.sqlManager.getCurrentContext() != null) {
                retVal.addAll(declareObjects.stream().filter(vv -> vv.ofType(SQLObjectType.STORED_PROCEDURE)).filter(vv -> alreadyEnteredText.length() == 0 || alreadyEnteredText.length() <= vv.getName().length() && vv.getName().substring(0, alreadyEnteredText.length()).equalsIgnoreCase(alreadyEnteredText) || alreadyEnteredText.length() > 0 && vv.getName().matches(pattY)).filter(vv -> !procs.stream().anyMatch(am -> this.sqlManager.getCurrentContext().isSameIdentifier(vv.getFullName(), (SQLObject)am))).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, false), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
                inFromContext = true;
            }
        } else if (t != null && t.getText().equalsIgnoreCase("USE")) {
            SQLObjectFilter f4 = SQLObjectFilter.ofDatabases();
            retVal.addAll(this.sqlManager.getByFilter(f4, alreadyEnteredText).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, false), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
        } else if ((alreadyEnteredText.length() > 0 || curr != null) && tokenIzer != null && ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 538, 4)) {
            Predicate<SQLObject> finalPredicate = obj -> obj.ofType(SQLObjectType.SCALAR_FUNCTION);
            Predicate<SQLObject> f2 = obj -> obj.ofType(SQLObjectType.SCALAR_FUNCTION);
            boolean filter = true;
            String s = schema;
            if (schema.length() > 0) {
                finalPredicate = finalPredicate.and(o -> o.getSchemaName().equalsIgnoreCase(s));
                finalPredicate = f2;
            } else if (tokenIzer != null && tokenIzer.first() instanceof TSqlParser.Full_column_nameContext && ((TSqlParser.Full_column_nameContext)tokenIzer.first()).tablename != null) {
                filter = false;
            }
            if (filter) {
                retVal.addAll(this.sqlManager.getByFilter(finalPredicate, alreadyEnteredText).map(l -> this.weight(this.createCompletionFromSQLObject((SQLObject)l, s.length() == 0 && this.sqlManager.needsSchema((SQLObject)l)), l.getName(), alreadyEnteredText)).collect(Collectors.toList()));
            }
            if (alreadyEnteredText.length() > 0) {
                retVal.addAll(this.wrappies.stream().filter(w -> w.getLowercase().startsWith(alreadyEnteredText.toLowerCase()) && !w.getLowercase().equalsIgnoreCase(alreadyEnteredText)).map(w -> this.weight(this.createCompletionFromString(w.getOriginal()), w.getLowercase(), alreadyEnteredText)).collect(Collectors.toList()));
            }
        } else {
            this.logDebug("Missed all suggested places", new Object[0]);
        }
        if (this.parseTree == null) {
            return retVal;
        }
        if (alreadyEnteredText.startsWith("@") && !inFromContext) {
            SQLServerSQLService.getDeclaredVariables(this.parseTree, caretpos).stream().filter(f -> f.type != null && f.declareType != DeclareType.TABLE && f.getVariable().toLowerCase().matches(pattY)).map(this::createCompletionFromVariable).forEach(retVal::add);
        }
        if ((ix = ClauseUtility.findNearestStatement(new CaretPosition((RTextArea)rsta).getIndex(), this.parseTree)) instanceof InsertQuery && (insert = (InsertQuery)ix).getTarget() != null && insert.getInsertListContext() != null && ((it = insert.getTarget()).getTable() != null || it.getTableVariable() != null)) {
            String name = it.getTable() != null ? (it.getTable().fullName() != null ? it.getTable().fullName() : it.getTable().getName()) : it.getTableVariable().getTerminal();
            if (insert.getInsertListContext().start.getStartIndex() <= caretpos && (insert.getInsertListContext().stop == null || insert.getInsertListContext().stop.getStopIndex() + 1 >= caretpos || insert.getInsertListContext().stop.getStopIndex() == insert.getInsertListContext().start.getStartIndex())) {
                List<SQLObject> s = this.getObjectFromName(name, declareTables, new SQLObjectType[0]);
                String columnMass = "";
                String columnx = null;
                int idx = retVal.size() - 1;
                HashSet<String> normalizedIdents = new HashSet<String>();
                for (SQLObject so : s) {
                    for (ISQLColumn col2 : so.getColumns()) {
                        if (col2.isAutoIncrement() || normalizedIdents.contains(col2.getName().toLowerCase()) || alreadyEnteredText.length() != 0 && !col2.getName().toLowerCase().contains(alreadyEnteredText.toLowerCase()) || insert.getColumnList().stream().anyMatch(n -> n.getName() != null && this.sqlManager.getCurrentContext().getNormalizedIdentifier(n.getName()).equalsIgnoreCase(col2.getName()))) continue;
                        normalizedIdents.add(col2.getName().toLowerCase());
                        retVal.add(this.createCompletionFromColumn(so, col2));
                        if (columnx == null) {
                            columnx = this.sqlManager.getCurrentContext().getQuotedIdentifier(col2.getName());
                        }
                        if (columnMass.length() > 0) {
                            columnMass = columnMass + ", ";
                        }
                        columnMass = columnMass + this.sqlManager.getCurrentContext().getQuotedIdentifier(col2.getName());
                    }
                }
                if (columnMass.length() > 0 && !columnMass.equalsIgnoreCase(columnx)) {
                    IWeightedCompletion createCompletionFromColumn = this.createCompletionFromColumn(columnMass);
                    createCompletionFromColumn.setWeight(1);
                    createCompletionFromColumn.setRelevance(2);
                    retVal.add(idx >= 0 ? idx : 0, createCompletionFromColumn);
                }
            }
        }
        if ((cols = sc.getHolderAtPosition(this.parseTree, caretpos)) == null) {
            return retVal;
        }
        Tuple<SelectColumnsHolder, HolderState> tp = this.getHolderAtCaret(cols, caretpos);
        SelectColumnsHolder cols2 = (SelectColumnsHolder)tp.first();
        List<SelectColumnsHolder> froms = new ArrayList<SelectColumnsHolder>();
        this.getColumnsX(cols2, froms, (HolderState)((Object)tp.second()));
        if (froms.size() == 0) {
            froms = cols.getFroms();
        }
        if (inFromContext) {
            List collect = froms.stream().filter(SelectColumnsHolder::isCTE).map(m -> Tuple.of((Object)m, (Object)this.aliasOrName((SelectColumnsHolder)m))).filter(q -> q != null && q.second() != null && (alreadyEnteredText.length() == 0 || ((String)q.second()).toLowerCase().startsWith(alreadyEnteredText.toLowerCase()))).map(q -> new BasicSQLCompletion((CompletionProvider)this, (String)q.second(), CTE_ICON, ((SelectColumnsHolder)q.first()).getFullName() != null && !((SelectColumnsHolder)q.first()).getFullName().equalsIgnoreCase((String)q.second()) ? " (" + ((SelectColumnsHolder)q.first()).getFullName() + ")" : null, "", 3)).collect(Collectors.toList());
            retVal.addAll(collect);
            return retVal;
        }
        if (tokenIzer != null) {
            ParserRuleContext zz = (ParserRuleContext)tokenIzer.first();
            SelectColumnsHolder prev = null;
            boolean firstrun = true;
            while (true) {
                boolean rulePartOfRule;
                this.logDebug("Looping holders {}", zz);
                zz = ClauseUtility.getRulePartOfRule(zz, 285);
                if (zz == null || !(rulePartOfRule = ClauseUtility.isRulePartOfRule(zz, 17, 4)) && (!firstrun || !inCommaList)) break;
                Optional<SelectColumnsHolder> holderInner = sc.createHolder((SelectQuery)new SelectStatementVisitor().visit((ParseTree)zz));
                if (holderInner.isPresent()) {
                    SelectColumnsHolder h = holderInner.get();
                    if (prev != null) {
                        h.addFrom(prev);
                    }
                    prev = h;
                    ss = this.getHolderAtCaret(h, caretpos);
                    ArrayList<SelectColumnsHolder> fromsInner = new ArrayList<SelectColumnsHolder>();
                    this.getColumnsX((SelectColumnsHolder)ss.first(), fromsInner, (HolderState)((Object)tp.second()));
                    froms.addAll(fromsInner);
                }
                zz = zz.getParent();
                firstrun = false;
            }
            if (prev != null) {
                cols2.addFrom(prev);
            }
        }
        String aliasOrTableName = "";
        String startedText = "";
        boolean matchcols = false;
        if (curr != null && curr.getText().endsWith(".")) {
            parts = curr.getText().split("\\.");
            aliasOrTableName = parts.length > 0 ? parts[parts.length - 1].trim() : "";
        } else if (curr != null && curr.getText().contains(".")) {
            parts = curr.getText().split("\\.");
            aliasOrTableName = parts[parts.length - 2].trim();
            startedText = parts[parts.length - 1].trim();
        } else if (t != null && t.getText().endsWith(".")) {
            parts = t.getText().split("\\.");
            aliasOrTableName = parts.length > 0 ? parts[parts.length - 1].trim() : "";
        } else if (alreadyEnteredText.length() > 0) {
            matchcols = true;
            aliasOrTableName = alreadyEnteredText;
        }
        boolean updateLeftValue = false;
        if (ix instanceof UpdateQuery && tokenIzer != null) {
            UpdateQuery update = (UpdateQuery)ix;
            if (ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 7)) {
                updateLeftValue = true;
                String ff2 = null;
                if (update.getUpdateTarget() != null) {
                    ss = update.getUpdateTarget().getTable();
                    ff2 = ss != null ? ss.fullName() : update.getUpdateTarget().getTableVariable().getTerminal();
                }
                if (ff2 == null) {
                    ff2 = "";
                }
                this.addCompletionsFromAliasAndTable(retVal, declareTables, froms, alreadyEnteredText, ff2);
            }
        }
        boolean caretInSelectList = cols.getSelectListFrom() <= caretpos && cols.getSelectListTo() >= caretpos;
        boolean caretInWhereList = cols.getWhereListFrom() <= caretpos && cols.getWhereListTo() >= caretpos;
        boolean caretInHavingList = cols.getHavingListFrom() <= caretpos && cols.getHavingListTo() >= caretpos;
        boolean inExpression2 = tokenIzer != null && !this.needReScan && ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 4);
        boolean where2 = tokenIzer != null && !this.needReScan && ClauseUtility.isRulePartOfRule((ParserRuleContext)tokenIzer.first(), 11);
        this.logDebug("matchcols: {}, update: {}, caretInSelectList: {}, caretInWhereList: {}, caretInHavingList: {}, inExpression2: {}, where 2: {}\r\n,inCommaList: {}", matchcols, updateLeftValue, caretInSelectList, caretInWhereList, caretInHavingList, inExpression2, where2, inCommaList);
        if (!updateLeftValue) {
            if (matchcols) {
                boolean inExpression;
                boolean bl2 = inExpression = !this.needReScan && tokenIzer != null && CompletionUtils.isInExpression((ParserRuleContext)tokenIzer.first(), 4);
                if (caretInSelectList || caretInWhereList || caretInHavingList || caretpos >= CompletionUtils.getContextEndIndex(cols.getContext(), Integer.MAX_VALUE) && inExpression || inExpression2) {
                    LOGGER.debug("Matching alias or column");
                    String aliasOrTableOrColumn = aliasOrTableName;
                    retVal.addAll(froms.stream().filter(Objects::nonNull).map(m -> Tuple.of((Object)m, (Object)this.aliasOrName((SelectColumnsHolder)m))).filter(q -> q != null && q.second() != null && ((String)q.second()).toLowerCase().startsWith(aliasOrTableOrColumn.toLowerCase())).map(q -> this.relevance(new BasicSQLCompletion((CompletionProvider)this, aliasOrTableOrColumn.length() > 0 ? (String)q.second() : (((SelectColumnsHolder)q.first()).getAlias() != null && ((SelectColumnsHolder)q.first()).getAlias().length() > 0 ? ((SelectColumnsHolder)q.first()).getAlias() + "." + (String)q.second() : (String)q.second()), null, ((SelectColumnsHolder)q.first()).getFullName() != null && !((SelectColumnsHolder)q.first()).getFullName().equalsIgnoreCase((String)q.second()) ? " (" + ((SelectColumnsHolder)q.first()).getFullName() + ")" : null, "", 3), (SelectColumnsHolder)q.first())).collect(Collectors.toList()));
                    ArrayList objs = new ArrayList();
                    froms.stream().filter(a -> a.getFullName() != null).forEach(a -> objs.addAll(this.getObjectFromName(a.getFullName(), declareTables, new SQLObjectType[0])));
                    HashSet<String> colsCompleted = new HashSet<String>();
                    String patt = FilterHelper.getRegexFromString2(aliasOrTableName);
                    for (SQLObject obj2 : objs) {
                        for (ISQLColumn sub : obj2.getColumns()) {
                            if (aliasOrTableName.length() != 0 && (sub.getName().length() <= 1 || !sub.getName().matches(patt))) continue;
                            IWeightedCompletion cc = this.createCompletionFromColumn(obj2, sub);
                            if (aliasOrTableName.length() > 0) {
                                this.weight(cc, sub.getName(), aliasOrTableName);
                            }
                            if (this.isColumnPartOfPK(obj2, sub)) {
                                ((BasicCompletion)cc).setIcon((Icon)CompletionUtils.KEY_ICON);
                            }
                            retVal.add(cc);
                            colsCompleted.add(sub.getName().toLowerCase());
                        }
                    }
                    retVal.addAll(froms.stream().map(from -> this.getColumns((SelectColumnsHolder)from, declareTables)).flatMap(Collection::stream).map(this.sqlManager.getCurrentContext()::getNormalizedIdentifier).filter(col -> aliasOrTableOrColumn.length() == 0 || col.toLowerCase().startsWith(aliasOrTableOrColumn.toLowerCase()) && col.length() > 1 && !aliasOrTableOrColumn.equalsIgnoreCase((String)col)).filter(col -> !colsCompleted.contains(col.toLowerCase())).distinct().map(this::createCompletionFromColumn).collect(Collectors.toList()));
                }
            } else if (aliasOrTableName.length() == 0) {
                if (!inCommaList && (caretInSelectList || caretInWhereList || caretInHavingList || inExpression2)) {
                    LOGGER.debug("suggest alias");
                    retVal.addAll(froms.stream().filter(m -> this.aliasOrName((SelectColumnsHolder)m) != null).map(m -> Tuple.of((Object)m, (Object)this.aliasOrName((SelectColumnsHolder)m))).map(q -> new BasicSQLCompletion((CompletionProvider)this, (String)q.second(), null, ((SelectColumnsHolder)q.first()).getFullName() != null && !((SelectColumnsHolder)q.first()).getFullName().equalsIgnoreCase((String)q.second()) ? " (" + ((SelectColumnsHolder)q.first()).getFullName() + ")" : null, "", 3)).collect(Collectors.toList()));
                } else {
                    LOGGER.debug("No aliases");
                    if (t != null && t.getToken().in(new TokenType[]{TokenType.BRACES_IDENTIFIER, TokenType.DOUBLE_QUOTE_IDENTIFIER, TokenType.COMMA, TokenType.OPERATOR, TokenType.KEYWORD})) {
                        LOGGER.debug("No aliases #2");
                        retVal.addAll(froms.stream().map(m -> Tuple.of((Object)m, (Object)this.aliasOrName((SelectColumnsHolder)m))).filter(q -> q != null && q.second() != null).map(q -> new BasicSQLCompletion((CompletionProvider)this, (String)q.second(), null, ((SelectColumnsHolder)q.first()).getFullName() != null && !((SelectColumnsHolder)q.first()).getFullName().equalsIgnoreCase((String)q.second()) ? " (" + ((SelectColumnsHolder)q.first()).getFullName() + ")" : null, "", 3)).collect(Collectors.toList()));
                        String patt = FilterHelper.getRegexFromString2(startedText);
                        for (SelectColumnsHolder XX : froms) {
                            for (String sub : this.getColumns(XX, declareTables)) {
                                String normalizedIdentifier = this.sqlManager.getCurrentContext().getNormalizedIdentifier(sub);
                                if (startedText.length() != 0 && (!normalizedIdentifier.matches(patt) || sub.length() <= 1)) continue;
                                IWeightedCompletion createCompletionFromColumn = this.createCompletionFromColumn(this.sqlManager.getCurrentContext().getQuotedIdentifier(normalizedIdentifier), XX.getAlias());
                                this.weight(createCompletionFromColumn, normalizedIdentifier, startedText);
                                retVal.add(createCompletionFromColumn);
                            }
                        }
                    }
                }
            } else {
                LOGGER.debug("Matching table and aliases: {}, froms: {}", (Object)aliasOrTableName, froms);
                this.addCompletionsFromAliasAndTable(retVal, declareTables, froms, startedText, aliasOrTableName);
            }
        }
        return retVal;
    }

    private void addCompletionsFromAliasAndTable(List<Completion> retVal, List<SQLObject> declareTables, List<SelectColumnsHolder> froms, String startedText, String ff) {
        Tuple<String, Boolean> tpName = this.getMatchingNameByAliasOrName(froms, ff);
        String name = (String)tpName.first();
        if (name.length() > 0 || ff.length() == 0) {
            Optional<SelectColumnsHolder> XX;
            this.logDebug("table alias match:{} from alias: {}", name, ff);
            ArrayList<String> colsCompleted = new ArrayList<String>();
            if (((Boolean)tpName.second()).booleanValue() || ff.length() == 0) {
                List<SQLObject> zql = (Boolean)tpName.second() != false ? this.getObjectFromName(name, declareTables, new SQLObjectType[0]) : froms.stream().filter(a -> a.getFullName() != null).map(s -> this.getObjectFromName(s.getFullName(), declareTables, new SQLObjectType[0])).flatMap(f -> f.stream()).collect(Collectors.toList());
                String patt = FilterHelper.getRegexFromString2(startedText);
                for (SQLObject obj : zql) {
                    for (ISQLColumn sub : obj.getColumns()) {
                        String normalizedIdentifier = this.sqlManager.getCurrentContext().getNormalizedIdentifier(sub.getName());
                        if (colsCompleted.contains(normalizedIdentifier.toLowerCase()) || startedText.length() != 0 && (!normalizedIdentifier.matches(patt) || normalizedIdentifier.length() <= 1)) continue;
                        colsCompleted.add(normalizedIdentifier.toLowerCase());
                        IWeightedCompletion createCompletionFromColumn = this.createCompletionFromColumn(obj, sub);
                        if (this.isColumnPartOfPK(obj, sub)) {
                            ((BasicCompletion)createCompletionFromColumn).setIcon((Icon)CompletionUtils.KEY_ICON);
                        }
                        this.weight(createCompletionFromColumn, normalizedIdentifier, startedText);
                        retVal.add(createCompletionFromColumn);
                    }
                }
            }
            if ((XX = froms.stream().filter(a -> this.aliasOrName((SelectColumnsHolder)a) != null && this.sqlManager.getCurrentContext().isSameIdentifier(this.aliasOrName((SelectColumnsHolder)a), ff)).findFirst()).isPresent()) {
                String pattX = FilterHelper.getRegexFromString2(startedText);
                for (String sub : this.getColumns(XX.get(), declareTables)) {
                    String normalizedIdentifier = this.sqlManager.getCurrentContext().getNormalizedIdentifier(sub);
                    if (startedText.length() != 0 && (normalizedIdentifier.length() <= 1 || !normalizedIdentifier.matches(pattX)) || colsCompleted.contains(sub.toLowerCase())) continue;
                    IWeightedCompletion createCompletionFromColumn = this.createCompletionFromColumn(this.sqlManager.getCurrentContext().getQuotedIdentifier(normalizedIdentifier));
                    this.weight(createCompletionFromColumn, normalizedIdentifier, startedText);
                    retVal.add(createCompletionFromColumn);
                    colsCompleted.add(normalizedIdentifier.toLowerCase());
                }
            }
        }
    }

    private List<SQLObject> getDeclaredObjects(int caretpos) {
        SQLServerSQLService sc = new SQLServerSQLService();
        ArrayList<SQLObject> declareobs = this.parseTree != null ? SQLServerSQLService.getDeclaredObjects(this.sqlManager.getCurrentContext(), this.parseTree, caretpos) : new ArrayList<SQLObject>();
        ArrayList<SQLObject> declareTables = this.parseTree != null ? SQLServerSQLService.getDeclaredTables(this.sqlManager.getServerContext(), this.sqlManager.getCurrentContext(), this.parseTree, caretpos) : new ArrayList<SQLObject>();
        for (SQLObject so : declareTables) {
            Optional<SelectColumnsHolder> holdon;
            SelectQuery sq;
            if (so.getColumns().size() != 0 || so.getCustomProperties() == null || (sq = (SelectQuery)so.getCustomProperties().remove("query")) == null || !(holdon = sc.createHolder(sq)).isPresent()) continue;
            for (String sub : this.getColumns(holdon.get(), declareTables)) {
                SQLSubObject subx = new SQLSubObject(this.sqlManager.getCurrentContext().getNormalizedIdentifier(sub), null);
                so.addColumn(subx);
            }
        }
        declareobs.addAll(declareTables);
        return declareobs;
    }

    private Tuple<String, Boolean> getMatchingNameByAliasOrName(List<SelectColumnsHolder> froms, String ff) {
        return froms.stream().filter(a -> this.aliasOrName((SelectColumnsHolder)a) != null && this.aliasOrName((SelectColumnsHolder)a).equalsIgnoreCase(ff)).map(e -> {
            if (e.getFullName() != null) {
                return Tuple.of((Object)e.getFullName(), (Object)true);
            }
            return e.getName() != null ? Tuple.of((Object)e.getName(), (Object)true) : Tuple.of((Object)e.getAlias(), (Object)false);
        }).filter(Objects::nonNull).findFirst().orElse(Tuple.of((Object)"", (Object)false));
    }

    public IWeightedCompletion weight(IWeightedCompletion completion, String name, String filter) {
        String f;
        if (completion instanceof ISQLCompletion) {
            SQLObject obj = ((ISQLCompletion)((Object)completion)).getObject();
            ISQLColumn sub = ((ISQLCompletion)((Object)completion)).getSubObject();
            ServerDatabase sd = this.sqlManager.getCurrent();
            if (obj != null) {
                IUsageObject use = sub != null ? sub : obj;
                use.getUsage().ifPresent(usage -> {
                    int matchingContextUsage = 0;
                    int rel = 0;
                    LocalDateTime tm = LocalDateTime.of(1900, 1, 1, 1, 1);
                    if (usage.getUsageCount() > 0) {
                        for (Usage u : usage.getUsage()) {
                            if (sd.matches(u.getServerId(), u.getDatabase())) {
                                ++matchingContextUsage;
                            }
                            if (!u.getTime().isAfter(tm)) continue;
                            tm = u.getTime();
                        }
                        if (matchingContextUsage > 0) {
                            rel += (int)Math.sqrt(matchingContextUsage);
                        } else if (usage.getUsageCount() > 1) {
                            rel += (int)Math.sqrt(usage.getUsageCount() / 2);
                        }
                        if (!DateUtils.isOlderThan(tm, 86400000L)) {
                            rel += !DateUtils.isOlderThan(tm, 60000L) ? 5 : (!DateUtils.isOlderThan(tm, 600000L) ? 3 : (!DateUtils.isOlderThan(tm, 3600000L) ? 1 : 0));
                        } else if (DateUtils.isOlderThan(tm, 7776000000L)) {
                            rel = rel > 0 ? 1 : 0;
                        } else if (DateUtils.isOlderThan(tm, 2592000000L)) {
                            rel = rel > 10 ? 3 : (rel > 0 ? 1 : 0);
                        }
                        completion.setRelevance(completion.getRelevance() + rel);
                    }
                });
            }
        }
        if (filter.length() == 0) {
            return completion;
        }
        String l = name.toLowerCase();
        if (l.equals(f = filter.toLowerCase())) {
            completion.setRelevance(100);
        } else if (l.startsWith(filter.toLowerCase())) {
            completion.setWeight(50);
        } else if (l.contains(f)) {
            completion.setWeight(15);
        }
        if (filter.length() > 5) {
            completion.setWeight((int)(100.0 * (1.0 / (double)name.length())));
        }
        return completion;
    }

    private void getColumnsX(SelectColumnsHolder h, List<SelectColumnsHolder> cols, HolderState triState) {
        if (h == null) {
            return;
        }
        if (h.getParent() == null && cols.size() == 0) {
            cols.addAll(h.getFroms());
            return;
        }
        if (triState == HolderState.WITHIN && h.getSource() != null && h.getSource().getSource() instanceof DerivedTable) {
            cols.addAll(h.getFroms());
        }
        if (h.getJoin() == null) {
            cols.add(h);
            if (h.getParent() != null && h.getParent().getJoin() instanceof Apply) {
                this.getColumnsX(h.getParent(), cols, HolderState.OUTOFAPPLY);
                return;
            }
        } else {
            if ((h.getJoin() instanceof BaseJoin || h.getJoin() instanceof CrossJoin || h.getJoin() instanceof OldStyleJoin || h.getJoin() instanceof MergeJoin) && h.getParent() != null) {
                if (h.getSource() != null && triState != HolderState.WITHIN) {
                    this.getColumnsX(h.getPrev(), cols, HolderState.BEFORE);
                    cols.add(h);
                }
            } else if (h.getJoin() instanceof Apply && h.getParent() != null) {
                this.getColumnsX(h.getPrev(), cols, HolderState.BEFORE);
                if (triState != HolderState.OUTOFAPPLY) {
                    cols.add(h);
                }
            }
            if (triState == HolderState.WITHIN && h.getSource() != null && h.getSource().getSource() instanceof DerivedTable) {
                if (h.getJoin() instanceof BaseJoin && h.getParent() != null) {
                    this.getColumnsX(h.getParent(), cols, HolderState.BEFORE);
                } else if (h.getJoin() instanceof Apply && h.getParent() != null) {
                    this.getColumnsX(h.getParent(), cols, HolderState.OUTOFAPPLY);
                }
                return;
            }
            if (h.getSource() != null && h.getSource().getSource() instanceof DerivedTable) {
                if (h.getParent() != null && h.getParent().getJoin() instanceof Apply) {
                    this.getColumnsX(h.getParent(), cols, HolderState.BEFORE);
                }
                return;
            }
        }
    }

    private HolderState isHolderBefore(SelectColumnsHolder h, int caret) {
        if (h.getContext() == null || h.getContext().start == null) {
            return HolderState.UNKNOWN;
        }
        if (h.getContext().start.getStartIndex() >= caret) {
            return HolderState.AFTER;
        }
        if (h.getContext().stop == null) {
            return HolderState.BEFORE_UNKNOWN;
        }
        if (h.getContext().stop.getStopIndex() >= caret) {
            return HolderState.WITHIN;
        }
        return HolderState.BEFORE;
    }

    private Tuple<SelectColumnsHolder, HolderState> getHolderAtCaret(SelectColumnsHolder h, int caret) {
        return this.getHolderAtCaret(h, caret, HolderState.UNKNOWN);
    }

    private Tuple<SelectColumnsHolder, HolderState> getHolderAtCaret(SelectColumnsHolder h, int caret, HolderState lastState) {
        SelectColumnsHolder lastHolderThatWasntAhead = null;
        int holderCount = -1;
        block6: for (int i = 0; i < h.getFroms().size(); ++i) {
            SelectColumnsHolder holder = h.getFroms().get(i);
            HolderState state = this.isHolderBefore(holder, caret);
            switch (state) {
                case UNKNOWN: {
                    ++holderCount;
                    continue block6;
                }
                case WITHIN: {
                    lastHolderThatWasntAhead = holder;
                    lastState = HolderState.WITHIN;
                    ++holderCount;
                    continue block6;
                }
                case BEFORE_UNKNOWN: {
                    lastState = HolderState.BEFORE_UNKNOWN;
                    ++holderCount;
                    continue block6;
                }
                case BEFORE: {
                    if (holder.isCTE()) continue block6;
                    lastHolderThatWasntAhead = holder;
                    lastState = HolderState.BEFORE;
                    ++holderCount;
                    continue block6;
                }
            }
        }
        if (lastHolderThatWasntAhead == null) {
            lastHolderThatWasntAhead = h;
        }
        if (lastState == HolderState.BEFORE && holderCount == h.getFroms().size() - 1 && lastHolderThatWasntAhead.getJoin() != null) {
            ParserRuleContext join = (ParserRuleContext)lastHolderThatWasntAhead.getJoin().getTree();
            if (join != null && join.getStop() != null && join.getStop().getStopIndex() < caret) {
                lastHolderThatWasntAhead = h;
            }
            lastState = HolderState.WITHIN;
        }
        if (lastState == HolderState.WITHIN && lastHolderThatWasntAhead.getSource() != null && lastHolderThatWasntAhead.getSource().getSource() instanceof DerivedTable && h != lastHolderThatWasntAhead) {
            return this.getHolderAtCaret(lastHolderThatWasntAhead, caret, lastState);
        }
        return Tuple.of((Object)lastHolderThatWasntAhead, (Object)((Object)lastState));
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getColumns(SelectColumnsHolder x, List<SQLObject> declareTables) {
        String fullname;
        Expression xx;
        ArrayList<String> sc = new ArrayList<String>();
        ArrayList<SelectColumn> colz = new ArrayList<SelectColumn>();
        ArrayList<ColumnFrom> cols = new ArrayList<ColumnFrom>();
        SelectColumnsHolder.getColumns(x, cols);
        for (ColumnFrom cf : cols) {
            colz.add(cf.getColumn());
        }
        for (SelectColumn selectColumn : colz) {
            if (selectColumn.getTableNameOrAlias() != null) {
                Optional<SelectColumnsHolder> hh = this.findHolderFromTableOrAlias(x, selectColumn.getTableNameOrAlias());
                if (selectColumn.isAllStar()) {
                    hh.ifPresent(h -> sc.addAll(this.getColumns((SelectColumnsHolder)h, declareTables)));
                    continue;
                }
                hh.ifPresent(h -> {
                    boolean added = false;
                    for (String co : this.getColumns((SelectColumnsHolder)h, declareTables)) {
                        if (!co.equalsIgnoreCase(selectColumn.getTableNameOrAlias().getName())) continue;
                        sc.add(co);
                        added = true;
                        break;
                    }
                    if (!added) {
                        sc.add(selectColumn.getTableNameOrAlias().getName());
                    }
                });
                continue;
            }
            if (selectColumn.isAllStar()) {
                for (SelectColumnsHolder selectColumnsHolder : x.getFroms()) {
                    sc.addAll(this.getColumns(selectColumnsHolder, declareTables));
                }
                continue;
            }
            if (selectColumn.getColumn() == null) continue;
            if (selectColumn.getAlias() != null) {
                sc.add(selectColumn.getAlias());
                continue;
            }
            Expression sn = selectColumn.getColumn();
            if (sn instanceof FullExpression && ((FullExpression)sn).getFullExpression() instanceof ColumnNameExpression) {
                ColumnNameExpression columnNameExpression = (ColumnNameExpression)((FullExpression)sn).getFullExpression();
                if (columnNameExpression == null) continue;
                sc.add(columnNameExpression.getColumnName() != null ? columnNameExpression.getColumnName().getName() : columnNameExpression.getValue());
                continue;
            }
            if (!(sn instanceof BaseExpression)) continue;
            sc.add(((BaseExpression)sn).getValue());
        }
        if (colz.size() == 0 && x.getSource() != null && (xx = x.getSource().getSource()) != null && (xx instanceof Table || xx instanceof TableVariable || xx instanceof FunctionCall) && (fullname = x.getFullName()) != null) {
            if (xx instanceof Table && !x.isCTE()) {
                void var9_13;
                SelectColumnsHolder selectColumnsHolder;
                Optional<Object> XX = Optional.empty();
                SelectColumnsHolder selectColumnsHolder2 = x;
                while ((selectColumnsHolder = var9_13.getParent()) != null && !(XX = selectColumnsHolder.getFroms().stream().filter(SelectColumnsHolder::isCTE).filter(a -> this.aliasOrName((SelectColumnsHolder)a) != null && this.sqlManager.getCurrentContext().isSameIdentifier(this.aliasOrName((SelectColumnsHolder)a), fullname)).findFirst()).isPresent()) {
                }
                if (XX.isPresent()) {
                    return this.getColumns((SelectColumnsHolder)XX.get(), declareTables);
                }
            }
            List<SQLObject> obj = this.getObjectFromName(fullname, declareTables, new SQLObjectType[0]);
            HashSet<String> hashSet = new HashSet<String>();
            for (SQLObject ob : obj) {
                for (ISQLColumn sox : ob.getColumns()) {
                    if (!hashSet.add(sox.getName().toUpperCase())) continue;
                    sc.add(sox.getName());
                }
            }
        }
        return sc;
    }

    private Optional<SelectColumnsHolder> findHolderFromTableOrAlias(SelectColumnsHolder cols, SQLName alias) {
        return this.findHolderFromTableOrAlias(cols, alias.fullName());
    }

    private Optional<SelectColumnsHolder> findHolderFromTableOrAlias(SelectColumnsHolder cols, String ff) {
        if (ff == null) {
            return Optional.empty();
        }
        return cols.getFroms().stream().filter(a -> this.aliasOrName((SelectColumnsHolder)a) != null && this.sqlManager.getCurrentContext().isSameIdentifier(this.aliasOrName((SelectColumnsHolder)a), ff)).findFirst();
    }

    private List<SQLObject> getTableSourceFromPattern(String tokenIzer) {
        return this.sqlManager.getByNamePattern(tokenIzer, DEFAULT_TABLE_SOURCES);
    }

    private String getSynonymName(SQLObject so) {
        if (so.getCustomProperties() == null) {
            return null;
        }
        return (String)so.getCustomProperties().get("ALIAS_NAME");
    }

    private List<SQLObject> getObjectFromName(String name, List<SQLObject> declareTables, SQLObjectType ... types) {
        if (types.length == 0) {
            types = DEFAULT_TABLE_SOURCES;
        }
        List<SQLObject> ob = this.getTableSourceFromNameInternal(name, declareTables, types);
        for (int i = 0; i < ob.size(); ++i) {
            List<SQLObject> lox;
            String alias;
            SQLObject sox = ob.get(i);
            if (sox.getCustomProperties() == null || (alias = (String)sox.getCustomProperties().get("SYNONYM_NAME")) == null || (lox = this.getTableSourceFromNameInternal(alias, declareTables, types)) == null || lox.size() <= 0) continue;
            SQLObject resolved = new SQLObject(lox.get(0), true);
            if (resolved.getCustomProperties() == null) {
                resolved.setCustomProperties(new HashMap<String, Object>());
            }
            resolved.getCustomProperties().put("ALIAS_NAME", sox.getName());
            ob.set(i, resolved);
        }
        return ob;
    }

    private List<SQLObject> getTableSourceFromNameInternal(String name, List<SQLObject> declareTables, SQLObjectType ... objectTypes) {
        List<SQLObject> la = this.sqlManager.getByName(name, objectTypes);
        for (SQLObject declares : declareTables) {
            if (!this.sqlManager.getCurrentContext().isSameIdentifier(name, declares)) continue;
            la.add(declares);
        }
        return la;
    }

    private String aliasOrName(SelectColumnsHolder holder) {
        if (holder.getAlias() != null && holder.getAlias().length() > 0) {
            return this.sqlManager.getCurrentContext().getNormalizedIdentifier(holder.getAlias());
        }
        if (holder.getName() != null) {
            return holder.getName();
        }
        return null;
    }

    private IWeightedCompletion relevance(IWeightedCompletion completion, SelectColumnsHolder holder) {
        if ((holder.getAlias() == null || holder.getAlias().length() <= 0) && holder.getName() != null) {
            completion.setRelevance(completion.getRelevance() - 2);
        }
        return completion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Tuple<ParserRuleContext, String> getTokenAtCursor(RSyntaxTextArea cp) {
        Clause cx;
        int pos = cp.getCaretPosition();
        try {
            if (cp.getDocument().getText(pos, 1).matches("\\s")) {
                --pos;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        TokenFinder w = new TokenFinder(pos);
        ParseTreeWalker tv = new ParseTreeWalker();
        if (this.parseTree == null) {
            return null;
        }
        if (this.needReScan) {
            // empty if block
        }
        if ((cx = ClauseUtility.findNearestStatement(pos, this.parseTree)) != null) {
            try {
                tv.walk((ParseTreeListener)w, (ParseTree)cx.getContext());
            }
            catch (FinishedWalkingException rx) {
                if (w.getRule() != null) {
                    ParserRuleContext rx2 = w.getRule();
                    String text = w.getNode().getText();
                    if (rx2.getRuleIndex() == 664) {
                        rx2 = rx2.getParent();
                        text = rx2.getText();
                    }
                    return Tuple.of((Object)rx2, (Object)text);
                }
                if (w.getLastNode() != null && (w.getLastNode().getSymbol().getType() == 990 && w.getLastNode().getParent() instanceof TSqlParser.Select_listContext || w.getNode() != null && w.getNode().getParent() instanceof TSqlParser.Unfinished_aliasContext)) {
                    System.out.println("End of the line");
                    return Tuple.of((Object)((ParserRuleContext)w.getLastNode().getParent()), (Object)w.getLastNode().getText());
                }
                if (w.getLastRule() != null && this.needReScan) {
                    ParserRuleContext rx3 = w.getLastRule();
                    String text = w.getLastNode().getText();
                    if (rx3.getRuleIndex() == 664) {
                        rx3 = rx3.getParent();
                        text = rx3.getText();
                    }
                    return Tuple.of((Object)rx3, (Object)text);
                }
            }
            finally {
                if (w.getRule() != null) {
                    ParserRuleContext rx = w.getRule();
                    String text = w.getNode().getText();
                    if (rx.getRuleIndex() == 664) {
                        rx = rx.getParent();
                        text = rx.getText();
                    }
                    return Tuple.of((Object)rx, (Object)text);
                }
                if (w.getLastNode() != null && (w.getLastNode().getSymbol().getType() == 990 && w.getLastNode().getParent() instanceof TSqlParser.Select_listContext || w.getNode() != null && w.getNode().getParent() instanceof TSqlParser.Unfinished_aliasContext)) {
                    System.out.println("End of the line");
                    return Tuple.of((Object)((ParserRuleContext)w.getLastNode().getParent()), (Object)w.getLastNode().getText());
                }
                if (w.getLastRule() != null && this.needReScan) {
                    ParserRuleContext rx = w.getLastRule();
                    String text = w.getLastNode().getText();
                    if (rx.getRuleIndex() == 664) {
                        rx = rx.getParent();
                        text = rx.getText();
                    }
                    return Tuple.of((Object)rx, (Object)text);
                }
            }
        }
        return null;
    }

    protected boolean isValidChar(char ch) {
        return super.isValidChar(ch) || ch == '@' || ch == '#';
    }

    @Override
    public List<ISQLToken> getTokensOnLine(int line) {
        ArrayList<ISQLToken> tokens2 = new ArrayList<ISQLToken>(TSQLLexer.parse((String)this.textArea.getText()));
        Tuple<Integer, Integer> tokenTuple = this.generateTokenMap(tokens2, line).get(line);
        if (tokenTuple == null) {
            throw new IllegalArgumentException(String.format("Line %d outside of tokenmap", line));
        }
        ArrayList<ISQLToken> tokes = new ArrayList<ISQLToken>();
        tokes.addAll(tokens2.subList((Integer)tokenTuple.first(), (Integer)tokenTuple.second() + 1));
        return tokes;
    }

    public SQLFile getParseTree() {
        if (this.needReScan) {
            for (int i = 0; i < 4; ++i) {
                ThreadUtils.sleep((int)50);
                if (!this.needReScan) break;
            }
        }
        return this.parseTree;
    }

    public String getToolTipText(RTextArea textArea, MouseEvent e) {
        if (this.needReScan) {
            return null;
        }
        int pos = textArea.viewToModel(e.getPoint());
        if (this.parseTree != null && this.parseTree.getContext() != null) {
            ParseTree pt;
            Execute exec;
            Expression name;
            Clause cx = ClauseUtility.findNearestStatement(pos, this.parseTree);
            if (cx == null || cx.getContext() == null) {
                return null;
            }
            TokenFinder w = CompletionUtils.getTokenAtPosition(cx.getContext(), pos);
            if (w == null || w.getRule() == null) {
                return null;
            }
            int paramNumber = -1;
            String paramName = null;
            String text = w.getNode().getText();
            ParserRuleContext rx = w.getRule();
            if (cx instanceof Execute && CompletionUtils.isInExpression(rx, 19) && (name = (exec = (Execute)cx).getProcName()) instanceof SQLName && (pt = ((SQLName)name).getTokenSource()) instanceof ParserRuleContext) {
                w = null;
                rx = (ParserRuleContext)pt;
                text = rx.getText();
                Tuple<String, Integer> paramNumberString = SQLServerSQLService.getParameterNumberForExec(exec.getParams(), pos);
                paramName = (String)paramNumberString.first();
                paramNumber = (Integer)paramNumberString.second();
            }
            if (ListUtils.in((Object)rx.getRuleIndex(), (Object[])new Integer[]{661, 454, 455})) {
                return null;
            }
            if (w != null) {
                if (w.getRule().getRuleIndex() == 663 && w.getRule().getParent() != null && w.getRule().getParent().getRuleIndex() == 664) {
                    rx = w.getRule().getParent().getParent();
                    text = rx.getText();
                } else if (w.getRule().getRuleIndex() == 664) {
                    rx = w.getRule().getParent();
                    text = rx.getText();
                }
            }
            if (ListUtils.in((Object)rx.getRuleIndex(), (Object[])new Integer[]{635, 636, 634, 631, 632, 551, 556, 637, 649, 580})) {
                List<SQLObject> v = this.getObjectFromName(text, this.getDeclaredObjects(pos), SQLObjectType.TABLE, SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.STORED_PROCEDURE, SQLObjectType.TABLE_FUNCTION, SQLObjectType.VIEW);
                if (v.size() > 0) {
                    return this.getToolTipForSQLObjects(v, paramName, paramNumber);
                }
            } else if (text != null && text.startsWith("@")) {
                String text2 = text;
                Optional<DeclareBlock> block = SQLServerSQLService.getDeclaredVariables(this.parseTree, pos).stream().filter(f -> f.type != null && f.getVariable().toLowerCase().matches(text2.toLowerCase())).findFirst();
                if (block.isPresent()) {
                    DeclareBlock db = block.get();
                    return "<html>" + (db instanceof ParameterBlock ? "Parameter" : "Variable") + ": <b>" + db.getVariable() + "</b> " + db.type.toUpperCase() + (db.getDefaultValue() != null ? " DEFAULT " + db.getDefaultValue() : "");
                }
                List<SQLObject> v = this.getObjectFromName(text2, Collections.EMPTY_LIST, SQLObjectType.TABLE, SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.STORED_PROCEDURE, SQLObjectType.TABLE_FUNCTION, SQLObjectType.VIEW);
                if (v.size() > 0) {
                    return this.getToolTipForSQLObjects(v, paramName, paramNumber);
                }
            }
            return TSqlParser.ruleNames[rx.getRuleIndex()] + ": " + text;
        }
        return null;
    }

    private String getToolTipForSQLObjects(List<SQLObject> v, String paramName, int paramNumber) {
        int i;
        SQLObject so = v.get(0);
        FunctionDocX doc = (FunctionDocX)so.getCustomProperty("doc");
        StringBuilder html = new StringBuilder("<html>");
        String syn = this.getSynonymName(so);
        if (syn != null) {
            html.append("Synonym <b>").append(syn).append("</b> for: <br><br>");
        }
        html.append(this.getTypeFromObject(so));
        html.append("&nbsp;<b>").append(so.getFullName()).append("</b>");
        if (so.getParameters().size() > 0) {
            html.append("&nbsp;(<br>&nbsp;&nbsp;&nbsp;");
            for (i = 0; i < so.getParameters().size(); ++i) {
                boolean paramMatch = false;
                ISQLColumn param = so.getParameters().get(i);
                if (i % 3 == 0 && i > 0) {
                    html.append("<br>, &nbsp;");
                } else if (i > 0) {
                    html.append(", &nbsp;");
                }
                if (paramName != null) {
                    if (param.getName().equalsIgnoreCase(paramName)) {
                        paramMatch = true;
                    }
                } else if (i == paramNumber) {
                    paramMatch = true;
                }
                if (paramMatch) {
                    html.append("<b>");
                }
                if (doc != null && doc.getArgs().size() > i) {
                    html.append(doc.getArgs().get(i).getName());
                } else {
                    html.append(param.getName());
                }
                if (paramMatch) {
                    html.append("</b>");
                }
                html.append("&nbsp;").append(param.getType());
                String def = param.getDefault();
                if (def != null) {
                    html.append("&nbsp;=&nbsp;").append(def);
                }
                if (!param.isOutput()) continue;
                html.append(" OUTPUT");
            }
            html.append("<br>)");
        }
        if (doc != null) {
            html.append("<br><br>").append(doc.getDescription());
            for (i = 0; i < doc.getArgs().size(); ++i) {
                if (i == 0) {
                    html.append("<h3>Parameters</h3>");
                }
                FunctionArgs functionArgs = doc.getArgs().get(i);
                html.append("<b>").append(functionArgs.getName()).append("</b>");
                if (StringUtils.isNotEmpty(functionArgs.getDescription())) {
                    html.append("&nbsp;-&nbsp;").append(functionArgs.getDescription().replace("\n", "<br>"));
                }
                html.append("<br>");
            }
        }
        html.append("<br>");
        if (so.getColumns().stream().filter(f -> f.getName() != null).findAny().isPresent()) {
            if (so.ofType(SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.TABLE_FUNCTION)) {
                html.append("Returns table: (<br>").append("&nbsp;&nbsp;&nbsp;");
            } else {
                html.append("Columns: (<br>").append("&nbsp;&nbsp;&nbsp;");
            }
            int x = 0;
            html.append("<pre>");
            for (int j = 0; j < so.getColumns().size(); ++j) {
                ISQLColumn col = so.getColumns().get(j);
                if (col.getName() == null) continue;
                if (x % 2 == 0 && x > 0) {
                    html.append("<br>, &nbsp;");
                } else if (x > 0) {
                    html.append(", &nbsp;");
                } else if (x == 0) {
                    html.append("  &nbsp;");
                }
                ++x;
                html.append(col.getName());
                if (col.getComputedDefinition() != null) {
                    html.append(" AS ").append(col.getComputedDefinition());
                    continue;
                }
                if (col.getType() == null) continue;
                html.append("&nbsp;").append(col.getQuotedType());
                if (col.isNullable()) continue;
                html.append(" NOT NULL");
            }
            html.append("</pre>");
            html.append("<br>)<br>");
        }
        if (StringUtils.isNotEmpty(so.getReturnType())) {
            html.append("<i>Returns ").append(so.getReturnType()).append("</i>&nbsp;&nbsp;");
        }
        html.append("<br>");
        return html.toString();
    }

    @Override
    public List<IPopupAction> getActionsForIdentifier(String lexeme, TokenFinder f, List<SQLObject> provided) {
        List<SQLObject> declareTables = this.parseTree != null ? SQLServerSQLService.getDeclaredTables(this.sqlManager.getServerContext(), this.sqlManager.getCurrentContext(), this.parseTree, f.getPosition()) : Collections.EMPTY_LIST;
        declareTables.addAll(provided);
        List<IPopupAction> popups = this.popupHandler.getActionsForIdentifier(lexeme, f, declareTables);
        if (f != null && f.getRule() != null && f.getNode().getSymbol().getType() == 963) {
            popups.add(new PopupAction("Go to declaration", () -> AdvanceEditorCommands.GotoDeclarationAction.gotoDeclaration(this.parseTree, f, this.textArea)));
            popups.add(new PopupAction("Previous occ", () -> PreviousOccurancesAction.getPreviousOccurance(this.parseTree, f, this.textArea, f.getNode().getText())));
            popups.add(new PopupAction("Next occurance", () -> NextOccurancesAction.getNextOccurance(this.parseTree, f, this.textArea, f.getNode().getText())));
        }
        return popups;
    }

    @Override
    public void close() throws IOException {
        ((RTextArea)this.textArea).setToolTipSupplier(null);
        this.textArea = null;
        this.parseTree = null;
        this.contextHash.clear();
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    @Override
    public void completionPerformed(BasicSQLCompletion c, DatabaseContext context) {
    }

    @Override
    public void completionPerformed(SQLObject c, Optional<IUsageObject> sub, DatabaseContext context) {
        SQLObjectUsage usage = SQLObjectUsage.createFromObject(sub.isPresent() ? sub.get() : c, context);
        if (usage != null) {
            this.sqlManager.addUsage(c, sub);
        }
    }

    private class TokenReScanner
    extends ADocumentAdapter {
        private TokenReScanner() {
        }

        protected void setValueFromDocument(DocumentEvent e) {
            DBCompletion.this.needReScan = true;
            IParseResult rs = DBCompletion.this.parser.parse((RSyntaxTextArea)DBCompletion.this.textArea);
            ThrowingConsumer futureTree = t -> {
                DBCompletion.this.parseTree = (SQLFile)t;
                DBCompletion.this.needReScan = false;
            };
            Optional<ClauseHolder> x = rs.getParseTree((ThrowingConsumer<ClauseHolder>)futureTree);
            x.ifPresent((Consumer<ClauseHolder>)futureTree);
        }
    }
}

