/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands.diff;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.RunnerModel;
import com.siggemannen.datacomparer.DiffViewer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DiffPickAction
implements ActionListener {
    private String text;
    private RunnerModel model;
    private IEditorManager manager;

    public DiffPickAction(RunnerModel model, IEditorManager manager) {
        this.model = model;
        this.manager = manager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.text = StringUtils.isBlank((String)this.model.getSelectedScript().getValue(), this.manager.getCurrentText());
    }

    public String getText() {
        return this.text;
    }

    @Singleton
    public static class DiffPickFirstAction
    extends DiffPickAction
    implements FileRunnerAction {
        @Inject
        public DiffPickFirstAction(RunnerModel model, IEditorManager manager) {
            super(model, manager);
        }

        @Override
        public String id() {
            return "diff-pick-first";
        }
    }

    @Singleton
    public static class DiffPickSecondAction
    extends DiffPickAction
    implements FileRunnerAction {
        private DiffPickFirstAction diffFirstAction;

        @Inject
        public DiffPickSecondAction(RunnerModel model, IEditorManager manager, DiffPickFirstAction diffFirstAction) {
            super(model, manager);
            this.diffFirstAction = diffFirstAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (this.diffFirstAction.getText() != null) {
                JMemoryFrame jf = new JMemoryFrame("Diff view", "diff-main-window");
                String f1 = this.diffFirstAction.getText();
                String f2 = this.getText();
                DiffViewer dv = new DiffViewer(jf.getContentPane(), new String[]{f1, f2});
                if (!jf.isSizeSetFromSettings()) {
                    jf.setPreferredSize(new Dimension(640, 480));
                    jf.pack();
                }
                jf.setLocationRelativeTo(null);
                jf.setDefaultCloseOperation(2);
                jf.setVisible(true);
                dv.getDiffAction().actionPerformed(e);
            }
        }

        @Override
        public String id() {
            return "diff-pick-second";
        }
    }
}

