/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands.diff;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.JMemoryFrame;
import com.siggemannen.datacomparer.DiffViewer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

@Singleton
public class DiffCommandAction
implements FileRunnerAction {
    private IEditorManager manager;

    @Inject
    public DiffCommandAction(IEditorManager manager) {
        this.manager = manager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMemoryFrame jf = new JMemoryFrame("Diff view", "diff-main-window");
        String f1 = this.manager.getCurrentText();
        String f2 = ClipboardUtils.getStringDataFromClipboard();
        new DiffViewer(jf.getContentPane(), new String[]{f1, f2});
        if (!jf.isSizeSetFromSettings()) {
            jf.setPreferredSize(new Dimension(640, 480));
            jf.pack();
        }
        jf.setLocationRelativeTo(null);
        jf.setDefaultCloseOperation(2);
        jf.setVisible(true);
    }

    @Override
    public String id() {
        return "diff-main";
    }
}

