/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.CardHolderChangeTracker;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.view.EditorManager;
import com.sigge.filerunner.view.editors.FrozenTabsDialog;
import com.sigge.filerunner.view.editors.TabsDialog;
import com.sigge.filerunner.view.project.ProjectTreeHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabManager;
import com.sigge.filerunner.view.tabs.TabRendererSupplier;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class TabCommands {

    @Singleton
    public static class DisplayFrozenTabsAction
    implements FileRunnerAction {
        @Inject
        private EditorManager manager;
        @Inject
        @Named(value="mainFrame")
        private JFrame mainFrame;

        private void changeActiveTab(FrozenTabsDialog td) {
            TabContent tc = (TabContent)td.getTabList().getSelectedValue();
            int idx = td.getTabList().getSelectedIndex();
            if (tc != null) {
                td.setVisible(false);
                td.dispose();
                if (tc.isAFile()) {
                    FileUtils.displayFileMessages(this.manager.openFiles(Arrays.asList(new File(tc.getFileName()))));
                } else {
                    this.manager.newFile(tc.getTitle(), tc.getContent(), tc.getContentType());
                }
                ConfigHandler.getConfig().getFrozenContents().remove(idx);
                if (td.getTabList().getSelectedValue() == null && td.getTabList().getModel().getSize() > 0) {
                    td.getTabList().setSelectedIndex(0);
                }
                this.updatePreview(td);
            }
        }

        private void removeActiveTab(FrozenTabsDialog td) {
            TabContent tc = (TabContent)td.getTabList().getSelectedValue();
            int idx = td.getTabList().getSelectedIndex();
            if (tc != null) {
                ConfigHandler.getConfig().getFrozenContents().remove(idx);
                ((DefaultListModel)td.getTabList().getModel()).remove(idx);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<TabContent> view = ConfigHandler.getConfig().getFrozenContents();
            final FrozenTabsDialog td = new FrozenTabsDialog(this.mainFrame, false);
            td.getTabList().setSelectionMode(0);
            td.getTabList().setCellRenderer(TabRendererSupplier.get());
            DefaultListModel lm = new DefaultListModel();
            view.stream().forEachOrdered(lm::addElement);
            td.getTabList().setModel(lm);
            td.getTabList().addListSelectionListener(e1 -> this.updatePreview(td));
            td.getOpenTabButton().addActionListener(a -> this.changeActiveTab(td));
            td.getRemoveTabButton().addActionListener(a -> this.removeActiveTab(td));
            td.getTabList().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        this.changeActiveTab(td);
                    }
                }
            });
            td.getTabList().addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.changeActiveTab(td);
                    }
                }
            });
            td.centerOnCorrectScreen(this.mainFrame);
            td.setVisible(true);
        }

        private void updatePreview(FrozenTabsDialog td) {
            TabContent tc = (TabContent)td.getTabList().getSelectedValue();
            RSyntaxTextArea preview = td.getPreview();
            TextPaneUtil.configureSyntaxTextArea(preview);
            if (tc == null) {
                preview.setText("");
                preview.discardAllEdits();
                preview.setCaretPosition(0);
                return;
            }
            preview.setSyntaxEditingStyle(tc.getContentType() != null ? tc.getContentType() : "text/tsql");
            preview.setText(tc.getContent());
            preview.setCaretPosition(0);
        }

        @Override
        public String id() {
            return "display-frozen-tabs";
        }
    }

    @Singleton
    public static class DisplayTabsAction
    implements FileRunnerAction {
        @Inject
        private CardHolder<TabContent> holder;
        @Inject
        @Named(value="mainFrame")
        private JFrame mainFrame;

        private void changeActiveTab(TabsDialog td, CardHolderChangeTracker listener) {
            TabContent tc = (TabContent)td.getTabList().getSelectedValue();
            td.setVisible(false);
            td.dispose();
            this.holder.removeListener(listener);
            if (tc != null) {
                this.holder.current(tc);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<TabContent> view = this.holder.historyView();
            final TabsDialog td = new TabsDialog(this.mainFrame, false);
            td.getTabList().setSelectionMode(0);
            td.getTabList().setCellRenderer(TabRendererSupplier.get());
            final DefaultListModel lm = new DefaultListModel();
            view.stream().forEachOrdered(lm::addElement);
            td.getTabList().setModel(lm);
            td.getTabList().addListSelectionListener(e1 -> this.updatePreview(td));
            td.getTabList().setSelectedValue((Object)this.holder.current(), true);
            final CardHolderChangeTracker listener = new CardHolderChangeTracker(){

                @Override
                public void onChange() {
                    lm.clear();
                    List view = holder.historyView();
                    view.stream().forEachOrdered(lm::addElement);
                    td.getTabList().setModel((ListModel)lm);
                    td.getTabList().setSelectedValue(holder.current(), true);
                }
            };
            this.holder.addListener(listener);
            td.getTabList().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        this.changeActiveTab(td, listener);
                    }
                }
            });
            td.getTabList().addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.changeActiveTab(td, listener);
                    }
                }
            });
            td.centerOnCorrectScreen(this.mainFrame);
            td.setVisible(true);
        }

        private void updatePreview(TabsDialog td) {
            TabContent tc = (TabContent)td.getTabList().getSelectedValue();
            if (tc == null) {
                return;
            }
            RSyntaxTextArea preview = td.getPreview();
            TextPaneUtil.configureSyntaxTextArea(preview);
            preview.setSyntaxEditingStyle(tc.getContentType() != null ? tc.getContentType() : "text/tsql");
            preview.setText("");
            preview.setText(tc.getContent());
            preview.discardAllEdits();
            preview.setCaretPosition(0);
        }

        @Override
        public String id() {
            return "display-active-tabs";
        }
    }

    @Singleton
    public static class SaveAsFileAction
    implements FileRunnerAction {
        @Inject
        TabManager tabManager;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tabManager.saveFile(true);
        }

        @Override
        public String id() {
            return "save_as";
        }
    }

    @Singleton
    public static class SaveWithEncodingAction
    implements FileRunnerAction {
        @Inject
        TabManager tabManager;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tabManager.saveFile(e.getActionCommand());
        }

        @Override
        public String id() {
            return "saveEncoding";
        }
    }

    @Singleton
    public static class SaveFileAction
    implements FileRunnerAction {
        @Inject
        TabManager tabManager;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tabManager.saveFile();
        }

        @Override
        public String id() {
            return "save";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }

    @Singleton
    public static class RestoreTabAction
    implements FileRunnerAction {
        @Inject
        private CardHolder<TabContent> holder;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.holder.restore();
        }

        @Override
        public String id() {
            return "restore";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class OpenDirectoryAction
    implements FileRunnerAction {
        @Inject
        ProjectTreeHandler treeHandler;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.treeHandler.add();
        }

        @Override
        public String id() {
            return "opendir";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return null;
        }
    }

    @Singleton
    public static class OpenTabAction
    implements FileRunnerAction {
        @Inject
        TabManager tabManager;

        @Override
        public void actionPerformed(ActionEvent e) {
            TabContent tc = this.tabManager.currentTab();
            if (tc != null && tc.isAFile()) {
                File dir = new File(tc.getFileName()).getParentFile();
                FileUtils.displayFileMessages(this.tabManager.openFile(dir));
            } else {
                FileUtils.displayFileMessages(this.tabManager.openFile());
            }
        }

        @Override
        public String id() {
            return "open";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }

    @Singleton
    public static class NewTabAction
    implements FileRunnerAction {
        @Inject
        TabManager tabManager;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tabManager.add();
        }

        @Override
        public String id() {
            return "new";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }

    @Singleton
    public static class RemoveAll
    implements FileRunnerAction {
        @Inject
        CardHolder<TabContent> holder;
        @Inject
        @Named(value="mainTab")
        DnDTabbedPane tabPane;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog((Component)this.tabPane, "Do you want to close all tabs?", "Confirm removal", 0) != 0) {
                return;
            }
            this.holder.removeAll();
        }

        @Override
        public String id() {
            return "close_all";
        }
    }

    @Singleton
    public static class RemoveRight
    implements FileRunnerAction {
        @Inject
        CardHolder<TabContent> holder;
        @Inject
        @Named(value="mainTab")
        DnDTabbedPane tabPane;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog((Component)this.tabPane, "Do you want to remove the tabs to the right?", "Confirm removal", 0) != 0) {
                return;
            }
            this.holder.removeRight();
        }

        @Override
        public String id() {
            return "close_right";
        }
    }

    @Singleton
    public static class RemoveLeft
    implements FileRunnerAction {
        @Inject
        CardHolder<TabContent> holder;
        @Inject
        @Named(value="mainTab")
        DnDTabbedPane tabPane;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog((Component)this.tabPane, "Do you want to remove the tabs to the left?", "Confirm removal", 0) != 0) {
                return;
            }
            this.holder.removeLeft();
        }

        @Override
        public String id() {
            return "close_left";
        }
    }

    @Singleton
    public static class RemoveOthers
    implements FileRunnerAction {
        @Inject
        CardHolder<TabContent> holder;
        @Inject
        @Named(value="mainTab")
        DnDTabbedPane tabPane;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog((Component)this.tabPane, "Do you want to remove all other tabs?", "Confirm removal", 0) != 0) {
                return;
            }
            this.holder.removeOthers();
        }

        @Override
        public String id() {
            return "close_others";
        }
    }

    @Singleton
    public static class FreezeTab
    implements FileRunnerAction {
        @Inject
        CardHolder<TabContent> holder;
        @Inject
        @Named(value="mainTab")
        DnDTabbedPane tabPane;

        @Override
        public void actionPerformed(ActionEvent e) {
            TabContent tc2;
            if (JOptionPane.showConfirmDialog((Component)this.tabPane, "Do you want to freeze the tab?", "Confirm freezing", 0) != 0) {
                return;
            }
            TabContent tc = this.holder.current();
            if (!tc.equals(tc2 = this.holder.removeAndChangeToPrevious())) {
                ConfigHandler.getConfig().getFrozenContents().add(tc);
            }
        }

        @Override
        public String id() {
            return "freeze-tab";
        }
    }

    @Singleton
    public static class CloseCurrentTab
    implements FileRunnerAction {
        @Inject
        CardHolder<TabContent> holder;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.holder.removeAndChangeToPrevious();
        }

        @Override
        public String id() {
            return "close";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }
}

