/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.sigge.filerunner.core.ITextTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexTextTransformer
extends RecordableTextAction
implements ITextTransformer {
    protected List<String> patterns = new ArrayList<String>();
    protected List<String> replaces = new ArrayList<String>();
    private final Map<String, Pattern> compiled = new HashMap<String, Pattern>();
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexTextTransformer.class);

    public RegexTextTransformer(String actionName, String ... regexPairs) {
        super(actionName);
        if (regexPairs == null || regexPairs.length % 2 == 1) {
            throw new IllegalArgumentException("regexPairs cannot be null or odd numbered");
        }
        int i = 0;
        while (i < regexPairs.length) {
            this.patterns.add(regexPairs[i]);
            this.replaces.add(regexPairs[i + 1]);
            i += 2;
        }
    }

    @Override
    public String transform(String text) {
        if (text == null || text.length() == 0 || this.patterns.size() == 0) {
            return text;
        }
        int i = 0;
        while (i < this.patterns.size()) {
            String patt = this.patterns.get(i);
            Pattern p = this.compiled.computeIfAbsent(patt, l -> Pattern.compile(patt));
            Matcher m = p.matcher(text);
            text = m.replaceAll(this.replaces.get(i));
            ++i;
        }
        return text;
    }

    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        if (!textArea.isEditable() || !textArea.isEnabled()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            return;
        }
        boolean changingSelection = true;
        String selection = textArea.getSelectedText();
        if (selection == null) {
            try {
                TextPaneUtil.TextLineStartEnd startEnd = TextPaneUtil.getStartEndNewline(textArea);
                selection = textArea.getDocument().getText(startEnd.getStart(), startEnd.getEnd() - startEnd.getStart());
                changingSelection = false;
            }
            catch (Exception ee) {
                LOGGER.error("Failed to get selected text", (Throwable)ee);
                return;
            }
        }
        if (selection != null) {
            textArea.beginAtomicEdit();
            if (changingSelection) {
                textArea.replaceSelection(this.transform(selection));
            } else {
                TextPaneUtil.replaceCurrentLine(textArea, this.transform(selection));
            }
            textArea.endAtomicEdit();
        }
    }

    public String getMacroID() {
        return this.getName();
    }
}

