/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.Feedbacker;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.view.editors.FrozenTabsDialog;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.runners.SQLScriptReporter;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabRendererSupplier;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

@Singleton
public class DisplayRemovedTabsAction
implements FileRunnerAction {
    @Inject
    @Named(value="mainFrame")
    private JFrame mainFrame;
    @Inject
    SQLScriptReporter reporter;
    @Inject
    CardHolder<TabContent> holder;

    private void changeActiveTab(FrozenTabsDialog td) {
        List tc = td.getTabList().getSelectedValuesList();
        if (tc.size() > 0) {
            int failures = 0;
            for (TabContent t : tc) {
                if (this.holder.restore(t) != null) continue;
                ++failures;
            }
            if (failures > 0) {
                new Feedbacker("Couldn't restore " + (failures > 1 ? failures + " tabs" : "tab"), this.mainFrame).title("Error during restoring").messageType(Feedbacker.ButtonType.INFO).display();
            } else {
                td.setVisible(false);
                td.dispose();
            }
        }
    }

    private void removeActiveTabs(FrozenTabsDialog td) {
        List tc = td.getTabList().getSelectedValuesList();
        if (tc.size() > 0 && new Feedbacker("Are you sure you want to remove the tab" + (tc.size() > 1 ? "s" : "") + "?", this.mainFrame).title("Confirm permanent deletion").messageType(Feedbacker.ButtonType.YES_NO).display() == IFeedback.IFeedbackResult.FIRST) {
            for (TabContent t : tc) {
                this.holder.removeCompletely(t);
                ((DefaultListModel)td.getTabList().getModel()).removeElement(t);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<TabContent> view = new ArrayList<TabContent>();
        List<TabContent> current = this.holder.historyView();
        Map<? extends TabContent, SQLScriptState> fullState = this.reporter.getFullState();
        for (TabContent tabContent : fullState.keySet()) {
            if (current.contains(tabContent)) continue;
            view.add(tabContent);
        }
        final FrozenTabsDialog frozenTabsDialog = new FrozenTabsDialog(this.mainFrame, false);
        frozenTabsDialog.setTitle("Removed tabs");
        frozenTabsDialog.getOpenTabButton().setText("Open tab(s)");
        frozenTabsDialog.getRemoveTabButton().setText("Remove tab(s)");
        frozenTabsDialog.getTabList().setSelectionMode(2);
        frozenTabsDialog.getTabList().setCellRenderer(TabRendererSupplier.get());
        DefaultListModel lm = new DefaultListModel();
        view.stream().forEachOrdered(lm::addElement);
        frozenTabsDialog.getTabList().setModel(lm);
        frozenTabsDialog.getTabList().addListSelectionListener(e1 -> this.updatePreview(td));
        frozenTabsDialog.getOpenTabButton().addActionListener(a -> this.changeActiveTab(td));
        frozenTabsDialog.getRemoveTabButton().addActionListener(a -> this.removeActiveTabs(td));
        frozenTabsDialog.getTabList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DisplayRemovedTabsAction.this.changeActiveTab(frozenTabsDialog);
                }
            }
        });
        frozenTabsDialog.getTabList().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DisplayRemovedTabsAction.this.changeActiveTab(frozenTabsDialog);
                }
            }
        });
        frozenTabsDialog.centerOnCorrectScreen(this.mainFrame);
        frozenTabsDialog.setVisible(true);
    }

    private void updatePreview(FrozenTabsDialog td) {
        TabContent tc = (TabContent)td.getTabList().getSelectedValue();
        RSyntaxTextArea preview = td.getPreview();
        TextPaneUtil.configureSyntaxTextArea(preview);
        if (tc == null) {
            preview.setText("");
            preview.setCaretPosition(0);
            return;
        }
        preview.setSyntaxEditingStyle(tc.getContentType() != null ? tc.getContentType() : "text/tsql");
        preview.setText(tc.getContent());
        preview.discardAllEdits();
        preview.setCaretPosition(0);
    }

    @Override
    public String id() {
        return "list-deleted-tabs";
    }
}

