/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.commands.KeywordsFormatter;
import com.sigge.filerunner.commands.RegexTextTransformer;
import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.sql.sqlserver.CaretPosition;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.SQLServerSQLService;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.editors.SnippetInserter;
import com.sigge.filerunner.view.rsyntaxtextarea.LowerSelectionCaseActionFixed;
import com.sigge.filerunner.view.rsyntaxtextarea.SingleLineCommentToggleAction;
import com.sigge.filerunner.view.rsyntaxtextarea.UpperSelectionCaseActionFixed;
import com.sigge.filerunner.view.tools.SQLTool;
import com.siggemannen.core.Tuple;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;

public class AdvanceEditorCommands {

    @Singleton
    public static class InsertSnippetAction
    implements FileRunnerAction {
        private final IEditorManager manager;
        private final SnippetInserter snipper;
        private final JFrame mainFrame;

        @Inject
        InsertSnippetAction(IEditorManager manager, SnippetInserter snipper, @Named(value="mainFrame") JFrame mainFrame) {
            this.manager = manager;
            this.snipper = snipper;
            this.mainFrame = mainFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Config c = ConfigHandler.getConfig();
            SQLTool tool = this.snipper.present(c.getSqlTools(), this.mainFrame);
            if (tool != null) {
                this.manager.getCurrentTab().replaceSelection(tool.getCommand());
            }
        }

        @Override
        public String id() {
            return "insertSnippet";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class KeywordsFormatterAction
    implements FileRunnerAction {
        private final KeywordsFormatter keywordsFormatter = new KeywordsFormatter("keywordsFormatter");
        private final IEditorManager manager;

        @Inject
        KeywordsFormatterAction(IEditorManager manager) {
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.keywordsFormatter.actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, this.keywordsFormatter.getName()));
        }

        @Override
        public String id() {
            return "keywordsFormatter";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class MultilineCommentAction
    implements FileRunnerAction {
        RegexTextTransformer multilineCommentor = new RegexTextTransformer(this.id(), "(?s)^(.*)$", "/*$1*/");
        private final IEditorManager manager;

        @Inject
        MultilineCommentAction(IEditorManager manager) {
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.multilineCommentor.actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, this.multilineCommentor.getName()));
        }

        @Override
        public String id() {
            return "comment-multiline";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class ToggleCommentsAction
    implements FileRunnerAction {
        SingleLineCommentToggleAction slc = new SingleLineCommentToggleAction("Toggle comments", null, null, null, null, l -> ((DBCompletion)((Tuple)completionMap.get(manager.getCurrentTab())).second()).getTokensOnLine(l));

        @Inject
        ToggleCommentsAction(IEditorManager manager, Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.slc.actionPerformed(e);
        }

        @Override
        public String id() {
            return "comment-toggle";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class GotoDeclarationAction
    implements FileRunnerAction {
        private final IEditorManager manager;
        private final Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap;

        @Inject
        GotoDeclarationAction(IEditorManager manager, Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap) {
            this.manager = manager;
            this.completionMap = completionMap;
        }

        @Override
        public String id() {
            return "goto-declaration";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea getCurrentTab = this.manager.getCurrentTab();
            DBCompletion provider = (DBCompletion)this.completionMap.get(getCurrentTab).second();
            SQLFile file = provider.getParseTree();
            if (file == null) {
                return;
            }
            TokenFinder w = CompletionUtils.getTokenAtPosition(file.getContext(), Math.min(getCurrentTab.getCaret().getDot(), getCurrentTab.getCaret().getMark()), Math.max(getCurrentTab.getCaret().getDot(), getCurrentTab.getCaret().getMark()));
            if (w == null || w.getRule() == null) {
                return;
            }
            if (w.getRule() != null && w.getNode().getSymbol().getType() == 963) {
                GotoDeclarationAction.gotoDeclaration(file, w, (JTextComponent)getCurrentTab);
            }
        }

        public static void gotoDeclaration(SQLFile file, TokenFinder w, JTextComponent getCurrentTab) {
            int caretpos = getCurrentTab.getCaretPosition();
            List<DeclareBlock> params = SQLServerSQLService.getDeclaredVariables(file, caretpos);
            for (DeclareBlock db : params) {
                if (!db.getVariable().equalsIgnoreCase(w.getNode().getText())) continue;
                SwingUtilities.invokeLater(() -> getCurrentTab.setCaretPosition(db.variableToken.getStartIndex()));
            }
        }
    }

    @Singleton
    public static class MarkSQLClauseAction
    implements FileRunnerAction {
        private final IEditorManager manager;
        private final Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap;

        @Inject
        MarkSQLClauseAction(IEditorManager manager, Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap) {
            this.manager = manager;
            this.completionMap = completionMap;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea getCurrentTab = this.manager.getCurrentTab();
            DBCompletion provider = (DBCompletion)this.completionMap.get(getCurrentTab).second();
            SQLFile file = provider.getParseTree();
            Clause cc = ClauseUtility.findOuterest(file, new CaretPosition((RTextArea)getCurrentTab));
            if (cc != null) {
                getCurrentTab.select(cc.getContext().start.getStartIndex(), cc.getContext().stop.getStopIndex() + 1);
            }
        }

        @Override
        public String id() {
            return "mark-statement";
        }
    }

    @Singleton
    public static class SwitchExpressionAction
    implements FileRunnerAction {
        RegexTextTransformer sEquals = new RegexTextTransformer("switchEquals", "(^|\\s*)([^\\s]+)(\\s*)(=|,|<|<=|>=|\\-|\\+)(\\s*)([^\\s]+)", "$1$6$3$4$5$2");
        private final IEditorManager manager;

        @Inject
        SwitchExpressionAction(IEditorManager manager) {
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sEquals.actionPerformed(new ActionEvent(this.manager.getCurrentTab(), e.getID(), this.sEquals.getName()));
        }

        @Override
        public String id() {
            return "switchEquals";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class LowercaseSelectionAction
    implements FileRunnerAction {
        private final LowerSelectionCaseActionFixed lsca = new LowerSelectionCaseActionFixed();
        private final IEditorManager manager;

        @Inject
        public LowercaseSelectionAction(IEditorManager manager) {
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.lsca.actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, this.lsca.getName()));
        }

        @Override
        public String id() {
            return "lowercase-selection";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }

    @Singleton
    public static class UppercaseSelectionAction
    implements FileRunnerAction {
        private final UpperSelectionCaseActionFixed usca = new UpperSelectionCaseActionFixed();
        private final IEditorManager manager;

        @Inject
        public UppercaseSelectionAction(IEditorManager manager) {
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.usca.actionPerformed(new ActionEvent(this.manager.getCurrentTab(), 0, this.usca.getName()));
        }

        @Override
        public String id() {
            return "uppercase-selection";
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        }
    }
}

