/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import com.sigge.filerunner.RunnerModule;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.InstanceActivationHandler;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.DatabaseModule;
import com.sigge.filerunner.sql.sqlserver.TSQLFoldParser;
import com.sigge.filerunner.view.Runner;
import com.sigge.filerunner.view.RunnerPresenter;
import com.sigge.filerunner.view.SwingExceptionHandler;
import com.sigge.filerunner.view.editors.EditorModule;
import com.sigge.filerunner.view.menu.MenuBuilder;
import com.sigge.filerunner.view.menu.MenuModule;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.search.SearchModule;
import com.sigge.filerunner.view.tabs.TabRendererSupplier;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.awt.Insets;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static void main(String[] args) {
        System.out.println("Main started:" + LocalDateTime.now());
        System.setProperty("org.geotools.referencing.forceXY", "true");
        System.setProperty("hsqldb.reconfig_logging", "false");
        UIManager.put("TabbedPane.selectedTabPadInsets", new Insets(2, 2, 2, 0));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FileRunner");
        FilesAcceptor fc = new FilesAcceptor();
        if (InstanceActivationHandler.activateRunning(args, fc)) {
            return;
        }
        Logger LOGGER = LoggerFactory.getLogger(Main.class);
        LOGGER.info("Instance started");
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/tsql", "com.sigge.filerunner.view.rsyntaxtextarea.TSQLTokenMaker");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(() -> {
            try {
                RSQLSyntaxTextArea r = new RSQLSyntaxTextArea("", "text/sql");
                r.setText("select top 30 *");
            }
            catch (Throwable r) {
                // empty catch block
            }
            try {
                Path path = Paths.get("db", "internal");
                if (path.toFile().exists()) {
                    Files.walk(path, new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).filter(n -> n.getName().contains(".buf")).forEach(x -> x.delete());
                }
            }
            catch (Exception exxx) {
                LOGGER.error("Error while cleaning internal", (Throwable)exxx);
            }
        }).start();
        ImageIO.setUseCache(false);
        LOGGER.info("init");
        try {
            ConfigHandler.load();
            if (ConfigHandler.isConfigError()) {
                StringBuilder message = new StringBuilder("Error occured during loading config, probably due to malformed JSON.").append(ConfigHandler.isBackupError() ? " Additionally, backup couldn't be created." : " A backup of original config was saved. ").append("Do you want to exit program and correct the file?").append(ConfigHandler.isBackupError() ? " If you continue, you will lose original configuration file!" : "");
                Object[] options = new Object[]{"Continue using program" + (ConfigHandler.isBackupError() ? " and lose your config file" : ""), "Exit"};
                int result = JOptionPane.showOptionDialog(null, message, "Error during config load", 0, -1, null, options, null);
                if (result == 1 || result == -1) {
                    System.exit(1);
                }
            }
            Thread.setDefaultUncaughtExceptionHandler(new SwingExceptionHandler());
            Config config = ConfigHandler.getConfig();
            config.assignDatabaseIds();
            LOGGER.info("Guicing");
            Injector ie = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new RunnerModule(), new MenuModule(), new SearchModule(), new DatabaseModule(), new EditorModule()});
            LOGGER.info("Finished Guicing");
            DatabaseManager dm = (DatabaseManager)ie.getInstance(DatabaseManager.class);
            ie.getInstance(TabRendererSupplier.class);
            ie.getInstance(MenuBuilder.class);
            LOGGER.info("Finished Guicing32");
            TSQLFoldParser parser = (TSQLFoldParser)ie.getInstance(TSQLFoldParser.class);
            FoldParserManager.get().addFoldParserMapping("text/tsql", (FoldParser)parser);
            dm.loadDatabasesFromConfig((ThrowingConsumer<Exception>)((ThrowingConsumer)e -> LOGGER.error("Error while loading databases", (Throwable)e)));
            JFrame f = (JFrame)ie.getInstance(Key.get(JFrame.class, (Annotation)Names.named((String)"mainFrame")));
            f.pack();
            LOGGER.info("afterMainFrame");
            Runner runner = (Runner)ie.getInstance(Runner.class);
            runner.setServers(config.getDatabases());
            runner.setDefaultPath(config.getLastDirectory());
            runner.setScriptMode(true);
            runner.setContents(config.getContents());
            runner.setCurrentIndex(config.getLastContentIndex());
            LOGGER.info("afterGUI");
            RunnerPresenter presenter = (RunnerPresenter)ie.getInstance(RunnerPresenter.class);
            LOGGER.info("afterPresenter");
            presenter.setObject(runner);
            LOGGER.info("afterRunner");
            fc.accept(Arrays.asList(args));
            fc.setRunner(presenter);
            f.addWindowListener(presenter);
            LOGGER.info("afterDone");
            SwingUtilities.invokeLater(() -> f.setVisible(true));
        }
        catch (Exception e2) {
            LOGGER.error("Exception in main-thread", (Throwable)e2);
            StringWriter s = new StringWriter();
            e2.printStackTrace(new PrintWriter(s));
            JOptionPane.showMessageDialog(null, s.toString());
            InstanceActivationHandler.shutdown();
            System.exit(1);
        }
    }

    private static class FilesAcceptor
    implements Consumer<List<String>> {
        private RunnerPresenter rp;
        List<String> queue = new ArrayList<String>();

        private FilesAcceptor() {
        }

        @Override
        public synchronized void accept(List<String> t) {
            this.queue.addAll(t);
            if (this.rp != null) {
                this.processQueue();
            }
        }

        public void setRunner(RunnerPresenter rp) {
            this.rp = rp;
            this.processQueue();
        }

        private void processQueue() {
            ArrayList<String> q = new ArrayList<String>(this.queue);
            ArrayList<File> fromArgs = new ArrayList<File>();
            this.queue.clear();
            for (String potentialFile : q) {
                if (StringUtils.isEmpty(potentialFile)) continue;
                try {
                    File f = new File(potentialFile);
                    if (!f.exists() || !f.isFile()) continue;
                    fromArgs.add(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fromArgs.size() > 0) {
                this.rp.openFiles(fromArgs, true);
            }
        }
    }
}

