/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.binding;

import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.IView;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class Binder {
    public static <E> Presenter<E> bindToCombo(JComboBox<E> combo, List<E> values) {
        return Binder.bindToCombo(combo, values, false);
    }

    public static <E> Presenter<E> bindToCombo(final JComboBox<E> combo, final List<E> values, final boolean rebind) {
        final AModel am = new AModel<ValueHolder<E>>(){

            @Override
            protected void copyObject(ValueHolder<E> object) {
                this.copy = object;
            }
        };
        Presenter ap = new Presenter(am, combo){

            @Override
            protected void initBindings() {
                this.bind(combo).to(values, am.getProperty("value"), rebind);
            }
        };
        ap.setObject(new ValueHolder<Object>((values.size() > 0 ? (Object)values.get(0) : null)));
        return ap;
    }

    public static <E, C> Presenter<E> genericBind(C component, BiConsumer<Presenter<E>, IProperty<E>> propertyBinder) {
        return Binder.genericBind(component, propertyBinder, null);
    }

    public static <E, C> Presenter<E> genericBind(C component, final BiConsumer<Presenter<E>, IProperty<E>> propertyBinder, E defaultValue) {
        final AModel am = new AModel<ValueHolder<E>>(){

            @Override
            protected void copyObject(ValueHolder<E> object) {
                this.copy = object;
            }
        };
        Presenter ap = new Presenter(am, component){

            @Override
            protected void initBindings() {
                propertyBinder.accept(this, am.getProperty("value"));
            }
        };
        ap.setObject(new ValueHolder<E>(defaultValue));
        return ap;
    }

    public static <E> Presenter<List<E>> bindToCheckboxes(final List<JCheckBox> checkboxes, final List<E> values, List<E> defaultValues) {
        final AModel am = new AModel<ValueHolder<List<E>>>(){

            @Override
            protected void copyObject(ValueHolder<List<E>> object) {
                this.copy = object;
            }
        };
        Presenter ap = new Presenter(am, checkboxes){

            @Override
            protected void initBindings() {
                this.bind(checkboxes).to(am.getListProperty("value"), values);
            }
        };
        ap.setObject(new ValueHolder<ArrayList<E>>(new ArrayList<E>(defaultValues)));
        return ap;
    }

    public static <E> Presenter<E> bindToRadioButtons(final List<JRadioButton> radios, final List<E> values) {
        final AModel am = new AModel<ValueHolder<E>>(){

            @Override
            protected void copyObject(ValueHolder<E> object) {
                this.copy = object;
            }
        };
        Presenter ap = new Presenter(am, radios){

            @Override
            protected void initBindings() {
                this.bind(radios.toArray(new JRadioButton[0])).to(am.getProperty("value"), values);
            }
        };
        ap.setObject(new ValueHolder<Object>((values.size() > 0 ? (Object)values.get(0) : null)));
        return ap;
    }

    public static <E> Presenter<E> defaultValue(E defaultValue) {
        AModel am = new AModel<ValueHolder<E>>(){

            @Override
            protected void copyObject(ValueHolder<E> object) {
                this.copy = object;
            }
        };
        Presenter ap = new Presenter(am, (Object)null){};
        ap.setObject(new ValueHolder<E>(defaultValue));
        return ap;
    }

    public static class Presenter<E>
    extends APresenter<ValueHolder<E>, AModel<ValueHolder<E>>, IView> {
        private final Object bound;

        protected Presenter(AModel<ValueHolder<E>> model, Object bound) {
            super(model, null);
            this.bound = bound;
        }

        @Override
        protected void initBindings() {
        }

        public E getValue() {
            return ((ValueHolder)((AModel)this.getModel()).getObject()).getValue();
        }

        public Object getBound() {
            return this.bound;
        }

        public Presenter<E> addValueChangedListener(ThrowingConsumer<E> x, boolean trigger) {
            this.model.addModelChangeListener(() -> x.accept(this.getValue()));
            if (trigger) {
                x.accept(this.getValue());
            }
            return this;
        }
    }
}

