/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.binding;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jodd.bean.BeanUtil;

public class BeanUtils {
    private static final Map<Class, Map<String, Field>> fieldMapper = new HashMap<Class, Map<String, Field>>();

    public static <T, O> T getValue(O object, String propertyName) {
        if (!propertyName.contains(".")) {
            Field f = fieldMapper.getOrDefault(object.getClass(), Collections.EMPTY_MAP).getOrDefault(propertyName, null);
            if (f == null) {
                try {
                    f = object.getClass().getDeclaredField(propertyName);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    fieldMapper.computeIfAbsent(object.getClass(), x -> new HashMap()).put(propertyName, f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (f != null) {
                return BeanUtils.getFastValue(object, f);
            }
        }
        return (T)BeanUtil.declared.getProperty(object, propertyName);
    }

    public static <T> T getFastValue(Object object, Field f) {
        try {
            return (T)f.get(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> void setValue(Object object, T value, String propertyName) {
        BeanUtil.declared.setProperty(object, propertyName, value);
    }
}

