/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.thinlogger;

import com.siggemannen.thinlogger.ThinLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class ThinLoggerFactory
implements ILoggerFactory {
    Map<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public ThinLoggerFactory() {
        ThinLogger.lazyInit();
    }

    public Logger getLogger(String name) {
        Logger simpleLogger = this.loggerMap.get(name);
        if (simpleLogger != null) {
            return simpleLogger;
        }
        ThinLogger newInstance = new ThinLogger(name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }
}

