/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.thinlogger;

import com.siggemannen.thinlogger.Appender;
import com.siggemannen.thinlogger.FileOutputWrapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.event.Level;

public class FileAppender
implements Appender {
    private final String pattern;
    private File prevFile = null;
    private String fpattPrev = null;
    private final ReentrantLock rl = new ReentrantLock();
    private static final byte[] LINE_SEPARATOR = System.lineSeparator().getBytes();
    private final Map<File, FileOutputWrapper> ros = new HashMap<File, FileOutputWrapper>();

    public FileAppender(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean applicable(Level level) {
        return level.compareTo((Enum)Level.INFO) <= 0;
    }

    @Override
    public void append(Level level, Throwable throwable, String sb) {
        if (!this.applicable(level)) {
            return;
        }
        this.rl.lock();
        try {
            try {
                BufferedOutputStream os = this.getOs(this.getFileToAppend()).getOs();
                os.write(sb.getBytes());
                os.write(LINE_SEPARATOR);
                if (throwable != null) {
                    throwable.printStackTrace(new PrintStream(os));
                    os.write(LINE_SEPARATOR);
                }
                os.flush();
            }
            catch (Exception exception) {
                this.rl.unlock();
            }
        }
        finally {
            this.rl.unlock();
        }
    }

    private FileOutputWrapper getOs(File fileToAppend) {
        if (!this.ros.containsKey(fileToAppend)) {
            try {
                FileOutputWrapper x = new FileOutputWrapper(fileToAppend, true, 256L);
                this.ros.put(fileToAppend, x);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.ros.get(fileToAppend);
    }

    private File getFileToAppend() throws IOException {
        String fpatt = this.pattern.replace("${byDay}", this.today()).replace("${byYear}", this.toyear()).replace("${byHour}", this.tohour());
        if (this.fpattPrev == null || !this.fpattPrev.equals(fpatt)) {
            FileOutputWrapper os = this.ros.remove(this.prevFile);
            if (os != null) {
                try {
                    os.getOs().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fpattPrev = fpatt;
            File f = new File(fpatt);
            f.getParentFile().mkdirs();
            if (!f.exists()) {
                f.createNewFile();
            }
            this.prevFile = f;
        }
        return this.prevFile;
    }

    private String toyear() {
        return "" + LocalDateTime.now().getYear();
    }

    private String tohour() {
        int hour = LocalDateTime.now().getHour();
        return hour < 10 ? "0" : "" + hour;
    }

    private String today() {
        LocalDateTime now = LocalDateTime.now();
        return now.getYear() + (now.getMonthValue() < 10 ? "0" : "") + now.getMonthValue() + (now.getDayOfMonth() < 10 ? "0" : "") + now.getDayOfMonth();
    }
}

