/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.function.Predicate;

public class PredicateFactory {
    public static final DateFormat FORMAT_WITH_TIME_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final DateFormat FORMAT_WITH_TIME_MINUTE_SEC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd[ HH:mm[:ss[.SSS]]]").toFormatter();
    private static final DateTimeFormatter FORMATTER_SIMPLE = new DateTimeFormatterBuilder().appendPattern("yyyyMMdd[ HH:mm[:ss[.SSS]]]").toFormatter();
    public static final DateFormat FORMAT_YYYYMMDD_SHORT = new SimpleDateFormat("yyyyMMdd");
    public static final DateFormat FORMAT_YYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat FORMAT_WITH_TIME_AND_MS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String OPERATOR_LESS_THAN = "<=";
    public static final String OPERATOR_MORE_THAN = ">=";
    public static final String CONTAINS = "contains";
    public static final String EQUALS = "=";
    public static final Predicate ALWAYS_TRUE = t -> true;
    public static final Predicate ALWAYS_FALSE = t -> false;

    public static Predicate createStringPredicator(String b, String c) {
        if (c == null || c.length() == 0) {
            return ALWAYS_TRUE;
        }
        String PRED_STRING = c.toLowerCase();
        return t -> {
            if (t == null || !(t instanceof String)) {
                return false;
            }
            String st = (String)t;
            switch (b) {
                case "<=": {
                    return st.toLowerCase().compareTo(PRED_STRING) <= 0;
                }
                case ">=": {
                    return st.toLowerCase().compareTo(PRED_STRING) >= 0;
                }
                case "contains": {
                    return st.toLowerCase().contains(PRED_STRING);
                }
                case "=": {
                    return st.toLowerCase().equals(PRED_STRING);
                }
            }
            return false;
        };
    }

    public static boolean in(String test, String ... arr) {
        int i = 0;
        while (i < arr.length) {
            if (test.equals(arr[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Predicate createNumberIshPredicator(String b, String c) {
        if (c == null || c.length() == 0) {
            return ALWAYS_TRUE;
        }
        Double NUMBER2 = PredicateFactory.parse(c);
        if (NUMBER2 == null || !PredicateFactory.in(b, OPERATOR_LESS_THAN, OPERATOR_MORE_THAN, EQUALS)) {
            return ALWAYS_FALSE;
        }
        return t -> {
            Double num;
            if (t == null) {
                return false;
            }
            if (t instanceof Number) {
                num = ((Number)t).doubleValue();
            } else if (t instanceof String) {
                num = PredicateFactory.parse((String)t);
                if (num == null) {
                    return false;
                }
            } else {
                return false;
            }
            switch (b) {
                case "<=": {
                    return num.compareTo(NUMBER2) <= 0;
                }
                case ">=": {
                    return num.compareTo(NUMBER2) >= 0;
                }
                case "=": {
                    return num.equals(NUMBER2);
                }
            }
            return false;
        };
    }

    public static Date dateFromString(String date) throws ParseException {
        if (date.length() == 8) {
            return FORMAT_YYYYMMDD_SHORT.parse(date);
        }
        if (date.length() == 10) {
            return FORMAT_YYYYMMDD.parse(date);
        }
        if (date.length() == 10) {
            return FORMAT_YYYYMMDD.parse(date);
        }
        if (date.length() == 16) {
            return FORMAT_WITH_TIME_MINUTE.parse(date);
        }
        if (date.length() == 19) {
            return FORMAT_WITH_TIME_MINUTE_SEC.parse(date);
        }
        return FORMAT_WITH_TIME_AND_MS.parse(date);
    }

    public static Predicate createDatePredicator(String b, String c) {
        if (c == null || c.length() == 0) {
            return ALWAYS_TRUE;
        }
        if (!PredicateFactory.in(b, OPERATOR_LESS_THAN, OPERATOR_MORE_THAN, EQUALS)) {
            return ALWAYS_FALSE;
        }
        Date tempDate = null;
        LocalDate tempLd = null;
        LocalDateTime temp = null;
        try {
            tempDate = PredicateFactory.dateFromString(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            temp = PredicateFactory.localDateTimeFromString(c);
            tempLd = temp.toLocalDate();
            if (tempDate == null) {
                tempDate = Timestamp.valueOf(temp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date DATEPART = tempDate;
        LocalDate LOCAL_DATEPART = tempLd;
        LocalDateTime LOCAL_DATETIMEPART = temp;
        if (DATEPART == null) {
            return ALWAYS_FALSE;
        }
        return t -> {
            if (t == null) {
                return false;
            }
            if (!(t instanceof Comparable)) {
                return false;
            }
            Comparable<Date> cc = null;
            Comparable st = (Comparable)t;
            if (t instanceof String) {
                try {
                    st = PredicateFactory.localDateTimeFromString((String)t);
                }
                catch (Exception ex) {
                    return false;
                }
                cc = LOCAL_DATETIMEPART;
            } else if (t instanceof Date) {
                cc = DATEPART;
            } else if (t instanceof LocalDate) {
                cc = LOCAL_DATEPART;
            } else if (t instanceof LocalDateTime) {
                cc = LOCAL_DATETIMEPART;
            } else {
                return false;
            }
            switch (b) {
                case "<=": {
                    return st.compareTo(cc) <= 0;
                }
                case ">=": {
                    return st.compareTo(cc) >= 0;
                }
                case "=": {
                    return st.equals(cc);
                }
            }
            return false;
        };
    }

    public static Predicate createToStringPredicator(String b, String c) {
        if (c == null || c.length() == 0) {
            return ALWAYS_TRUE;
        }
        String PRED_STRING = c.trim().toLowerCase();
        return t -> {
            if (t == null) {
                return false;
            }
            String st = t.toString().toLowerCase().trim();
            switch (b) {
                case "<=": {
                    return st.compareTo(PRED_STRING) <= 0;
                }
                case ">=": {
                    return st.compareTo(PRED_STRING) >= 0;
                }
                case "contains": {
                    return st.contains(PRED_STRING);
                }
                case "=": {
                    return st.equals(PRED_STRING);
                }
            }
            return false;
        };
    }

    private static Double parse(String num) {
        try {
            return Double.valueOf(num);
        }
        catch (Exception ex) {
            try {
                return Double.valueOf(num.replace(",", "."));
            }
            catch (Exception ex2) {
                return null;
            }
        }
    }

    public static LocalDateTime localDateTimeFromString(String dateString) {
        TemporalAccessor tp = null;
        try {
            tp = FORMATTER.parse(dateString);
        }
        catch (Exception ex) {
            tp = FORMATTER_SIMPLE.parse(dateString);
        }
        if (tp.query(TemporalQueries.localTime()) != null) {
            return LocalDateTime.from(tp);
        }
        return LocalDateTime.of(LocalDate.from(tp), LocalTime.MIN);
    }
}

