/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractListModel;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.list.IListFilter;
import org.oxbow.swingbits.table.filter.PredicateFactory;
import org.oxbow.swingbits.util.DefaultObjectToStringTranslator;
import org.oxbow.swingbits.util.IObjectToStringTranslator;
import org.oxbow.swingbits.util.IValueWrapper;

public class DefaultCheckListModel<T>
extends AbstractListModel
implements ICheckListModel<T> {
    private static final long serialVersionUID = 1L;
    public static IObjectToStringTranslator DEFAULT_TRANSLATOR = new DefaultObjectToStringTranslator();
    private Set<T> checks = new HashSet<T>();
    private final List<T> dataList = new ArrayList<T>();
    private final Set<T> dataSet = new HashSet<T>();
    private List<T> filteredDataList = null;
    private Set<T> filteredDataSet = null;

    public DefaultCheckListModel(Collection<? extends T> data) {
        if (data == null) {
            return;
        }
        this.dataList.addAll(data);
        this.dataSet.addAll(data);
    }

    @SafeVarargs
    public DefaultCheckListModel(T ... data) {
        this((Collection<T>)Arrays.asList(data));
    }

    @Override
    public int getSize() {
        return this.dataList().size();
    }

    private List<T> dataList() {
        return this.filteredDataList == null ? this.dataList : this.filteredDataList;
    }

    private Set<T> dataSet() {
        return this.filteredDataSet == null ? this.dataSet : this.filteredDataSet;
    }

    public Object getElementAt(int index) {
        return this.dataList().get(index);
    }

    @Override
    public boolean isCheckedIndex(int index) {
        return this.checks.contains(this.dataList().get(index));
    }

    @Override
    public void setCheckedIndex(int index, boolean value) {
        T o = this.dataList().get(index);
        if (value) {
            this.checks.add(o);
        } else {
            this.checks.remove(o);
        }
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public Collection<T> getCheckedItems() {
        ArrayList<T> items = new ArrayList<T>(this.checks);
        items.retainAll(this.dataSet());
        return Collections.unmodifiableList(items);
    }

    @Override
    public void setCheckedItems(Collection<T> items) {
        HashSet<T> correctedItems = new HashSet<T>(items);
        correctedItems.retainAll(this.dataSet());
        this.checks = correctedItems;
        this.fireContentsChanged(this, 0, this.checks.size() - 1);
    }

    @Override
    public void filter(String pattern, IObjectToStringTranslator translator, IListFilter listFilter, Predicate pred) {
        if (pred != null) {
            ArrayList<T> fDataList = new ArrayList<T>();
            HashSet<T> fDataSet = new HashSet<T>();
            if (pred == PredicateFactory.ALWAYS_TRUE) {
                this.filteredDataList = null;
                this.filteredDataSet = null;
            } else if (pred != PredicateFactory.ALWAYS_FALSE) {
                for (T o : this.dataList) {
                    T value;
                    T t = value = o instanceof IValueWrapper ? ((IValueWrapper)o).getValue() : o;
                    if (!pred.test(value)) continue;
                    fDataList.add(o);
                    fDataSet.add(o);
                }
            }
            this.filteredDataList = fDataList;
            this.filteredDataSet = fDataSet;
        } else if (pattern == null || pattern.trim().length() == 0) {
            this.filteredDataList = null;
            this.filteredDataSet = null;
        } else {
            IListFilter filter = listFilter == null ? CheckListFilterType.CONTAINS : listFilter;
            IObjectToStringTranslator t = translator == null ? DEFAULT_TRANSLATOR : translator;
            String p = pattern.toLowerCase();
            ArrayList<T> fDataList = new ArrayList<T>();
            HashSet<T> fDataSet = new HashSet<T>();
            for (T o : this.dataList) {
                T value;
                T t2 = value = o instanceof IValueWrapper ? ((IValueWrapper)o).getValue() : o;
                if (!filter.include(t.translate(value), p)) continue;
                fDataList.add(o);
                fDataSet.add(o);
            }
            this.filteredDataList = fDataList;
            this.filteredDataSet = fDataSet;
        }
        this.fireContentsChanged(this, 0, this.dataList.size() - 1);
    }
}

