/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.oxbow.swingbits.list.ICheckListModel;

public class CheckListRenderer
extends JCheckBox
implements ListCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Border NO_FOCUS_BORDER;
    private static final Border SAFE_NO_FOCUS_BORDER;

    static {
        SAFE_NO_FOCUS_BORDER = NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    public CheckListRenderer() {
        this.setOpaque(true);
        this.setBorder(CheckListRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return NO_FOCUS_BORDER;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        Color bg = null;
        Color fg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            fg = UIManager.getColor("List.dropCellForeground");
            isSelected = true;
        }
        if (isSelected) {
            this.setBackground(bg == null ? list.getSelectionBackground() : bg);
            this.setForeground(fg == null ? list.getSelectionForeground() : fg);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(this.getObjectAsText(value));
        }
        this.setSelected(this.isChecked(list, index));
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = CheckListRenderer.getNoFocusBorder();
        }
        this.setBorder(border);
        return this;
    }

    protected String getObjectAsText(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private boolean isChecked(JList list, int index) {
        if (list.getModel() instanceof ICheckListModel) {
            return ((ICheckListModel)list.getModel()).isCheckedIndex(index);
        }
        return false;
    }

    @Override
    public boolean isOpaque() {
        boolean colorMatch;
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean bl = colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName) || ("font".equals(propertyName) || "foreground".equals(propertyName)) && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public static class UIResource
    extends DefaultListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

