/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.CloseableIterator;
import org.geotools.data.Query;

public interface FileGroupProvider {
    public CloseableIterator<FileGroup> getFiles(Query var1);

    public static class FileGroup {
        File mainFile = null;
        List<File> supportFiles = null;
        Map<String, Object> metadata;

        public String toString() {
            return "FileGroup [mainFile=" + this.mainFile + ", supportFiles=" + this.supportFiles + ", metadata=" + this.printMetadata(this.metadata) + "]";
        }

        private String printMetadata(Map<String, Object> metadata) {
            if (metadata != null && !metadata.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                Set<String> keys = metadata.keySet();
                for (String key : keys) {
                    builder.append(key).append("=").append(metadata.get(key)).append("\n");
                }
                return builder.toString();
            }
            return null;
        }

        public FileGroup(File mainFile, List<File> supportFiles, Map<String, Object> metadata) {
            this.mainFile = mainFile;
            this.supportFiles = supportFiles;
            this.metadata = metadata;
        }

        public void setMainFile(File mainFile) {
            this.mainFile = mainFile;
        }

        public void setSupportFiles(List<File> supportFiles) {
            this.supportFiles = supportFiles;
        }

        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public File getMainFile() {
            return this.mainFile;
        }

        public List<File> getSupportFiles() {
            return this.supportFiles;
        }
    }
}

